/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledObjectValue
extends ObjectValue
implements Serializable {
    private static final StringValue TO_STRING = new UnicodeValueImpl("__toString");
    private static final Value[] NULL_FIELDS = new Value[0];
    public Value[] _fields;
    private ObjectExtValue _object;

    public CompiledObjectValue(QuercusClass cl) {
        super(cl);
        int size = cl.getFieldSize();
        this._fields = size != 0 ? new Value[cl.getFieldSize()] : NULL_FIELDS;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (int i = 0; i < this._fields.length; ++i) {
            if (this._fields[i] == UnsetValue.UNSET) continue;
            ++size;
        }
        if (this._object != null) {
            size += this._object.getSize();
        }
        return size;
    }

    @Override
    public Value getField(Env env, StringValue key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            return this._fields[index].toValue();
        }
        if (this._object != null) {
            return this._object.getField(env, key);
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Var getFieldVar(Env env, StringValue key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            Var var = this._fields[index].toLocalVarDeclAsRef();
            this._fields[index] = var;
            return var;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldVar(env, key);
    }

    @Override
    public Value getFieldArg(Env env, StringValue key, boolean isTop) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            Var var = this._fields[index].toLocalVarDeclAsRef();
            this._fields[index] = var;
            return var;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldArg(env, key, isTop);
    }

    @Override
    public Value getFieldArgRef(Env env, StringValue key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            Var var = this._fields[index].toLocalVarDeclAsRef();
            this._fields[index] = var;
            return var;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldArgRef(env, key);
    }

    @Override
    public Value getFieldArray(Env env, StringValue key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = this._fields[index].toAutoArray();
            return this._fields[index];
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldArray(env, key);
    }

    @Override
    public Value getFieldObject(Env env, StringValue key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = this._fields[index].toAutoObject(env);
            return this._fields[index];
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.getFieldObject(env, key);
    }

    @Override
    public Value putField(Env env, StringValue key, Value value) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = this._fields[index].set(value);
            return value;
        }
        if (this._object == null) {
            this._object = new ObjectExtValue(this._quercusClass);
        }
        return this._object.putField(env, key, value);
    }

    @Override
    public void unsetField(StringValue key) {
        int index;
        if (this._fields.length > 0 && (index = this._quercusClass.findFieldIndex(key)) >= 0) {
            this._fields[index] = UnsetValue.UNSET;
            return;
        }
        if (this._object != null) {
            this._object.unsetField(key);
        }
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._quercusClass.findFunction(methodName);
    }

    @Override
    public Value getObject(Env env) {
        return this;
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Value clone(Env env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void print(Env env) {
        env.print(this.toString(env));
    }

    @Override
    public Value toArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            array.put(entry.getKey().toStringValue(), entry.getValue());
        }
        return array;
    }

    @Override
    public Value toObject(Env env) {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Set<? extends Map.Entry<Value, Value>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public Set<? extends Map.Entry<Value, Value>> sortedEntrySet() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CompiledObjectValue@" + System.identityHashCode(this) + "[" + this._quercusClass.getName() + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._fields);
        out.writeObject(this._object);
        out.writeObject(this._quercusClass.getName());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        String name;
        this._fields = (Value[])in.readObject();
        this._object = (ObjectExtValue)in.readObject();
        Env env = Env.getInstance();
        QuercusClass cl = env.findClass(name = (String)in.readObject());
        if (cl != null) {
            this.setQuercusClass(cl);
        } else {
            cl = env.getQuercus().getStdClass();
            this.setQuercusClass(cl);
            this.setIncompleteObjectName(name);
        }
    }
}

