/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import java.io.IOException;
import java.io.PrintWriter;

public class ConstStringValue
extends StringBuilderValue {
    public static final ConstStringValue EMPTY = new ConstStringValue();
    protected LongValue _longValue;
    protected DoubleValue _doubleValue;
    protected String _string;
    protected Value _key;
    protected ValueType _valueType;
    protected char[] _serializeValue;

    public ConstStringValue() {
    }

    public ConstStringValue(StringBuilderValue sb) {
        super(sb.getBuffer(), 0, sb.getOffset());
    }

    public ConstStringValue(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public ConstStringValue(char[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public ConstStringValue(char[] buffer, int length) {
        super(buffer, length);
    }

    public ConstStringValue(byte[] buffer) {
        super(buffer);
    }

    public ConstStringValue(char ch) {
        super(ch);
    }

    public ConstStringValue(String s) {
        super(s);
        this._string = s;
    }

    public ConstStringValue(char[] s) {
        super(s);
    }

    public ConstStringValue(char[] s, Value v1) {
        super(s, v1);
    }

    public ConstStringValue(byte[] s, Value v1) {
        super(s, v1);
    }

    public ConstStringValue(Value v1) {
        super(v1);
    }

    public ConstStringValue(Value v1, Value v2) {
        super(v1, v2);
    }

    public ConstStringValue(Value v1, Value v2, Value v3) {
        super(v1, v2, v3);
    }

    public boolean isStatic() {
        return true;
    }

    public LongValue toLongValue() {
        if (this._longValue == null) {
            this._longValue = LongValue.create(super.toLong());
        }
        return this._longValue;
    }

    public DoubleValue toDoubleValue() {
        if (this._doubleValue == null) {
            this._doubleValue = new DoubleValue(super.toDouble());
        }
        return this._doubleValue;
    }

    public long toLong() {
        return this.toLongValue().toLong();
    }

    public double toDouble() {
        return this.toDoubleValue().toDouble();
    }

    public ValueType getValueType() {
        if (this._valueType == null) {
            this._valueType = super.getValueType();
        }
        return this._valueType;
    }

    public Value toKey() {
        if (this._key == null) {
            this._key = super.toKey();
        }
        return this._key;
    }

    public void serialize(Env env, StringBuilder sb) {
        if (this._serializeValue == null) {
            StringBuilder s = new StringBuilder();
            super.serialize(env, s);
            int len = s.length();
            this._serializeValue = new char[len];
            s.getChars(0, len, this._serializeValue, 0);
        }
        sb.append(this._serializeValue, 0, this._serializeValue.length);
    }

    public void generate(PrintWriter out) throws IOException {
        int maxSublen = 65534;
        int len = this.length();
        if (len == 1) {
            out.print("(ConstStringValue.create((char) '");
            ConstStringValue.printJavaChar(out, this.charAt(0));
            out.print("'))");
        } else if (len < maxSublen) {
            out.print("(new CompiledConstStringValue (\"");
            ConstStringValue.printJavaString(out, this);
            out.print("\", ");
            this.toLongValue().generate(out);
            out.print(", ");
            this.toDoubleValue().generate(out);
            out.print(", ");
            out.print(this.getValueType());
            out.print(", ");
            Value key = this.toKey();
            if (key instanceof LongValue) {
                key.generate(out);
                out.print(", ");
            }
            out.print(this.hashCode());
            out.print("))");
        } else {
            out.print("(new ConstStringValue(new StringBuilderValue (\"");
            for (int i = 0; i < len; i += maxSublen) {
                if (i != 0) {
                    out.print("\").append(\"");
                }
                ConstStringValue.printJavaString(out, this.substring(i, Math.min(i + maxSublen, len)));
            }
            out.print("\")))");
        }
    }

    public String toString() {
        if (this._string == null) {
            this._string = super.toString();
        }
        return this._string;
    }
}

