/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetStringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeStringBuilderValue
extends StringValue {
    public static final StringValue EMPTY = StringBuilderValue.EMPTY;
    public static final int SIZE = 4096;
    protected byte[][] _bufferList;
    protected int _length;
    private int _hashCode;
    private String _value;

    public LargeStringBuilderValue() {
        this._bufferList = new byte[32][];
        this._bufferList[0] = new byte[4096];
    }

    public LargeStringBuilderValue(byte[][] bufferList, int length) {
        this._bufferList = bufferList;
        this._length = length;
    }

    public LargeStringBuilderValue(StringValue s) {
        this();
        s.appendTo(this);
    }

    public StringValue createEmptyStringBuilder() {
        return new StringBuilderValue();
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return StringBuilderValue.getValueType(this._bufferList[0], 0, this._length);
    }

    @Override
    public boolean isLongConvertible() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        if (this._length == 0) {
            return false;
        }
        return this._length != 1 || this._bufferList[0][0] != 48;
    }

    @Override
    public long toLong() {
        return LargeStringBuilderValue.parseLong(this._bufferList[0], 0, this._length);
    }

    @Override
    public double toDouble() {
        return StringBuilderValue.toDouble(this._bufferList[0], 0, this._length);
    }

    @Override
    public InputStream toInputStream() {
        return new BuilderInputStream();
    }

    @Override
    public String toString() {
        char[] buffer = new char[this._length];
        byte[][] bufferList = this._bufferList;
        for (int i = this._length - 1; i >= 0; --i) {
            buffer[i] = (char)bufferList[i / 4096][i % 4096];
        }
        return new String(buffer, 0, this._length);
    }

    @Override
    public Object toJavaObject() {
        return this.toString();
    }

    @Override
    public StringValue toStringBuilder() {
        return new LargeStringBuilderValue(this._bufferList, this._length);
    }

    @Override
    public StringValue toBinaryValue(Env env) {
        return this;
    }

    @Override
    public StringValue toBinaryValue(String charset) {
        return this;
    }

    public void appendTo(StringValue bb) {
        int i;
        int tail = this._length % 4096;
        int fixedLength = (this._length - tail) / 4096;
        for (i = 0; i < fixedLength; ++i) {
            bb.append(this._bufferList[i], 0, 4096);
        }
        bb.append(this._bufferList[i], 0, tail);
    }

    @Override
    public Value toKey() {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong());
        }
        return this;
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[this._length];
        byte[][] bufferList = this._bufferList;
        for (int i = this._length - 1; i >= 0; --i) {
            bytes[i] = bufferList[i / 4096][i % 4096];
        }
        return bytes;
    }

    @Override
    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetStringValue.UNSET;
        }
        byte data = this._bufferList[(int)(index / 4096L)][(int)(index % 4096L)];
        return StringBuilderValue.create((char)(data & 0xFF));
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public char charAt(int index) {
        int data = this._bufferList[index / 4096][index % 4096] & 0xFF;
        return (char)data;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return StringBuilderValue.EMPTY;
        }
        StringValue stringValue = end - start < 1024 ? new StringBuilderValue(end - start) : new LargeStringBuilderValue();
        int endChunk = end / 4096;
        while (start < end) {
            int startChunk = start / 4096;
            int startOffset = start % 4096;
            if (startChunk == endChunk) {
                stringValue.append(this._bufferList[startChunk], startOffset, end - start);
                return stringValue;
            }
            int len = 4096 - startOffset;
            stringValue.append(this._bufferList[startChunk], startOffset, len);
            start += len;
        }
        return stringValue;
    }

    @Override
    public StringValue toLowerCase() {
        int length = this._length;
        LargeStringBuilderValue string = new LargeStringBuilderValue();
        byte[][] bufferList = this._bufferList;
        for (int i = 0; i < length; ++i) {
            int ch = bufferList[i / 4096][i % 4096] & 0xFF;
            if (65 <= ch && ch <= 90) {
                ch = ch + 97 - 65;
            }
            ((StringValue)string).append((char)ch);
        }
        return string;
    }

    @Override
    public StringValue toUpperCase() {
        int length = this._length;
        LargeStringBuilderValue string = new LargeStringBuilderValue();
        byte[][] bufferList = this._bufferList;
        for (int i = 0; i < length; ++i) {
            int ch = bufferList[i / 4096][i % 4096] & 0xFF;
            if (97 <= ch && ch <= 122) {
                ch = ch + 65 - 97;
            }
            ((StringValue)string).append((char)ch);
        }
        return string;
    }

    @Override
    public StringValue createStringBuilder() {
        return new StringBuilderValue();
    }

    @Override
    public StringValue createStringBuilder(int length) {
        return new StringBuilderValue(length);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return new LargeStringBuilderValue(this._bufferList, this._length);
    }

    @Override
    public final StringValue appendUnicode(char[] buf, int offset, int length) {
        return this.append(buf, offset, length);
    }

    @Override
    public StringValue append(String s) {
        int len = s.length();
        this.ensureCapacity(this._length + len);
        for (int i = 0; i < len; ++i) {
            this._bufferList[this._length / 4096][this._length % 4096] = (byte)s.charAt(i);
            ++this._length;
        }
        return this;
    }

    @Override
    public StringValue append(CharSequence buf, int head, int tail) {
        int len = tail - head;
        this.ensureCapacity(this._length + len);
        for (int i = 0; i < len; ++i) {
            this._bufferList[this._length / 4096][this._length % 4096] = (byte)buf.charAt(i);
            ++this._length;
        }
        return this;
    }

    @Override
    public final StringValue append(char[] buf, int offset, int length) {
        this.ensureCapacity(this._length + length);
        for (int i = offset; i < length + offset; ++i) {
            this._bufferList[this._length / 4096][this._length % 4096] = (byte)buf[i];
            ++this._length;
        }
        return this;
    }

    @Override
    public final StringValue append(byte[] buf, int offset, int length) {
        this.ensureCapacity(this._length + length);
        while (length > 0) {
            int chunk = this._length / 4096;
            int chunkOffset = this._length % 4096;
            int sublen = 4096 - chunkOffset;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buf, offset, this._bufferList[chunk], chunkOffset, sublen);
            offset += sublen;
            length -= sublen;
            this._length += sublen;
        }
        return this;
    }

    @Override
    public final StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    @Override
    public final StringValue append(char v) {
        if (this._length % 4096 == 0) {
            this.ensureCapacity(this._length + 1);
        }
        this._bufferList[this._length / 4096][this._length % 4096] = (byte)v;
        ++this._length;
        return this;
    }

    public final StringValue append(byte v) {
        if (this._length % 4096 == 0) {
            this.ensureCapacity(this._length + 1);
        }
        this._bufferList[this._length / 4096][this._length % 4096] = v;
        ++this._length;
        return this;
    }

    @Override
    public final StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    @Override
    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public final StringValue append(Value v) {
        v.appendTo(this);
        return this;
    }

    @Override
    public int appendRead(InputStream is, long length) {
        try {
            int offset = this._length % 4096;
            if (offset == 0) {
                this.ensureCapacity(this._length + 4096);
            }
            byte[] buffer = this._bufferList[this._length / 4096];
            int sublen = 4096 - offset;
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                this._length += sublen;
                return sublen;
            }
            return -1;
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public int appendReadAll(InputStream is, long length) {
        int readLength = 0;
        while (length > 0L) {
            int sublen = this.appendRead(is, length);
            if (sublen < 0) {
                return readLength <= 0 ? -1 : readLength;
            }
            length -= (long)sublen;
            readLength += sublen;
        }
        return readLength;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        if (this.length() == 0) {
            return sb;
        }
        Env env = Env.getInstance();
        try {
            Reader reader = env.getRuntimeEncodingFactory().create(this.toInputStream());
            if (reader != null) {
                sb.append(reader);
                reader.close();
            }
            return sb;
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public void print(Env env) {
        for (int i = 0; i < this._length; i += 4096) {
            int chunk = i / 4096;
            int sublen = this._length - i;
            if (4096 < sublen) {
                sublen = 4096;
            }
            env.write(this._bufferList[chunk], 0, sublen);
        }
    }

    @Override
    public void print(Env env, WriteStream out) {
        try {
            for (int i = 0; i < this._length; i += 4096) {
                int chunk = i / 4096;
                int sublen = this._length - i;
                if (4096 < sublen) {
                    sublen = 4096;
                }
                out.write(this._bufferList[chunk], 0, sublen);
            }
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("s:");
        sb.append(this._length);
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    public OutputStream getOutputStream() {
        return new BuilderOutputStream();
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity > 10000000) {
            Thread.dumpStack();
            throw new IllegalStateException();
        }
        int chunk = this._length / 4096;
        int endChunk = newCapacity / 4096;
        if (this._bufferList.length <= endChunk) {
            byte[][] bufferList = new byte[endChunk + 32][];
            System.arraycopy(this._bufferList, 0, bufferList, 0, this._bufferList.length);
            this._bufferList = bufferList;
        }
        while (chunk <= endChunk) {
            if (this._bufferList[chunk] == null) {
                this._bufferList[chunk] = new byte[4096];
            }
            ++chunk;
        }
    }

    @Override
    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int hash = 37;
        int length = this._length;
        byte[][] bufferList = this._bufferList;
        for (int i = 0; i < length; ++i) {
            hash = 65521 * hash + (bufferList[i / 4096][i % 4096] & 0xFF);
        }
        this._hashCode = hash;
        return hash;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("string(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        out.print("string(");
        out.print(length);
        out.print(") \"");
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            out.print(ch);
        }
        out.print("\"");
    }

    class BuilderOutputStream
    extends OutputStream {
        BuilderOutputStream() {
        }

        public void write(int ch) {
            LargeStringBuilderValue.this.append(ch);
        }

        public void write(byte[] buffer, int offset, int length) {
            LargeStringBuilderValue.this.append(buffer, offset, length);
        }
    }

    class BuilderInputStream
    extends InputStream {
        private int _index;

        BuilderInputStream() {
        }

        public int read() {
            if (this._index < LargeStringBuilderValue.this._length) {
                return LargeStringBuilderValue.this.charAt(this._index++);
            }
            return -1;
        }

        public int read(byte[] buffer, int offset, int length) {
            int sublen = LargeStringBuilderValue.this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            for (int i = 0; i < sublen; ++i) {
                buffer[offset + i] = (byte)LargeStringBuilderValue.this.charAt(this._index + i);
            }
            this._index += sublen;
            return sublen;
        }
    }
}

