/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodIntern;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.function.FunSpecialCall;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;
import com.caucho.util.Primes;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodMap<V> {
    private static final L10N L = new L10N(MethodMap.class);
    private final QuercusClass _quercusClass;
    private final ClassDef _classDef;
    private Entry<V>[] _entries = new Entry[16];
    private int _prime = Primes.getBiggestPrime(this._entries.length);
    private int _size;

    public MethodMap(QuercusClass quercusClass, ClassDef classDef) {
        this._quercusClass = quercusClass;
        this._classDef = classDef;
    }

    public void put(String methodName, V value) {
        Entry<V> entry;
        StringValue name = MethodIntern.intern(methodName);
        if (this._entries.length <= this._size * 4) {
            this.resize();
        }
        int hash = name.hashCodeCaseInsensitive();
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (name != entryKey && !name.equalsIgnoreCase(entryKey)) continue;
            entry.setValue(value);
            return;
        }
        entry = new Entry<V>(name, value);
        ((Entry)entry)._next = (Entry)this._entries[bucket];
        this._entries[bucket] = entry;
        ++this._size;
    }

    public boolean containsKey(StringValue key) {
        int hash = key.hashCodeCaseInsensitive();
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (Entry<V> entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (key != entryKey && !key.equalsIgnoreCase(entryKey)) continue;
            return true;
        }
        return false;
    }

    public final V get(StringValue key, int hash) {
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (Entry<V> entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (key != entryKey && !key.equalsIgnoreCase(entryKey)) continue;
            return (V)((Entry)entry)._value;
        }
        AbstractFunction call = null;
        if (this._quercusClass != null) {
            call = this._quercusClass.getCall();
        } else if (this._classDef != null) {
            call = this._classDef.getCall();
        }
        if (call != null) {
            return (V)new FunSpecialCall(call, key);
        }
        Env env = Env.getCurrent();
        if (this._quercusClass != null) {
            env.error(L.l("Call to undefined method {0}::{1}", (Object)this._quercusClass.getName(), key));
        } else {
            env.error(L.l("Call to undefined function {0}", key));
        }
        throw new IllegalStateException();
    }

    public V getRaw(StringValue key) {
        int hash = key.hashCodeCaseInsensitive();
        int bucket = (hash & Integer.MAX_VALUE) % this._prime;
        for (Entry<V> entry = this._entries[bucket]; entry != null; entry = entry.getNext()) {
            StringValue entryKey = entry.getKey();
            if (key != entryKey && !key.equalsIgnoreCase(entryKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    public V get(StringValue key) {
        return this.get(key, key.hashCodeCaseInsensitive());
    }

    public Iterable<V> values() {
        return new ValueIterator<V>(this._entries);
    }

    private boolean match(char[] a, char[] b, int length) {
        if (a.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            int chA = a[i];
            int chB = b[i];
            if (chA == chB) continue;
            if (65 <= chA && chA <= 90) {
                chA += 32;
            }
            if (65 <= chB && chB <= 90) {
                chB += 32;
            }
            if (chA == chB) continue;
            return false;
        }
        return true;
    }

    private void resize() {
        Entry[] newEntries = new Entry[2 * this._entries.length];
        int newPrime = Primes.getBiggestPrime(newEntries.length);
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<V> entry = this._entries[i];
            while (entry != null) {
                Entry<V> next = entry.getNext();
                int hash = ((Entry)entry)._key.hashCodeCaseInsensitive();
                int bucket = (hash & Integer.MAX_VALUE) % newPrime;
                entry.setNext(newEntries[bucket]);
                newEntries[bucket] = entry;
                entry = next;
            }
        }
        this._entries = newEntries;
        this._prime = newPrime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ValueIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        int _index;
        Entry<V>[] _entries;
        Entry<V> _next;

        public ValueIterator(Entry<V>[] entries) {
            this._entries = entries;
            this.getNext();
        }

        private void getNext() {
            Entry<V> entry;
            Entry<V> entry2 = entry = this._next == null ? null : ((Entry)this._next)._next;
            while (entry == null && this._index < this._entries.length && (entry = this._entries[this._index++]) == null) {
            }
            this._next = entry;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public V next() {
            Object value = ((Entry)this._next)._value;
            this.getNext();
            return (V)value;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<V> {
        private final StringValue _key;
        private V _value;
        private Entry<V> _next;

        Entry(StringValue key, V value) {
            this._key = key;
            this._value = value;
        }

        public final StringValue getKey() {
            return this._key;
        }

        public final V getValue() {
            return this._value;
        }

        public void setValue(V value) {
            this._value = value;
        }

        public Entry<V> getNext() {
            return this._next;
        }

        public void setNext(Entry<V> next) {
            this._next = next;
        }
    }
}

