/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.util.L10N;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.MultipartStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Post {
    private static final L10N L = new L10N(Post.class);
    private static StringValue MAX_FILE_SIZE = new ConstStringValue("MAX_FILE_SIZE");
    private static StringValue MAX_FILE_SIZE_U = new UnicodeBuilderValue("MAX_FILE_SIZE");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillPost(Env env, ArrayValue postArray, ArrayValue files, HttpServletRequest request, boolean addSlashesToValues, boolean isAllowUploads) {
        InputStream is = null;
        try {
            String encoding = request.getCharacterEncoding();
            String contentType = request.getHeader("Content-Type");
            is = request.getInputStream();
            Post.fillPost(env, postArray, files, is, contentType, encoding, Integer.MAX_VALUE, addSlashesToValues, isAllowUploads);
            if (postArray.getSize() == 0) {
                Post.putRequestMap(env, postArray, files, request, addSlashesToValues, isAllowUploads);
            }
        }
        catch (IOException e) {
            env.warning(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillPost(Env env, ArrayValue postArray, ArrayValue files, InputStream is, String contentType, String encoding, int contentLength, boolean addSlashesToValues, boolean isAllowUploads) {
        long maxPostSize = env.getIniBytes("post_max_size", 0L);
        try {
            if (encoding == null) {
                encoding = env.getHttpInputEncoding();
            }
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                String boundary = Post.getBoundary(contentType);
                ReadStream rs = new ReadStream(new VfsStream(is, null));
                if (boundary == null) {
                    env.warning(L.l("multipart/form-data POST is missing boundary"));
                    return;
                }
                MultipartStream ms = new MultipartStream(rs, boundary);
                if (encoding != null) {
                    ms.setEncoding(encoding);
                }
                Post.readMultipartStream(env, ms, postArray, files, addSlashesToValues, isAllowUploads);
                rs.close();
                if ((long)rs.getLength() > maxPostSize) {
                    env.warning(L.l("POST length of {0} exceeds max size of {1}", (Object)rs.getLength(), maxPostSize));
                    postArray.clear();
                    files.clear();
                    return;
                }
            } else {
                StringValue bb = env.createBinaryBuilder();
                bb.appendReadAll(is, Integer.MAX_VALUE);
                if ((long)bb.length() > maxPostSize) {
                    env.warning(L.l("POST length of {0} exceeds max size of {1}", (Object)bb.length(), maxPostSize));
                    return;
                }
                env.setInputData(bb);
                if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                    StringUtility.parseStr(env, bb, postArray, false, encoding);
                }
            }
        }
        catch (IOException e) {
            env.warning(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMultipartStream(Env env, MultipartStream ms, ArrayValue postArray, ArrayValue files, boolean addSlashesToValues, boolean isAllowUploads) throws IOException {
        ReadStream is;
        while ((is = ms.openRead()) != null) {
            String mimeType;
            String attr = ms.getAttribute("content-disposition");
            if (attr == null || !attr.startsWith("form-data")) continue;
            String name = Post.getAttribute(attr, "name", addSlashesToValues);
            String filename = Post.getAttribute(attr, "filename", addSlashesToValues);
            if (filename != null) {
                int slashIndex = filename.lastIndexOf(47);
                int slashIndex2 = filename.lastIndexOf(92);
                if ((slashIndex = Math.max(slashIndex, slashIndex2)) >= 0) {
                    filename = filename.substring(slashIndex + 1);
                }
            }
            int bracketIndex = -1;
            if (name != null) {
                bracketIndex = name.lastIndexOf(93);
            }
            if (bracketIndex >= 0 && bracketIndex < name.length() - 1) continue;
            if (filename == null) {
                StringValue value = env.createStringBuilder();
                value.appendReadAll(is, Integer.MAX_VALUE);
                if (name != null) {
                    Post.addFormValue(env, postArray, name, value, null, addSlashesToValues);
                    continue;
                }
                env.warning(L.l("file upload is missing name and filename"));
                continue;
            }
            if (!isAllowUploads) continue;
            String tmpName = "";
            long tmpLength = 0L;
            if (filename.length() > 0) {
                Path tmpPath = env.getUploadDirectory().createTempFile("php", ".tmp");
                env.addRemovePath(tmpPath);
                WriteStream os = tmpPath.openWrite();
                try {
                    os.writeStream(is);
                }
                finally {
                    os.close();
                }
                tmpName = tmpPath.getFullPath();
                tmpLength = tmpPath.getLength();
            }
            if ((mimeType = Post.getAttribute(attr, "mime-type", addSlashesToValues)) == null && (mimeType = ms.getAttribute("content-type")) != null && mimeType.endsWith(";")) {
                mimeType = mimeType.substring(0, mimeType.length() - 1);
            }
            if (filename.length() == 0) {
                mimeType = "";
            }
            long maxFileSize = Long.MAX_VALUE;
            Value maxFileSizeV = postArray.get(MAX_FILE_SIZE);
            if (!maxFileSizeV.isNull()) {
                maxFileSize = maxFileSizeV.toLong();
            }
            if (name != null) {
                Post.addFormFile(env, files, name, filename, tmpName, mimeType, tmpLength, addSlashesToValues, maxFileSize);
                continue;
            }
            Post.addFormFile(env, files, filename, tmpName, mimeType, tmpLength, addSlashesToValues, maxFileSize);
        }
    }

    private static void addFormFile(Env env, ArrayValue files, String fileName, String tmpName, String mimeType, long fileLength, boolean addSlashesToValues, long maxFileSize) {
        long size;
        ArrayValueImpl entry = new ArrayValueImpl();
        long uploadMaxFilesize = env.getIniBytes("upload_max_filesize", 0x200000L);
        int error = fileName.length() == 0 ? 4 : (fileLength > uploadMaxFilesize ? 1 : (fileLength > maxFileSize ? 2 : 0));
        Post.addFormValue(env, entry, "name", env.createString(fileName), null, addSlashesToValues);
        if (error != 1) {
            size = fileLength;
        } else {
            mimeType = "";
            tmpName = "";
            size = 0L;
        }
        if (mimeType != null) {
            Post.addFormValue(env, entry, "type", env.createString(mimeType), null, addSlashesToValues);
            entry.put("type", mimeType);
        }
        Post.addFormValue(env, entry, "tmp_name", env.createString(tmpName), null, addSlashesToValues);
        Post.addFormValue(env, entry, "error", LongValue.create(error), null, addSlashesToValues);
        Post.addFormValue(env, entry, "size", LongValue.create(size), null, addSlashesToValues);
        Post.addFormValue(env, files, null, entry, null, addSlashesToValues);
    }

    private static void addFormFile(Env env, ArrayValue files, String name, String fileName, String tmpName, String mimeType, long fileLength, boolean addSlashesToValues, long maxFileSize) {
        long size;
        int p = name.indexOf(91);
        String index = "";
        if (p >= 0) {
            index = name.substring(p);
            name = name.substring(0, p);
        }
        StringValue nameValue = env.createString(name);
        Value v = files.get(nameValue).toValue();
        ArrayValue entry = null;
        if (v instanceof ArrayValue) {
            entry = (ArrayValue)v;
        }
        if (entry == null) {
            entry = new ArrayValueImpl();
            files.put(nameValue, entry);
        }
        long uploadMaxFilesize = env.getIniBytes("upload_max_filesize", 0x200000L);
        int error = fileName.length() == 0 ? 4 : (fileLength > uploadMaxFilesize ? 1 : (fileLength > maxFileSize ? 2 : 0));
        Post.addFormValue(env, entry, "name" + index, env.createString(fileName), null, addSlashesToValues);
        if (error == 0) {
            size = fileLength;
        } else {
            mimeType = "";
            tmpName = "";
            size = 0L;
        }
        if (mimeType != null) {
            Post.addFormValue(env, entry, "type" + index, env.createString(mimeType), null, addSlashesToValues);
        }
        Post.addFormValue(env, entry, "tmp_name" + index, env.createString(tmpName), null, addSlashesToValues);
        Post.addFormValue(env, entry, "error" + index, LongValue.create(error), null, addSlashesToValues);
        Post.addFormValue(env, entry, "size" + index, LongValue.create(size), null, addSlashesToValues);
        Post.addFormValue(env, files, name, entry, null, addSlashesToValues);
    }

    public static void addFormValue(Env env, ArrayValue array, String key, String[] formValueList, boolean addSlashesToValues) {
        String formValue = formValueList[formValueList.length - 1];
        Value value = formValue != null ? env.createString(formValue) : NullValue.NULL;
        Post.addFormValue(env, array, key, value, formValueList, addSlashesToValues);
    }

    public static void addFormValue(Env env, ArrayValue array, String key, Value formValue, String[] formValueList, boolean addSlashesToValues) {
        int p = -1;
        int q = -1;
        if (key != null) {
            p = key.indexOf(91);
            q = key.indexOf(93, p);
        }
        if (p >= 0 && p < q) {
            int p1;
            Value existingValue;
            StringValue keyValue;
            String index = key;
            if (p > 0) {
                key = key.substring(0, p);
                keyValue = env.createString(key = key.replaceAll("\\.", "_"));
                existingValue = array.get(keyValue);
                if (existingValue == null || !existingValue.isset()) {
                    existingValue = new ArrayValueImpl();
                    array.put(keyValue, existingValue);
                } else if (!existingValue.isArray()) {
                    existingValue = new ArrayValueImpl();
                    array.put(keyValue, existingValue);
                }
                array = (ArrayValue)existingValue;
            }
            while ((p1 = index.indexOf(91, q)) > 0) {
                key = index.substring(p + 1, q);
                if (key.equals("")) {
                    existingValue = new ArrayValueImpl();
                    array.put(existingValue);
                } else {
                    keyValue = env.createString(key);
                    existingValue = array.get(keyValue);
                    if (existingValue == null || !existingValue.isset()) {
                        existingValue = new ArrayValueImpl();
                        array.put(keyValue, existingValue);
                    } else if (!existingValue.isArray()) {
                        existingValue = new ArrayValueImpl().put(existingValue);
                        array.put(keyValue, existingValue);
                    }
                }
                array = (ArrayValue)existingValue;
                p = p1;
                q = index.indexOf(93, p);
            }
            index = q > 0 ? index.substring(p + 1, q) : index.substring(p + 1);
            if (index.equals("")) {
                if (formValueList != null) {
                    for (int i = 0; i < formValueList.length; ++i) {
                        Value value = formValueList[i] != null ? env.createString(formValueList[i]) : NullValue.NULL;
                        Post.put(array, null, value, addSlashesToValues);
                    }
                } else {
                    array.put(formValue);
                }
            } else if ('0' <= index.charAt(0) && index.charAt(0) <= '9') {
                Post.put(array, LongValue.create(StringValue.toLong(index)), formValue, addSlashesToValues);
            } else {
                Post.put(array, env.createString(index), formValue, addSlashesToValues);
            }
        } else if (key != null) {
            key = key.replaceAll("\\.", "_");
            Post.put(array, env.createString(key), formValue, addSlashesToValues);
        } else {
            Post.put(array, null, formValue, addSlashesToValues);
        }
    }

    private static void put(ArrayValue array, Value key, Value value, boolean addSlashes) {
        if (addSlashes && value.isString()) {
            value = StringModule.addslashes(value.toStringValue());
        }
        if (key == null) {
            array.put(value);
        } else {
            array.put(key, value);
        }
    }

    private static String getBoundary(String contentType) {
        int i = contentType.indexOf("boundary=");
        if (i < 0) {
            return null;
        }
        int length = contentType.length();
        if (length <= (i += "boundary=".length())) {
            return null;
        }
        char ch = contentType.charAt(i);
        if (ch == '\'') {
            StringBuilder sb = new StringBuilder();
            ++i;
            while (i < length && (ch = contentType.charAt(i)) != '\'') {
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }
        if (ch == '\"') {
            StringBuilder sb = new StringBuilder();
            ++i;
            while (i < length && (ch = contentType.charAt(i)) != '\"') {
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';' && ch != ',') {
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    private static String getAttribute(String attr, String name, boolean addSlashesToValues) {
        StringBuilder value;
        block10: {
            char ch;
            int i;
            int length;
            block11: {
                char ch2;
                block9: {
                    char ch3;
                    block8: {
                        if (attr == null) {
                            return null;
                        }
                        length = attr.length();
                        i = attr.indexOf(name);
                        if (i < 0) {
                            return null;
                        }
                        do {
                            char ch4 = attr.charAt(i - 1);
                            if (i <= 0 || ch4 == ' ' || ch4 == ';') break block8;
                        } while ((i = attr.indexOf(name, i + name.length())) >= 0);
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = new StringBuilder();
                    if (i >= length || attr.charAt(i) != '\'') break block9;
                    ++i;
                    while (!(i >= length || attr.charAt(i) == '\'' || (ch3 = attr.charAt(i)) == '\"' && addSlashesToValues)) {
                        value.append(ch3);
                        ++i;
                    }
                    break block10;
                }
                if (i >= length || attr.charAt(i) != '\"') break block11;
                ++i;
                while (!(i >= length || attr.charAt(i) == '\"' || (ch2 = attr.charAt(i)) == '\'' && addSlashesToValues)) {
                    value.append(ch2);
                    ++i;
                }
                break block10;
            }
            if (i >= length) break block10;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.toString();
    }

    private static void putRequestMap(Env env, ArrayValue post, ArrayValue files, HttpServletRequest request, boolean addSlashesToValues, boolean isAllowUploads) {
        Map map = request.getParameterMap();
        if (map == null) {
            return;
        }
        long maxFileSize = Long.MAX_VALUE;
        Value maxFileSizeV = post.get(MAX_FILE_SIZE);
        if (maxFileSizeV.isNull()) {
            maxFileSize = maxFileSizeV.toLong();
        }
        if (isAllowUploads) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                int len = key.length();
                if (len < 10 || !key.endsWith(".filename")) continue;
                String name = key.substring(0, len - 9);
                String[] fileNames = request.getParameterValues(name + ".filename");
                String[] tmpNames = request.getParameterValues(name + ".file");
                String[] mimeTypes = request.getParameterValues(name + ".content-type");
                for (int i = 0; i < fileNames.length; ++i) {
                    long fileLength = new FilePath(tmpNames[i]).getLength();
                    Post.addFormFile(env, files, name, fileNames[i], tmpNames[i], mimeTypes[i], fileLength, addSlashesToValues, maxFileSize);
                }
            }
        }
        ArrayList keys = new ArrayList();
        keys.addAll(request.getParameterMap().keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String[] value = request.getParameterValues(key);
            Post.addFormValue(env, post, key, value, addSlashesToValues);
        }
    }
}

