/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodIntern;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVirtualFieldExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ClassVirtualFieldExpr.class);
    protected final StringValue _varName;

    public ClassVirtualFieldExpr(String varName) {
        this._varName = MethodIntern.intern(varName);
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        Expr var = parser.createVar(this._varName.toString());
        return factory.createClassVirtualMethodCall(location, var, args);
    }

    @Override
    public Value eval(Env env) {
        QuercusClass qClass;
        Value qThis = env.getThis();
        QuercusClass quercusClass = qClass = qThis != null ? qThis.getQuercusClass() : null;
        if (qClass == null) {
            env.error(L.l("No calling class found for '{0}'", this));
            return NullValue.NULL;
        }
        return qClass.getStaticFieldValue(env, this._varName);
    }

    @Override
    public Var evalVar(Env env) {
        QuercusClass qClass;
        Value qThis = env.getThis();
        QuercusClass quercusClass = qClass = qThis != null ? qThis.getQuercusClass() : null;
        if (qClass == null) {
            env.error(L.l("No calling class found for '{0}'", this));
            return NullValue.NULL.toVar();
        }
        return qClass.getStaticFieldVar(env, this._varName);
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        QuercusClass qClass;
        Value qThis = env.getThis();
        QuercusClass quercusClass = qClass = qThis != null ? qThis.getQuercusClass() : null;
        if (qClass == null) {
            env.error(L.l("No calling class found for '{0}'", this));
            return NullValue.NULL.toVar();
        }
        return qClass.setStaticFieldRef(env, this._varName, value);
    }

    @Override
    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)env.getCallingClass().getName(), this._varName));
    }

    @Override
    public String toString() {
        return "static::$" + this._varName;
    }
}

