/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Closure;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.Function;
import com.caucho.util.L10N;

public class ClosureExpr
extends Expr {
    private static final L10N L = new L10N(ClosureExpr.class);
    protected final Function _fun;

    public ClosureExpr(Location location, Function fun) {
        super(location);
        this._fun = fun;
    }

    public String getName() {
        return this._fun.getName();
    }

    public Function getFunction() {
        return this._fun;
    }

    public String getFunctionLocation() {
        return " [" + this.getName() + "]";
    }

    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    public Value eval(Env env) {
        return this.evalImpl(env);
    }

    public Value evalCopy(Env env) {
        return this.evalImpl(env);
    }

    private Value evalImpl(Env env) {
        return new Closure(env, this._fun);
    }

    public String toString() {
        return this.getName() + "()";
    }
}

