/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;

public class ThisExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ThisExpr.class);
    protected final InterpretedClassDef _quercusClass;

    public ThisExpr(InterpretedClassDef quercusClass) {
        this._quercusClass = quercusClass;
    }

    public InterpretedClassDef getQuercusClass() {
        return this._quercusClass;
    }

    public Expr createFieldGet(ExprFactory factory, StringValue name) {
        return factory.createThisField(this, name);
    }

    public Expr createFieldGet(ExprFactory factory, Expr name) {
        return factory.createThisField(this, name);
    }

    public Value eval(Env env) {
        return env.getThis();
    }

    public Value evalArg(Env env, boolean isTop) {
        return env.getThis();
    }

    public Var evalVar(Env env) {
        return env.getThis().toVar();
    }

    public Value evalAssignValue(Env env, Value value) {
        env.error(this.getLocation(), "can't assign $this");
        return value;
    }

    public Value evalAssignRef(Env env, Value value) {
        env.error(this.getLocation(), "can't assign $this");
        return value;
    }

    public void evalUnset(Env env) {
        env.error(this.getLocation(), "can't unset $this");
    }

    public String toString() {
        return "$this";
    }
}

