/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.ObjectFieldVarExpr;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThisFieldVarExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ObjectFieldVarExpr.class);
    protected final ThisExpr _qThis;
    protected final Expr _nameExpr;

    public ThisFieldVarExpr(ThisExpr qThis, Expr nameExpr) {
        this._qThis = qThis;
        this._nameExpr = nameExpr;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createThisMethod(location, this._qThis, this._nameExpr, args);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        Value value = env.getThis();
        return value.getThisFieldArg(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Var evalVar(Env env) {
        Value value = env.getThis();
        return value.getThisFieldVar(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value eval(Env env) {
        Value obj = env.getThis();
        return obj.getThisField(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        Value obj = env.getThis();
        obj.putThisField(env, this._nameExpr.evalStringValue(env), value);
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        Value obj = env.getThis();
        obj.putThisField(env, this._nameExpr.evalStringValue(env), value);
        return value;
    }

    @Override
    public Value evalArrayAssign(Env env, Value index, Value value) {
        Value obj = env.getThis();
        StringValue name = this._nameExpr.evalStringValue(env);
        Var fieldVar = obj.getThisFieldVar(env, name);
        return ((Value)fieldVar).put(index, value);
    }

    @Override
    public Value evalArray(Env env) {
        Value obj = env.getThis();
        return obj.getThisFieldArray(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value evalObject(Env env) {
        Value obj = env.getThis();
        return obj.getThisFieldObject(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public void evalUnset(Env env) {
        Value obj = env.getThis();
        obj.unsetThisField(this._nameExpr.evalStringValue(env));
    }

    @Override
    public String toString() {
        return "$this->{" + this._nameExpr + "}";
    }
}

