/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.ConstArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HtmlModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(HtmlModule.class.getName());
    private static final L10N L = new L10N(HtmlModule.class);
    public static final int HTML_SPECIALCHARS = 0;
    public static final int HTML_ENTITIES = 1;
    public static final int ENT_HTML_QUOTE_NONE = 0;
    public static final int ENT_HTML_QUOTE_SINGLE = 1;
    public static final int ENT_HTML_QUOTE_DOUBLE = 2;
    public static final int ENT_COMPAT = 2;
    public static final int ENT_QUOTES = 3;
    public static final int ENT_NOQUOTES = 0;
    private static StringValue[] HTML_SPECIALCHARS_MAP;
    private static ArrayValue HTML_SPECIALCHARS_ARRAY;
    private static ArrayValue HTML_ENTITIES_ARRAY;
    private static ArrayValue HTML_ENTITIES_ARRAY_ENTITY_KEY;
    private static ArrayValueImpl HTML_ENTITIES_ARRAY_UNICODE;
    private static ArrayValueImpl HTML_SPECIALCHARS_ARRAY_UNICODE;
    private static ArrayValueImpl HTML_ENTITIES_ARRAY_UNICODE_ENTITY_KEY;

    private static ConstArrayValue toUnicodeArray(Env env, ArrayValue array) {
        ArrayValueImpl copy = new ArrayValueImpl();
        Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            Value key = entry.getKey();
            Value value = entry.getValue();
            if (key.isString()) {
                key = key.toUnicodeValue(env);
            }
            if (value.isString()) {
                value = value.toUnicodeValue(env);
            }
            copy.put(key, value);
        }
        return new ConstArrayValue(copy);
    }

    public Value get_html_translation_table(Env env, @Optional(value="HTML_SPECIALCHARS") int table, @Optional(value="ENT_COMPAT") int quoteStyle) {
        Value result;
        if (!env.isUnicodeSemantics()) {
            result = table == 1 ? HTML_ENTITIES_ARRAY.copy() : HTML_SPECIALCHARS_ARRAY.copy();
        } else if (table == 1) {
            if (HTML_ENTITIES_ARRAY_UNICODE == null) {
                HTML_ENTITIES_ARRAY_UNICODE = HtmlModule.toUnicodeArray(env, HTML_ENTITIES_ARRAY);
            }
            result = HTML_ENTITIES_ARRAY_UNICODE.copy();
        } else {
            if (HTML_SPECIALCHARS_ARRAY_UNICODE == null) {
                HTML_SPECIALCHARS_ARRAY_UNICODE = HtmlModule.toUnicodeArray(env, HTML_SPECIALCHARS_ARRAY);
            }
            result = HTML_SPECIALCHARS_ARRAY_UNICODE.copy();
        }
        if ((quoteStyle & 1) != 0) {
            result.put(env.createString('\''), env.createString("&#39;"));
        }
        if ((quoteStyle & 2) != 0) {
            result.put(env.createString('\"'), env.createString("&quot;"));
        }
        return result;
    }

    public static StringValue htmlspecialchars_decode(Env env, StringValue str, @Optional(value="ENT_COMPAT") int quoteStyle) {
        int len = str.length();
        StringValue sb = str.createStringBuilder(len * 4 / 5);
        block7: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != '&') {
                sb.append(ch);
                continue;
            }
            switch (str.charAt(i + 1)) {
                case 'a': {
                    sb.append('&');
                    if (i + 4 >= len || str.charAt(i + 2) != 'm' || str.charAt(i + 3) != 'p' || str.charAt(i + 4) != ';') continue block7;
                    i += 4;
                    continue block7;
                }
                case 'q': {
                    if ((quoteStyle & 2) != 0 && i + 5 < len && str.charAt(i + 2) == 'u' && str.charAt(i + 3) == 'o' && str.charAt(i + 4) == 't' && str.charAt(i + 5) == ';') {
                        i += 5;
                        sb.append('\"');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case '#': {
                    if ((quoteStyle & 1) != 0 && i + 5 < len && str.charAt(i + 2) == '0' && str.charAt(i + 3) == '3' && str.charAt(i + 4) == '9' && str.charAt(i + 5) == ';') {
                        i += 5;
                        sb.append('\'');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case 'l': {
                    if (i + 3 < len && str.charAt(i + 2) == 't' && str.charAt(i + 3) == ';') {
                        i += 3;
                        sb.append('<');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                case 'g': {
                    if (i + 3 < len && str.charAt(i + 2) == 't' && str.charAt(i + 3) == ';') {
                        i += 3;
                        sb.append('>');
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    sb.append('&');
                }
            }
        }
        return sb;
    }

    public static Value htmlspecialchars(Env env, StringValue string, @Optional(value="ENT_COMPAT") int quoteStyle, @Optional String charset) {
        int len = string.length();
        StringValue sb = string.createStringBuilder(len * 5 / 4);
        block7: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    if ((quoteStyle & 2) != 0) {
                        sb.append("&quot;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '\'': {
                    if ((quoteStyle & 1) != 0) {
                        sb.append("&#039;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static Value htmlentities(Env env, StringValue string, @Optional(value="ENT_COMPAT") int quoteStyle, @Optional String charset) {
        Reader reader;
        if (charset == null || charset.length() == 0) {
            charset = "ISO-8859-1";
        }
        try {
            reader = string.toReader(charset);
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            reader = new StringReader(string.toString());
        }
        StringValue sb = string.createStringBuilder(string.length() * 5 / 4);
        try {
            int ch;
            while ((ch = reader.read()) >= 0) {
                StringValue entity = HTML_SPECIALCHARS_MAP[ch & 0xFFFF];
                if (ch == 34) {
                    if ((quoteStyle & 2) != 0) {
                        sb.append("&quot;");
                        continue;
                    }
                    sb.append('\"');
                    continue;
                }
                if (ch == 39) {
                    if ((quoteStyle & 1) != 0) {
                        sb.append("&#039;");
                        continue;
                    }
                    sb.append('\'');
                    continue;
                }
                if (entity != null) {
                    sb.append(entity);
                    continue;
                }
                if (env.isUnicodeSemantics() || 0 <= ch && ch <= 255) {
                    sb.append((char)ch);
                    continue;
                }
                sb.append("&#");
                sb.append(HtmlModule.hexdigit(ch >> 12));
                sb.append(HtmlModule.hexdigit(ch >> 8));
                sb.append(HtmlModule.hexdigit(ch >> 4));
                sb.append(HtmlModule.hexdigit(ch));
                sb.append(";");
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        return sb;
    }

    private static char hexdigit(int ch) {
        if ((ch &= 0xF) < 10) {
            return (char)(ch + 48);
        }
        return (char)(ch - 10 + 97);
    }

    public static StringValue html_entity_decode(Env env, StringValue string, @Optional int quoteStyle, @Optional String charset) {
        if (string.length() == 0) {
            return env.getEmptyString();
        }
        ArrayValue htmlEntities = null;
        boolean isUnicode = env.isUnicodeSemantics();
        if (isUnicode) {
            if (HTML_ENTITIES_ARRAY_UNICODE_ENTITY_KEY == null) {
                HTML_ENTITIES_ARRAY_UNICODE_ENTITY_KEY = HtmlModule.toUnicodeArray(env, HTML_ENTITIES_ARRAY_ENTITY_KEY);
            }
            htmlEntities = HTML_ENTITIES_ARRAY_UNICODE_ENTITY_KEY;
        } else {
            htmlEntities = HTML_ENTITIES_ARRAY_ENTITY_KEY;
        }
        EncodingWriter out = null;
        if (!isUnicode) {
            if (charset == null || charset.length() == 0) {
                charset = env.getRuntimeEncoding();
            }
            out = Encoding.getWriteEncoding(charset);
        }
        int len = string.length();
        int htmlEntityStart = -1;
        StringValue result = env.createStringBuilder();
        try {
            for (int i = 0; i < len; ++i) {
                char ch = string.charAt(i);
                if (ch == '&' && htmlEntityStart < 0) {
                    htmlEntityStart = i;
                    continue;
                }
                if (htmlEntityStart < 0) {
                    result.append(ch);
                    continue;
                }
                if (ch == ';') {
                    StringValue entity = string.substring(htmlEntityStart, i + 1);
                    Value value = htmlEntities.get(entity);
                    if (value.isNull()) {
                        result.append(entity);
                    } else if (isUnicode) {
                        result.append((char)value.toInt());
                    } else {
                        out.write(result, (char)value.toInt());
                    }
                    htmlEntityStart = -1;
                    continue;
                }
                if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') continue;
                result.append('&');
                i = htmlEntityStart;
                htmlEntityStart = -1;
            }
            if (htmlEntityStart > 0) {
                result.append(string, htmlEntityStart, len);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return result;
    }

    public static Value nl2br(Env env, StringValue string) {
        int strLen = string.length();
        StringValue sb = string.createStringBuilder(strLen * 5 / 4);
        for (int i = 0; i < strLen; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                sb.append("<br />\n");
                continue;
            }
            if (ch == '\r') {
                if (i + 1 < strLen && string.charAt(i + 1) == '\n') {
                    sb.append("<br />\r\n");
                    ++i;
                    continue;
                }
                sb.append("<br />\r");
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private static void entity(ArrayValue array, StringValue[] map, ArrayValue revMap, int ch, String entity) {
        array.put("" + (char)ch, entity);
        StringBuilderValue entityValue = new StringBuilderValue(entity);
        map[ch & 0xFFFF] = entityValue;
        revMap.put(entityValue, LongValue.create(ch));
    }

    static {
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("<", "&lt;");
        array.put(">", "&gt;");
        array.put("&", "&amp;");
        HTML_SPECIALCHARS_ARRAY = new ConstArrayValue(array);
        StringValue[] map = new StringValue[65536];
        HTML_SPECIALCHARS_MAP = map;
        ArrayValueImpl revMap = new ArrayValueImpl();
        HTML_ENTITIES_ARRAY_ENTITY_KEY = revMap;
        array = new ArrayValueImpl();
        HtmlModule.entity(array, map, revMap, 60, "&lt;");
        HtmlModule.entity(array, map, revMap, 62, "&gt;");
        HtmlModule.entity(array, map, revMap, 38, "&amp;");
        HtmlModule.entity(array, map, revMap, 160, "&nbsp;");
        HtmlModule.entity(array, map, revMap, 161, "&iexcl;");
        HtmlModule.entity(array, map, revMap, 162, "&cent;");
        HtmlModule.entity(array, map, revMap, 163, "&pound;");
        HtmlModule.entity(array, map, revMap, 164, "&curren;");
        HtmlModule.entity(array, map, revMap, 165, "&yen;");
        HtmlModule.entity(array, map, revMap, 166, "&brvbar;");
        HtmlModule.entity(array, map, revMap, 167, "&sect;");
        HtmlModule.entity(array, map, revMap, 168, "&uml;");
        HtmlModule.entity(array, map, revMap, 169, "&copy;");
        HtmlModule.entity(array, map, revMap, 170, "&ordf;");
        HtmlModule.entity(array, map, revMap, 171, "&laquo;");
        HtmlModule.entity(array, map, revMap, 172, "&not;");
        HtmlModule.entity(array, map, revMap, 173, "&shy;");
        HtmlModule.entity(array, map, revMap, 174, "&reg;");
        HtmlModule.entity(array, map, revMap, 175, "&macr;");
        HtmlModule.entity(array, map, revMap, 176, "&deg;");
        HtmlModule.entity(array, map, revMap, 177, "&plusmn;");
        HtmlModule.entity(array, map, revMap, 178, "&sup2;");
        HtmlModule.entity(array, map, revMap, 179, "&sup3;");
        HtmlModule.entity(array, map, revMap, 180, "&acute;");
        HtmlModule.entity(array, map, revMap, 181, "&micro;");
        HtmlModule.entity(array, map, revMap, 182, "&para;");
        HtmlModule.entity(array, map, revMap, 183, "&middot;");
        HtmlModule.entity(array, map, revMap, 184, "&cedil;");
        HtmlModule.entity(array, map, revMap, 185, "&sup1;");
        HtmlModule.entity(array, map, revMap, 186, "&ordm;");
        HtmlModule.entity(array, map, revMap, 187, "&raquo;");
        HtmlModule.entity(array, map, revMap, 188, "&frac14;");
        HtmlModule.entity(array, map, revMap, 189, "&frac12;");
        HtmlModule.entity(array, map, revMap, 190, "&frac34;");
        HtmlModule.entity(array, map, revMap, 191, "&iquest;");
        HtmlModule.entity(array, map, revMap, 192, "&Agrave;");
        HtmlModule.entity(array, map, revMap, 193, "&Aacute;");
        HtmlModule.entity(array, map, revMap, 194, "&Acirc;");
        HtmlModule.entity(array, map, revMap, 195, "&Atilde;");
        HtmlModule.entity(array, map, revMap, 196, "&Auml;");
        HtmlModule.entity(array, map, revMap, 197, "&Aring;");
        HtmlModule.entity(array, map, revMap, 198, "&AElig;");
        HtmlModule.entity(array, map, revMap, 199, "&Ccedil;");
        HtmlModule.entity(array, map, revMap, 200, "&Egrave;");
        HtmlModule.entity(array, map, revMap, 201, "&Eacute;");
        HtmlModule.entity(array, map, revMap, 202, "&Ecirc;");
        HtmlModule.entity(array, map, revMap, 203, "&Euml;");
        HtmlModule.entity(array, map, revMap, 204, "&Igrave;");
        HtmlModule.entity(array, map, revMap, 205, "&Iacute;");
        HtmlModule.entity(array, map, revMap, 206, "&Icirc;");
        HtmlModule.entity(array, map, revMap, 207, "&Iuml;");
        HtmlModule.entity(array, map, revMap, 208, "&ETH;");
        HtmlModule.entity(array, map, revMap, 209, "&Ntilde;");
        HtmlModule.entity(array, map, revMap, 210, "&Ograve;");
        HtmlModule.entity(array, map, revMap, 211, "&Oacute;");
        HtmlModule.entity(array, map, revMap, 212, "&Ocirc;");
        HtmlModule.entity(array, map, revMap, 213, "&Otilde;");
        HtmlModule.entity(array, map, revMap, 214, "&Ouml;");
        HtmlModule.entity(array, map, revMap, 215, "&times;");
        HtmlModule.entity(array, map, revMap, 216, "&Oslash;");
        HtmlModule.entity(array, map, revMap, 217, "&Ugrave;");
        HtmlModule.entity(array, map, revMap, 218, "&Uacute;");
        HtmlModule.entity(array, map, revMap, 219, "&Ucirc;");
        HtmlModule.entity(array, map, revMap, 220, "&Uuml;");
        HtmlModule.entity(array, map, revMap, 221, "&Yacute;");
        HtmlModule.entity(array, map, revMap, 222, "&THORN;");
        HtmlModule.entity(array, map, revMap, 223, "&szlig;");
        HtmlModule.entity(array, map, revMap, 224, "&agrave;");
        HtmlModule.entity(array, map, revMap, 225, "&aacute;");
        HtmlModule.entity(array, map, revMap, 226, "&acirc;");
        HtmlModule.entity(array, map, revMap, 227, "&atilde;");
        HtmlModule.entity(array, map, revMap, 228, "&auml;");
        HtmlModule.entity(array, map, revMap, 229, "&aring;");
        HtmlModule.entity(array, map, revMap, 230, "&aelig;");
        HtmlModule.entity(array, map, revMap, 231, "&ccedil;");
        HtmlModule.entity(array, map, revMap, 232, "&egrave;");
        HtmlModule.entity(array, map, revMap, 233, "&eacute;");
        HtmlModule.entity(array, map, revMap, 234, "&ecirc;");
        HtmlModule.entity(array, map, revMap, 235, "&euml;");
        HtmlModule.entity(array, map, revMap, 236, "&igrave;");
        HtmlModule.entity(array, map, revMap, 237, "&iacute;");
        HtmlModule.entity(array, map, revMap, 238, "&icirc;");
        HtmlModule.entity(array, map, revMap, 239, "&iuml;");
        HtmlModule.entity(array, map, revMap, 240, "&eth;");
        HtmlModule.entity(array, map, revMap, 241, "&ntilde;");
        HtmlModule.entity(array, map, revMap, 242, "&ograve;");
        HtmlModule.entity(array, map, revMap, 243, "&oacute;");
        HtmlModule.entity(array, map, revMap, 244, "&ocirc;");
        HtmlModule.entity(array, map, revMap, 245, "&otilde;");
        HtmlModule.entity(array, map, revMap, 246, "&ouml;");
        HtmlModule.entity(array, map, revMap, 247, "&divide;");
        HtmlModule.entity(array, map, revMap, 248, "&oslash;");
        HtmlModule.entity(array, map, revMap, 249, "&ugrave;");
        HtmlModule.entity(array, map, revMap, 250, "&uacute;");
        HtmlModule.entity(array, map, revMap, 251, "&ucirc;");
        HtmlModule.entity(array, map, revMap, 252, "&uuml;");
        HtmlModule.entity(array, map, revMap, 253, "&yacute;");
        HtmlModule.entity(array, map, revMap, 254, "&thorn;");
        HtmlModule.entity(array, map, revMap, 255, "&yuml;");
        HtmlModule.entity(array, map, revMap, 8194, "&ensp;");
        HtmlModule.entity(array, map, revMap, 8201, "&thinsp;");
        HtmlModule.entity(array, map, revMap, 8216, "&lsquo;");
        HtmlModule.entity(array, map, revMap, 8224, "&dagger;");
        HtmlModule.entity(array, map, revMap, 8242, "&prime;");
        HtmlModule.entity(array, map, revMap, 8260, "&frasl;");
        HtmlModule.entity(array, map, revMap, 8364, "&euro;");
        HTML_ENTITIES_ARRAY = new ConstArrayValue(array);
    }
}

