/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.MysqliModule;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.quercus.lib.db.MysqliStatement;
import com.caucho.quercus.lib.db.QuercusConnection;
import com.caucho.quercus.lib.db.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mysqli
extends JdbcConnectionResource {
    private static final Logger log = Logger.getLogger(Mysqli.class.getName());
    private static final L10N L = new L10N(Mysqli.class);
    protected static final String DRIVER = "com.mysql.jdbc.Driver";
    private static volatile String _checkedDriverVersion = null;
    private static Object _checkDriverLock = new Object();
    private static MysqlMetaDataMethod _lastMetaDataMethod;
    private ArrayList<JdbcResultResource> _resultValues = new ArrayList();
    private int _nextResultValue = 0;
    private boolean _hasBeenUsed = true;
    private boolean _isPersistent;
    private LastSqlType _lastSql;
    private MysqlMetaDataMethod _metaDataMethod;

    public Mysqli(Env env, @Optional(value="localhost") StringValue host, @Optional StringValue user, @Optional StringValue password, @Optional String db, @Optional(value="3306") int port, @Optional StringValue socket) {
        super(env);
        String hostStr = host.length() == 0 ? "localhost" : host.toString();
        this.connectInternal(env, hostStr, user.toString(), password.toString(), db, port, socket.toString(), 0, null, null, true);
    }

    Mysqli(Env env, String host, String user, String password, String db, int port, String socket, int flags, String driver, String url, boolean isNewLink) {
        super(env);
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        this.connectInternal(env, host, user, password, db, port, socket, flags, driver, url, isNewLink);
    }

    protected Mysqli(Env env) {
        super(env);
    }

    public boolean isLastSqlDescribe() {
        return this._lastSql == LastSqlType.DESCRIBE;
    }

    @Override
    protected ConnectionEntry connectImpl(Env env, String host, String userName, String password, String dbname, int port, String socket, int flags, String driver, String url, boolean isNewLink) {
        if (this.isConnected()) {
            env.warning(L.l("Connection is already opened to '{0}'", this));
            return null;
        }
        if (port <= 0) {
            port = 3306;
        }
        try {
            ConnectionEntry jConn;
            Connection conn;
            if (host == null || host.equals("")) {
                host = "localhost";
            }
            if (driver == null || driver.equals("")) {
                driver = env.getIniBoolean("quercus-mysql-driver") ? "com.caucho.quercus.mysql.QuercusMysqlDriver" : DRIVER;
            }
            if (url == null || url.equals("")) {
                url = Mysqli.getUrl(host, port, dbname, "ISO8859_1", (flags & 0x400) != 0, (flags & 0x20) != 0, (flags & 0x800) != 0);
            }
            if (!((conn = (jConn = env.getConnection(driver, url, userName, password, !isNewLink)).getConnection()) instanceof QuercusConnection)) {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate("SET NAMES 'latin1'");
                stmt.close();
            }
            return jConn;
        }
        catch (SQLException e) {
            env.warning(L.l("A link to the server could not be established.\n  url={0}\n  driver={1}\n  {2}", url, driver, e.toString()), (Throwable)e);
            env.setSpecialValue("mysqli.connectErrno", LongValue.create(e.getErrorCode()));
            env.setSpecialValue("mysqli.connectError", env.createString(e.getMessage()));
            return null;
        }
        catch (Exception e) {
            env.warning(L.l("A link to the server could not be established.\n  url={0}\n  driver={1}\n  {2}", url, driver, e.toString()), (Throwable)e);
            env.setSpecialValue("mysqli.connectError", env.createString(e.toString()));
            return null;
        }
    }

    protected static String getUrl(String host, int port, String dbname, String encoding, boolean useInteractive, boolean useCompression, boolean useSsl) {
        char sep;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("jdbc:mysql://");
        urlBuilder.append(host);
        urlBuilder.append(":");
        urlBuilder.append(port);
        urlBuilder.append("/");
        urlBuilder.append(dbname);
        if (useInteractive) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("interactiveClient=true");
        }
        if (useCompression) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("useCompression=true");
        }
        if (useSsl) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("useSSL=true");
        }
        if (encoding != null) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("characterEncoding=");
            urlBuilder.append(encoding);
        }
        return urlBuilder.toString();
    }

    public int getaffected_rows() {
        return this.affected_rows();
    }

    public int affected_rows() {
        return this.validateConnection().getAffectedRows();
    }

    public boolean autocommit(boolean isAutoCommit) {
        return this.validateConnection().setAutoCommit(isAutoCommit);
    }

    public boolean change_user(String user, String password, String db) {
        try {
            if (this.isConnected()) {
                Connection conn = this.getJavaConnection();
                Class<?> cls = conn.getClass();
                Method method = cls.getMethod("changeUser", String.class, String.class);
                if (method != null) {
                    method.invoke((Object)conn, user, password);
                    this.select_db(db);
                    return true;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new QuercusException(e);
        }
        catch (InvocationTargetException e) {
            throw new QuercusException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusException(e);
        }
        catch (SQLException e) {
            this.getEnv().warning(L.l("unable to change user to '{0}'", user));
            return false;
        }
        this.close(this.getEnv());
        return this.connectInternal(this.getEnv(), this._host, user, password, db, this._port, this._socket, this._flags, this._driver, this._url, false);
    }

    public StringValue character_set_name(Env env) {
        return env.createString(this.getCharacterSetName());
    }

    public StringValue client_encoding(Env env) {
        return this.character_set_name(env);
    }

    public int geterrno() {
        return this.errno();
    }

    public int errno() {
        if (this.isConnected()) {
            return this.getErrorCode();
        }
        return 0;
    }

    public StringValue geterror(Env env) {
        return this.error(env);
    }

    public StringValue escape_string(StringValue str) {
        return this.real_escape_string(str);
    }

    public StringValue getclient_info(Env env) {
        return Mysqli.getClientInfo(env);
    }

    static StringValue getClientInfo(Env env) {
        String version = env.getQuercus().getMysqlVersion();
        if (version == null) {
            if (_checkedDriverVersion != null && _checkedDriverVersion != "") {
                version = _checkedDriverVersion;
            } else {
                try {
                    Driver driver = DriverManager.getDriver("jdbc:mysql://localhost/");
                    version = driver.getMajorVersion() + "." + driver.getMinorVersion() + ".00";
                }
                catch (SQLException e) {
                    version = "0.00.00";
                }
            }
        }
        return env.createString(version);
    }

    public int getclient_version(Env env) {
        return MysqliModule.mysqli_get_client_version(env);
    }

    public Value get_dbname(Env env) {
        return this.getCatalog();
    }

    public StringValue gethost_info(Env env) {
        return this.get_host_info(env);
    }

    public StringValue get_host_info(Env env) {
        return env.createString(this.getHost() + " via TCP socket");
    }

    public StringValue get_host_name(Env env) {
        return env.createString(this.getHost());
    }

    public Value getinfo(Env env) {
        return this.info(env);
    }

    Value info(Env env) {
        int matched;
        if (this.getResultResource() != null) {
            return BooleanValue.FALSE;
        }
        StringBuilder buff = new StringBuilder();
        int changed = matched = this.affected_rows();
        int duplicates = 0;
        int warnings = 0;
        SQLWarning warning = this.getWarnings();
        while (warning != null) {
            warning = warning.getNextWarning();
            ++warnings;
        }
        if (this._lastSql == LastSqlType.UPDATE) {
            buff.append("Rows matched: ");
        } else {
            buff.append("Records: ");
        }
        buff.append(matched);
        if (this._lastSql == LastSqlType.UPDATE) {
            buff.append("  Changed: ");
            buff.append(changed);
        } else {
            buff.append(" Duplicates: ");
            buff.append(duplicates);
        }
        if (this._lastSql == LastSqlType.UPDATE) {
            buff.append("  Warnings: ");
        } else {
            buff.append(" Warnings: ");
        }
        buff.append(warnings);
        return env.createString(buff.toString());
    }

    public int get_port_number() {
        return this.getPort();
    }

    public int getprotocol_version() {
        return this.get_proto_info();
    }

    public int get_proto_info() {
        return 10;
    }

    public StringValue getserver_info(Env env) {
        return this.get_server_info(env);
    }

    public StringValue get_server_info(Env env) {
        String version = env.getQuercus().getMysqlVersion();
        if (version != null) {
            return env.createString(version);
        }
        try {
            return env.createString(this.validateConnection().getServerInfo());
        }
        catch (SQLException e) {
            return env.getEmptyString();
        }
    }

    public int getserver_version() {
        return this.get_server_version();
    }

    public int get_server_version() {
        try {
            String info = this.validateConnection().getServerInfo();
            return Mysqli.infoToVersion(info);
        }
        catch (SQLException e) {
            return 0;
        }
    }

    public int getfield_count() {
        return this.field_count();
    }

    public int field_count() {
        return this.validateConnection().getFieldCount();
    }

    public Value getinsert_id(Env env) {
        return this.insert_id(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value insert_id(Env env) {
        try {
            JdbcConnectionResource connV = this.validateConnection();
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT @@identity");
                if (rs.next()) {
                    LongValue longValue = LongValue.create(rs.getLong(1));
                    return longValue;
                }
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public JdbcResultResource list_dbs() {
        return this.validateConnection().getCatalogs();
    }

    public boolean more_results() {
        return ((Mysqli)this.validateConnection()).moreResults();
    }

    public boolean multi_query(Env env, StringValue query) {
        return ((Mysqli)this.validateConnection()).multiQuery(env, query);
    }

    public boolean next_result() {
        return ((Mysqli)this.validateConnection()).nextResult();
    }

    public boolean options(int option, Value value) {
        return false;
    }

    public Value query(Env env, StringValue sqlV, @Optional(value="MYSQLI_STORE_RESULT") int resultMode) {
        String sql = sqlV.toString();
        return this.realQuery(env, sql);
    }

    @Override
    protected Value realQuery(Env env, String sql) {
        this.clearErrors();
        this._lastSql = null;
        this.setResultResource(null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("mysql_query(" + sql + ")");
        }
        try {
            Connection conn = this.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            JdbcConnectionResource.SqlParseToken tok = this.parseSqlToken(sql, null);
            if (tok != null) {
                switch (tok.getFirstChar()) {
                    case 'U': 
                    case 'u': {
                        if (tok.matchesToken("USE")) {
                            if ((tok = this.parseSqlToken(sql, tok)) == null) break;
                            String dbname = tok.toUnquotedString();
                            this.setCatalog(dbname);
                            return BooleanValue.TRUE;
                        }
                        if (tok == null || !tok.matchesToken("UPDATE")) break;
                        this._lastSql = LastSqlType.UPDATE;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (!tok.matchesToken("DESCRIBE")) break;
                        this._lastSql = LastSqlType.DESCRIBE;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        String lower;
                        if (!tok.matchesToken("SET") || (lower = sql.toLowerCase()).indexOf(" names ") < 0) break;
                        return LongValue.ONE;
                    }
                }
            }
            return super.realQuery(env, sql);
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINER, e.toString(), e);
            return BooleanValue.FALSE;
        }
        catch (IllegalStateException e) {
            log.log(Level.FINEST, e.toString(), e);
            this.saveErrors(new SQLExceptionWrapper(e));
            return BooleanValue.FALSE;
        }
    }

    public boolean real_query(Env env, StringValue query) {
        return this.multiQuery(env, query);
    }

    public MysqliStatement prepare(Env env, StringValue query) {
        MysqliStatement stmt = new MysqliStatement((Mysqli)this.validateConnection());
        boolean result = stmt.prepare(env, query);
        if (!result) {
            stmt.close();
            return null;
        }
        return stmt;
    }

    public boolean real_connect(Env env, @Optional(value="localhost") StringValue host, @Optional StringValue userName, @Optional StringValue password, @Optional StringValue dbname, @Optional(value="3306") int port, @Optional StringValue socket, @Optional int flags) {
        return this.connectInternal(env, host.toString(), userName.toString(), password.toString(), dbname.toString(), port, socket.toString(), flags, null, null, false);
    }

    public StringValue real_escape_string(StringValue str) {
        return this.realEscapeString(str);
    }

    @Override
    public boolean rollback() {
        return super.rollback();
    }

    public boolean select_db(String db) {
        try {
            if (this.isConnected()) {
                this.validateConnection().setCatalog(db);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean set_charset(String charset) {
        return false;
    }

    public boolean set_opt(int option, Value value) {
        return this.options(option, value);
    }

    public StringValue getsqlstate(Env env) {
        return this.sqlstate(env);
    }

    public StringValue sqlstate(Env env) {
        int code = this.validateConnection().getErrorCode();
        return env.createString(Mysqli.lookupSqlstate(code));
    }

    static String lookupSqlstate(int errno) {
        if (errno == 0) {
            return "00000";
        }
        return "HY" + errno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value stat(Env env) {
        StringValue stringValue;
        block9: {
            JdbcConnectionResource connV = this.validateConnection();
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            Statement stmt = null;
            StringBuilder str = new StringBuilder();
            try {
                stmt = conn.createStatement();
                stmt.execute("SHOW STATUS");
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    if (str.length() > 0) {
                        str.append(' ');
                    }
                    str.append(rs.getString(1));
                    str.append(": ");
                    str.append(rs.getString(2));
                }
                stringValue = env.createString(str.toString());
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                    return BooleanValue.FALSE;
                }
            }
            stmt.close();
        }
        return stringValue;
    }

    public MysqliStatement stmt_init(Env env) {
        return new MysqliStatement((Mysqli)this.validateConnection());
    }

    @ReturnNullAsFalse
    public JdbcResultResource store_result(Env env) {
        return ((Mysqli)this.validateConnection()).storeResult();
    }

    public Value getthread_id(Env env) {
        return this.thread_id(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Value thread_id(Env env) {
        try {
            JdbcConnectionResource connV = this.validateConnection();
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT CONNECTION_ID()");
                if (rs.next()) {
                    LongValue longValue = LongValue.create(rs.getLong(1));
                    return longValue;
                }
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill(Env env, int threadId) {
        try {
            JdbcConnectionResource connV = this.validateConnection();
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return false;
            }
            Statement stmt = null;
            boolean result = false;
            try {
                stmt = conn.createStatement();
                this._conn.markForPoolRemoval();
                ResultSet rs = stmt.executeQuery("KILL CONNECTION " + threadId);
                result = true;
                conn.close();
            }
            catch (SQLException e) {
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            return result;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean thread_safe() {
        return true;
    }

    @ReturnNullAsFalse
    public JdbcResultResource use_result(Env env) {
        return ((Mysqli)this.validateConnection()).storeResult();
    }

    public int getwarning_count(Env env) {
        return this.warning_count(env);
    }

    public int warning_count(Env env) {
        return ((Mysqli)this.validateConnection()).getWarningCount(env);
    }

    @Override
    protected JdbcResultResource createResult(Env env, Statement stmt, ResultSet rs) {
        return new MysqliResult(env, stmt, rs, this);
    }

    private int getWarningCount(Env env) {
        MysqliResult warningResult = this.metaQuery(env, "SHOW WARNINGS", this.getCatalog().toString());
        int warningCount = 0;
        if (warningResult != null) {
            warningCount = JdbcResultResource.getNumRows(warningResult.getResultSet());
        }
        if (warningCount >= 0) {
            return warningCount;
        }
        return 0;
    }

    protected MysqliResult metaQuery(Env env, String sql, String catalog) {
        this.clearErrors();
        Value currentCatalog = this.getCatalog();
        try {
            Connection conn = this.getConnection(env);
            if (conn == null) {
                return null;
            }
            conn.setCatalog(catalog);
            Statement stmt = conn.createStatement();
            stmt.setEscapeProcessing(false);
            if (stmt.execute(sql)) {
                MysqliResult result = (MysqliResult)this.createResult(this.getEnv(), stmt, stmt.getResultSet());
                conn.setCatalog(currentCatalog.toString());
                return result;
            }
            conn.setCatalog(currentCatalog.toString());
            return null;
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    private boolean moreResults() {
        return !this._hasBeenUsed || this._nextResultValue < this._resultValues.size() - 1;
    }

    private boolean multiQuery(Env env, StringValue sql) {
        this.clearErrors();
        this._resultValues.clear();
        ArrayList<String> splitQuery = this.splitMultiQuery(sql);
        Statement stmt = null;
        try {
            this.setResultResource(null);
            for (String s : splitQuery) {
                Connection conn = this.getConnection(env);
                if (conn == null) {
                    return false;
                }
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                if (stmt.execute(s)) {
                    this.setAffectedRows(0);
                    this.setResultResource(this.createResult(this.getEnv(), stmt, stmt.getResultSet()));
                    this._resultValues.add(this.getResultResource());
                    this.setWarnings(stmt.getWarnings());
                    continue;
                }
                this.setAffectedRows(stmt.getUpdateCount());
                this.setWarnings(stmt.getWarnings());
            }
        }
        catch (DataTruncation truncationError) {
            try {
                this.setAffectedRows(stmt.getUpdateCount());
                this.setWarnings(stmt.getWarnings());
            }
            catch (SQLException e) {
                this.saveErrors(e);
                log.log(Level.WARNING, e.toString(), e);
                return false;
            }
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        if (this._resultValues.size() > 0) {
            this._nextResultValue = 0;
            this._hasBeenUsed = false;
        }
        return true;
    }

    private boolean nextResult() {
        if (this._nextResultValue + 1 < this._resultValues.size()) {
            this._hasBeenUsed = false;
            ++this._nextResultValue;
            return true;
        }
        return false;
    }

    private ArrayList<String> splitMultiQuery(StringValue sqlStr) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder queryBuffer = new StringBuilder(64);
        String sql = sqlStr.toString();
        int length = sql.length();
        boolean inQuotes = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (c == '\\') {
                queryBuffer.append(c);
                if (i >= length - 1) continue;
                queryBuffer.append(sql.charAt(i + 1));
                ++i;
                continue;
            }
            if (inQuotes) {
                queryBuffer.append(c);
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            if (c == '\'') {
                queryBuffer.append(c);
                inQuotes = true;
                continue;
            }
            if (c == ';') {
                result.add(queryBuffer.toString().trim());
                queryBuffer = new StringBuilder(64);
                continue;
            }
            queryBuffer.append(c);
        }
        if (queryBuffer.length() > 0) {
            result.add(queryBuffer.toString().trim());
        }
        return result;
    }

    private JdbcResultResource storeResult() {
        if (!this._hasBeenUsed) {
            this._hasBeenUsed = true;
            return this._resultValues.get(this._nextResultValue);
        }
        return null;
    }

    public void setPersistent() {
        this._isPersistent = true;
    }

    Method getColumnCharacterSetMethod(Class metaDataClass) {
        if (this._metaDataMethod == null) {
            MysqlMetaDataMethod metaDataMethod = _lastMetaDataMethod;
            if (metaDataMethod == null || metaDataMethod.getMetaDataClass() != metaDataClass) {
                _lastMetaDataMethod = metaDataMethod = new MysqlMetaDataMethod(metaDataClass);
            }
            this._metaDataMethod = metaDataMethod;
        }
        return this._metaDataMethod.getColumnCharacterSetMethod();
    }

    private static String checkDriverVersionImpl(Env env, Connection conn) throws SQLException {
        int start;
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = conn.getMetaData();
        }
        catch (SQLException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (databaseMetaData == null) {
            return "";
        }
        String fullVersion = null;
        try {
            fullVersion = databaseMetaData.getDriverVersion();
        }
        catch (SQLException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (fullVersion == null) {
            return "";
        }
        String version = fullVersion;
        int end = version.indexOf(32);
        String checkedDriverVersion = "";
        if (end != -1 && (start = (version = version.substring(0, end)).lastIndexOf(45)) != -1) {
            version = version.substring(start + 1);
            start = version.indexOf(46);
            end = version.lastIndexOf(46);
            int major = Integer.valueOf(version.substring(0, start));
            int minor = Integer.valueOf(version.substring(start + 1, end));
            int release = Integer.valueOf(version.substring(end + 1));
            checkedDriverVersion = major + "." + minor + "." + release;
            if (major < 5 && (major != 3 || minor <= 1 && (minor != 1 || release < 14))) {
                String message = L.l("Your MySQL Connector/J JDBC {0} driver may have issues with character encoding.  The recommended JDBC version is 3.1.14/5+.", version);
                log.log(Level.WARNING, message);
                env.warning(message);
            }
        }
        return checkedDriverVersion;
    }

    @Override
    public boolean close(Env env) {
        return super.close(env);
    }

    @Override
    public String toString() {
        if (this._conn != null && this._conn.getConnection() != null) {
            Class<?> cls = this._conn.getConnection().getClass();
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("toString") || methods[i].getParameterTypes().length != 0) continue;
                return "Mysqli[" + this._conn.getConnection() + "]";
            }
            return "Mysqli[" + cls.getCanonicalName() + "]";
        }
        return "Mysqli[" + null + "]";
    }

    static class MysqlMetaDataMethod {
        private Class _resultSetMetaDataClass;
        private Method _getColumnCharacterSetMethod;

        MysqlMetaDataMethod(Class resultSetMetaDataClass) {
            this._resultSetMetaDataClass = resultSetMetaDataClass;
            try {
                this._getColumnCharacterSetMethod = this._resultSetMetaDataClass.getMethod("getColumnCharacterSet", Integer.TYPE);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }

        Class getMetaDataClass() {
            return this._resultSetMetaDataClass;
        }

        Method getColumnCharacterSetMethod() {
            return this._getColumnCharacterSetMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LastSqlType {
        NONE,
        UPDATE,
        DESCRIBE;

    }
}

