/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.QuercusResultSet;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

@ResourceType(value="mysql result")
public class MysqliResult
extends JdbcResultResource {
    private static final Logger log = Logger.getLogger(MysqliResult.class.getName());
    private static final L10N L = new L10N(MysqliResult.class);
    private int _resultSetSize;

    public MysqliResult(Env env, Statement stmt, ResultSet rs, Mysqli conn) {
        super(env, stmt, rs, conn);
        this._resultSetSize = this.getNumRows();
    }

    public MysqliResult(Env env, ResultSetMetaData metaData, Mysqli conn) {
        super(env, metaData, conn);
    }

    public String getResourceType() {
        return "mysql result";
    }

    public boolean isLastSqlDescribe() {
        return ((Mysqli)this.getConnection()).isLastSqlDescribe();
    }

    public boolean data_seek(Env env, int rowNumber) {
        return this.seek(env, rowNumber);
    }

    @ReturnNullAsFalse
    public ArrayValue fetch_array(Env env, @Optional(value="MYSQLI_BOTH") int type) {
        if (type != 1 && type != 3 && type != 2) {
            env.warning(L.l("invalid result_type"));
            return null;
        }
        return this.fetchArray(env, type);
    }

    public ArrayValue fetch_assoc(Env env) {
        return this.fetchArray(env, 1);
    }

    public Value fetch_field_direct(Env env, int offset) {
        return this.fetchFieldDirect(env, offset);
    }

    public Value fetch_field(Env env) {
        return this.fetchNextField(env);
    }

    public Value fetch_fields(Env env) {
        return this.getFieldDirectArray(env);
    }

    public Value fetch_lengths() {
        return this.getLengths();
    }

    public Value fetch_object(Env env) {
        return this.fetchObject(env);
    }

    public ArrayValue fetch_row(Env env) {
        return this.fetchArray(env, 2);
    }

    public int field_count(Env env) {
        return this.getFieldCount();
    }

    protected Value fetchFieldDirect(Env env, int fieldOffset) {
        if (!this.isValidFieldOffset(fieldOffset)) {
            return BooleanValue.FALSE;
        }
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md == null) {
                return BooleanValue.FALSE;
            }
            int offset = fieldOffset + 1;
            if (offset < 1 || md.getColumnCount() < offset) {
                return BooleanValue.FALSE;
            }
            int jdbcType = md.getColumnType(offset);
            String catalogName = md.getCatalogName(offset);
            String fieldTable = md.getTableName(offset);
            String fieldSchema = md.getSchemaName(offset);
            String fieldName = md.getColumnName(offset);
            String fieldAlias = md.getColumnLabel(offset);
            String fieldMysqlType = md.getColumnTypeName(offset);
            int fieldLength = md.getPrecision(offset);
            int fieldScale = md.getScale(offset);
            if (fieldTable == null || "".equals(fieldTable)) {
                return this.fetchFieldImproved(env, md, offset);
            }
            String sql = "SHOW FULL COLUMNS FROM " + fieldTable + " LIKE '" + fieldName + "'";
            MysqliResult metaResult = ((Mysqli)this.getConnection()).metaQuery(env, sql, catalogName);
            if (metaResult == null) {
                return this.fetchFieldImproved(env, md, offset);
            }
            return metaResult.fetchFieldImproved(env, fieldLength, fieldAlias, fieldName, fieldTable, jdbcType, fieldMysqlType, fieldScale);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected Value fetchFieldImproved(Env env, ResultSetMetaData md, int offset) {
        ObjectValue result = env.createObject();
        try {
            int jdbcType = md.getColumnType(offset);
            String catalogName = md.getCatalogName(offset);
            String fieldTable = md.getTableName(offset);
            String fieldSchema = md.getSchemaName(offset);
            String fieldName = md.getColumnName(offset);
            String fieldAlias = md.getColumnLabel(offset);
            String mysqlType = md.getColumnTypeName(offset);
            int fieldLength = md.getPrecision(offset);
            int scale = md.getScale(offset);
            if ((fieldTable == null || "".equals(fieldTable)) && ((Mysqli)this.getConnection()).isLastSqlDescribe()) {
                fieldTable = "COLUMNS";
            }
            ((Value)result).putField(env, "name", (Value)env.createString(fieldAlias));
            ((Value)result).putField(env, "orgname", (Value)env.createString(fieldName));
            ((Value)result).putField(env, "table", (Value)env.createString(fieldTable));
            ((Value)result).putField(env, "orgtable", (Value)env.createString(fieldTable));
            ((Value)result).putField(env, "def", (Value)env.createString(""));
            ((Value)result).putField(env, "max_length", (Value)LongValue.ZERO);
            ((Value)result).putField(env, "length", (Value)LongValue.create(fieldLength));
            long flags = 0L;
            ((Value)result).putField(env, "flags", (Value)LongValue.create(flags));
            int quercusType = 0;
            switch (jdbcType) {
                case 3: {
                    quercusType = 0;
                    break;
                }
                case -7: {
                    if (mysqlType.equals("BIT")) {
                        quercusType = 16;
                        break;
                    }
                    quercusType = 1;
                    break;
                }
                case 5: {
                    quercusType = 2;
                    break;
                }
                case 4: {
                    if (!this.isInResultString(2, "medium")) {
                        quercusType = 3;
                        break;
                    }
                    quercusType = 9;
                    break;
                }
                case 7: {
                    quercusType = 4;
                    break;
                }
                case 8: {
                    quercusType = 5;
                    break;
                }
                case -5: {
                    quercusType = 8;
                    break;
                }
                case 91: {
                    if (mysqlType.equals("YEAR")) {
                        quercusType = 13;
                        break;
                    }
                    quercusType = 10;
                    break;
                }
                case -6: {
                    quercusType = 1;
                    break;
                }
                case 92: {
                    quercusType = 11;
                    break;
                }
                case 93: {
                    if (mysqlType.equals("TIMESTAMP")) {
                        quercusType = 7;
                        break;
                    }
                    quercusType = 12;
                    break;
                }
                case -4: 
                case -1: {
                    quercusType = 252;
                    break;
                }
                case -2: 
                case 1: {
                    quercusType = 254;
                    break;
                }
                case -3: 
                case 12: {
                    quercusType = 253;
                    break;
                }
                default: {
                    quercusType = 6;
                }
            }
            ((Value)result).putField(env, "type", (Value)LongValue.create(quercusType));
            ((Value)result).putField(env, "decimals", (Value)LongValue.create(scale));
            ((Value)result).putField(env, "charsetnr", (Value)LongValue.ZERO);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
        return result;
    }

    protected Value fetchFieldImproved(Env env, int fieldLength, String name, String originalName, String table, int jdbcType, String mysqlType, int scale) {
        ObjectValue result = env.createObject();
        try {
            ResultSetMetaData md = this.getMetaData();
            if (!this._rs.next()) {
                return BooleanValue.FALSE;
            }
            ((Value)result).putField(env, "name", (Value)env.createString(name));
            ((Value)result).putField(env, "orgname", (Value)env.createString(originalName));
            ((Value)result).putField(env, "table", (Value)env.createString(table));
            ((Value)result).putField(env, "orgtable", (Value)env.createString(table));
            ((Value)result).putField(env, "def", (Value)env.createString(this._rs.getString(6)));
            ((Value)result).putField(env, "max_length", (Value)LongValue.ZERO);
            ((Value)result).putField(env, "length", (Value)LongValue.create(fieldLength));
            long flags = 0L;
            if (!this.isInResultString(4, "YES")) {
                ++flags;
            }
            if (this.isInResultString(5, "PRI")) {
                flags += 2L;
                flags += 16384L;
            }
            if (this.isInResultString(5, "MUL")) {
                flags += 8L;
                flags += 16384L;
            }
            if (this.isInResultString(2, "blob") || jdbcType == -1 || jdbcType == -4) {
                flags += 16L;
            }
            if (this.isInResultString(2, "unsigned")) {
                flags += 32L;
            }
            if (this.isInResultString(2, "zerofill")) {
                flags += 64L;
            }
            if (this.isInResultString(3, "bin") || jdbcType == -4 || jdbcType == 91 || jdbcType == 93) {
                flags += 128L;
            }
            if (this.isInResultString(2, "enum")) {
                flags += 256L;
            }
            if (this.isInResultString(7, "auto")) {
                flags += 512L;
            }
            if (this.isInResultString(2, "set")) {
                flags += 2048L;
            }
            if (jdbcType == -5 || jdbcType == -7 || jdbcType == 16 || jdbcType == 3 || jdbcType == 8 || jdbcType == 7 || jdbcType == 4 || jdbcType == 5) {
                flags += 32768L;
            }
            ((Value)result).putField(env, "flags", (Value)LongValue.create(flags));
            int quercusType = 0;
            switch (jdbcType) {
                case 3: {
                    quercusType = 0;
                    break;
                }
                case -7: {
                    if (mysqlType.equals("BIT")) {
                        quercusType = 16;
                        break;
                    }
                    quercusType = 1;
                    break;
                }
                case 5: {
                    quercusType = 2;
                    break;
                }
                case 4: {
                    if (!this.isInResultString(2, "medium")) {
                        quercusType = 3;
                        break;
                    }
                    quercusType = 9;
                    break;
                }
                case 7: {
                    quercusType = 4;
                    break;
                }
                case 8: {
                    quercusType = 5;
                    break;
                }
                case -5: {
                    quercusType = 8;
                    break;
                }
                case 91: {
                    if (mysqlType.equals("YEAR")) {
                        quercusType = 13;
                        break;
                    }
                    quercusType = 10;
                    break;
                }
                case -6: {
                    quercusType = 1;
                    break;
                }
                case 92: {
                    quercusType = 11;
                    break;
                }
                case 93: {
                    if (mysqlType.equals("TIMESTAMP")) {
                        quercusType = 7;
                        break;
                    }
                    quercusType = 12;
                    break;
                }
                case -4: 
                case -1: {
                    quercusType = 252;
                    break;
                }
                case -2: 
                case 1: {
                    quercusType = 254;
                    break;
                }
                case -3: 
                case 12: {
                    quercusType = 253;
                    break;
                }
                default: {
                    quercusType = 6;
                }
            }
            ((Value)result).putField(env, "type", (Value)LongValue.create(quercusType));
            ((Value)result).putField(env, "decimals", (Value)LongValue.create(scale));
            ((Value)result).putField(env, "charsetnr", (Value)LongValue.ZERO);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
        return result;
    }

    public Value getFieldFlagsImproved(Env env, int jdbcType, String mysqlType) {
        try {
            boolean isTimestamp;
            StringBuilder flags = new StringBuilder();
            if (!this._rs.next()) {
                return BooleanValue.FALSE;
            }
            if (!this.isInResultString(4, "YES")) {
                flags.append("not_null");
            }
            if (this.isInResultString(5, "PRI")) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("primary_key");
            } else if (this.isInResultString(5, "MUL")) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("multiple_key");
            }
            boolean bl = isTimestamp = jdbcType == 93 && mysqlType.equals("TIMESTAMP");
            if (this.isInResultString(2, "blob") || jdbcType == -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("blob");
            }
            if (this.isInResultString(2, "unsigned") || jdbcType == -7 && mysqlType.equals("BIT") || isTimestamp) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("unsigned");
            }
            if (this.isInResultString(2, "zerofill") || isTimestamp) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("zerofill");
            }
            if (this.isInResultString(3, "bin") || jdbcType == -2 || jdbcType == -4 || jdbcType == -3 || jdbcType == 92 || isTimestamp || this.isInResultString(2, "date")) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("binary");
            }
            if (this.isInResultString(2, "enum")) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("enum");
            }
            if (this.isInResultString(2, "set")) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("set");
            }
            if (this.isInResultString(7, "auto_increment")) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("auto_increment");
            }
            if (isTimestamp) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("timestamp");
            }
            return env.createString(flags.toString());
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected String getMysqlType(int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            return md.getColumnTypeName(fieldOffset + 1);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    protected String getFieldType(int fieldOffset, int jdbcType) {
        if (jdbcType == 93) {
            String mysqlType = this.getMysqlType(fieldOffset);
            if (mysqlType.equals("TIMESTAMP")) {
                return "timestamp";
            }
            return "datetime";
        }
        if (jdbcType == 91) {
            String mysqlType = this.getMysqlType(fieldOffset);
            if (mysqlType.equals("YEAR")) {
                return "year";
            }
            return "date";
        }
        return super.getFieldType(fieldOffset, jdbcType);
    }

    protected Value fetchNextField(Env env) {
        int fieldOffset = this.getFieldOffset();
        Value result = this.fetchFieldDirect(env, fieldOffset);
        this.setFieldOffset(fieldOffset + 1);
        return result;
    }

    public boolean field_seek(Env env, int offset) {
        boolean success = this.setFieldOffset(offset);
        if (!success) {
            env.invalidArgument("field", offset);
        }
        return success;
    }

    public int field_tell(Env env) {
        return this.getFieldOffset();
    }

    public void free() {
        this.close();
    }

    public void free_result() {
        this.close();
    }

    public Value getFieldDirectArray(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        try {
            int numColumns = this.getMetaData().getColumnCount();
            for (int i = 0; i < numColumns; ++i) {
                ((ArrayValue)array).put(this.fetchFieldDirect(env, i));
            }
            return array;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int num_fields() {
        return this.getFieldCount();
    }

    public int num_rows() {
        return this._resultSetSize;
    }

    protected Value getColumnString(Env env, ResultSet rs, ResultSetMetaData md, int column) throws SQLException {
        Mysqli mysqli = this.getMysqli();
        if (rs instanceof QuercusResultSet) {
            QuercusResultSet qRs = (QuercusResultSet)rs;
            int length = qRs.getStringLength(column);
            if (length < 0) {
                return NullValue.NULL;
            }
            StringBuilderValue sb = new StringBuilderValue();
            sb.ensureAppendCapacity(length);
            qRs.getString(column, sb.getBuffer(), sb.getOffset());
            sb.setOffset(sb.getOffset() + length);
            return sb;
        }
        Method getColumnCharacterSetMethod = mysqli.getColumnCharacterSetMethod(md.getClass());
        String encoding = null;
        try {
            if (getColumnCharacterSetMethod != null) {
                encoding = (String)getColumnCharacterSetMethod.invoke((Object)md, column);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (encoding == null) {
            String value = rs.getString(column);
            if (value != null) {
                return env.createString(value);
            }
            return NullValue.NULL;
        }
        if ("UTF-8".equals(encoding)) {
            byte[] bytes = rs.getBytes(column);
            if (bytes == null) {
                return NullValue.NULL;
            }
            StringValue bb = env.createUnicodeBuilder();
            int length = bytes.length;
            boolean offset = false;
            bb.appendUtf8(bytes);
            return bb;
        }
        if ("Cp1252".equals(encoding) || "LATIN1".equals(encoding)) {
            byte[] bytes = rs.getBytes(column);
            if (bytes == null) {
                return NullValue.NULL;
            }
            StringValue bb = env.createUnicodeBuilder();
            bb.append(bytes);
            return bb;
        }
        String value = rs.getString(column);
        if (value != null) {
            return env.createString(value);
        }
        return NullValue.NULL;
    }

    protected Mysqli getMysqli() {
        return (Mysqli)this.getConnection();
    }
}

