/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.db.PDOException;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class PDOError {
    private static final L10N L = new L10N(PDOError.class);
    private static final Logger log = Logger.getLogger(PDOError.class.getName());
    private static final int ERRMODE_SILENT = 0;
    private static final int ERRMODE_WARNING = 1;
    private static final int ERRMODE_EXCEPTION = 2;
    private static final String ERR_NONE = "00000";
    private static final String ERR_GENERAL = "HY000";
    private final Env _env;
    private int _errmode;
    private boolean _isError;
    private String _errorCode = "00000";
    private ArrayValue _errorInfo;

    public PDOError(Env env) {
        this._env = env;
    }

    public void clear() {
        this._isError = false;
        this._errorCode = ERR_NONE;
        this._errorInfo = null;
    }

    private void error(String errorCode, int driverError, String errorMessage) {
        this._isError = true;
        int level = Math.max(this._errmode, 0);
        this._errorCode = errorCode;
        this._errorInfo = new ArrayValueImpl();
        this._errorInfo.put(errorCode);
        this._errorInfo.put(driverError);
        this._errorInfo.put(errorMessage);
        if (level == 1) {
            this._env.warning("SQLSTATE[" + errorCode + "]: " + errorMessage);
        } else if (level == 2) {
            throw new PDOException(errorCode, errorMessage);
        }
    }

    public void error(Throwable exception) {
        int driverError;
        String errorMessage;
        String errorCode;
        log.log(Level.FINE, exception.toString(), exception);
        if (exception instanceof SQLException) {
            SQLException sqlException = (SQLException)exception;
            errorCode = sqlException.getSQLState();
            errorMessage = sqlException.getMessage();
            driverError = sqlException.getErrorCode();
        } else {
            errorCode = ERR_GENERAL;
            errorMessage = exception.getMessage();
            driverError = 0;
        }
        this.error(errorCode, driverError, errorMessage);
    }

    public String errorCode() {
        return this._errorCode;
    }

    public ArrayValue errorInfo() {
        if (this._errorInfo == null) {
            this._errorInfo = new ArrayValueImpl();
            this._errorInfo.put(ERR_NONE);
        }
        return this._errorInfo;
    }

    public int getErrmode() {
        return this._errmode;
    }

    public boolean isError() {
        return this._isError;
    }

    public void notice(String message) {
        this._isError = true;
        this._errorCode = ERR_GENERAL;
        this._errorInfo = new ArrayValueImpl();
        this._errorInfo.put(this._errorCode);
        this._errorInfo.put(2050L);
        this._errorInfo.put("");
        this._env.notice(message);
    }

    public boolean setErrmode(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                this._errmode = value;
                return true;
            }
        }
        this.warning(L.l("invalid error mode"));
        return false;
    }

    public void warning(String message) {
        this._isError = true;
        this._errorCode = ERR_GENERAL;
        this._errorInfo = new ArrayValueImpl();
        this._errorInfo.put(this._errorCode);
        if (this._errmode == 2) {
            throw new PDOException(this._errorCode, message);
        }
        this._env.warning("SQLSTATE[" + this._errorCode + "]: " + message);
    }

    public void unsupportedAttribute(int attribute) {
        this.error("IM001", 0, L.l("attribute `{0}' is not supported", attribute));
    }

    public void unsupportedAttributeValue(Object value) {
        this.error("IM001", 0, L.l("attribute value `{0}' is not supported", value));
    }
}

