/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.Path;
import java.io.IOException;

public class DirectoryValue
extends ResourceValue {
    private Env _env;
    private Path _path;
    private String[] _list;
    private int _index;

    protected DirectoryValue(Env env) {
        this._env = env;
    }

    public DirectoryValue(Env env, Path path) throws IOException {
        this._env = env;
        this._path = path;
        this._list = path.list();
    }

    public Value readdir() {
        if (this._index < this._list.length) {
            return this._env.createString(this._list[this._index++]);
        }
        return BooleanValue.FALSE;
    }

    public void rewinddir() {
        this._index = 0;
    }

    public Value callMethod(Env env, StringValue methodName, int hash) {
        String method = methodName.toString();
        if ("read".equals(method)) {
            return this.readdir();
        }
        if ("rewind".equals(method)) {
            this.rewinddir();
            return BooleanValue.TRUE;
        }
        if ("close".equals(method)) {
            this.close();
            return BooleanValue.TRUE;
        }
        return super.callMethod(env, methodName, hash);
    }

    public String toString() {
        return "Directory[" + this._path + "]";
    }
}

