/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.BufferedBinaryInputOutput;
import com.caucho.quercus.lib.file.SocketInputOutput;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TcpInputOutput
extends BufferedBinaryInputOutput
implements SocketInputOutput {
    private static final Logger log = Logger.getLogger(TcpInputOutput.class.getName());
    private Socket _socket;
    private SocketInputOutput.Domain _domain;
    private int _errno;

    public TcpInputOutput(Env env, String host, int port, boolean isSecure, SocketInputOutput.Domain domain) throws IOException {
        super(env);
        env.addCleanup(this);
        if (isSecure) {
            try {
                this._socket = this.createSSLSocket(host, port);
            }
            catch (KeyManagementException e) {
                throw new QuercusException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new QuercusException(e);
            }
        } else {
            this._socket = SocketFactory.getDefault().createSocket(host, port);
        }
        this._domain = domain;
    }

    public TcpInputOutput(Env env, Socket socket, SocketInputOutput.Domain domain) {
        super(env);
        env.addCleanup(this);
        this._socket = socket;
        this._domain = domain;
    }

    private Socket createSSLSocket(String host, int port) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        Socket s = new Socket(host, port);
        SSLContext context = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] cert, String foo) {
            }

            public void checkServerTrusted(X509Certificate[] cert, String foo) {
            }
        };
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        return factory.createSocket(s, host, port, true);
    }

    public void bind(SocketAddress address) throws IOException {
        this._socket.bind(address);
    }

    public void connect(SocketAddress address) throws IOException {
        this._socket.connect(address);
        this.init();
    }

    public void setError(int errno) {
        this._errno = errno;
    }

    public int getError() {
        return this._errno;
    }

    public void init() {
        SocketStream sock = new SocketStream(this._socket);
        sock.setThrowReadInterrupts(true);
        WriteStream os = new WriteStream(sock);
        ReadStream is = new ReadStream(sock, os);
        this.init(is, os);
    }

    public void setTimeout(long timeout) {
        try {
            if (this._socket != null) {
                this._socket.setSoTimeout((int)timeout);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public void write(int ch) throws IOException {
        super.write(ch);
        this.flush();
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        super.write(buffer, offset, length);
        this.flush();
    }

    public int write(InputStream is, int length) throws IOException {
        int writeLength = super.write(is, length);
        this.flush();
        return writeLength;
    }

    public void cleanup() {
        Socket s = this._socket;
        this._socket = null;
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public String toString() {
        if (this._socket != null) {
            return "TcpInputOutput[" + this._socket.getInetAddress() + "," + this._socket.getPort() + "]";
        }
        return "TcpInputOutput[closed]";
    }
}

