/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.UrlModule;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.quercus.lib.zlib.ZlibModule;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class ZlibProtocolWrapper
extends ProtocolWrapper {
    private static final Logger log = Logger.getLogger(ZlibProtocolWrapper.class.getName());
    private static final L10N L = new L10N(ZlibProtocolWrapper.class);

    public BinaryStream fopen(Env env, StringValue path, StringValue mode, LongValue options) {
        boolean useIncludePath = (options.toLong() & 1L) != 0L;
        Value pathComponent = UrlModule.parse_url(env, path, 5);
        if (!pathComponent.isset()) {
            log.info(L.l("no path component found in '{0}'", path.toString()));
            return null;
        }
        return ZlibModule.gzopen(env, pathComponent.toStringValue(), mode.toString(), useIncludePath);
    }

    public Value opendir(Env env, StringValue path, LongValue flags) {
        env.warning(L.l("opendir not supported by protocol"));
        return BooleanValue.FALSE;
    }

    public boolean unlink(Env env, StringValue path) {
        env.warning(L.l("unlink not supported by protocol"));
        return false;
    }

    public boolean rename(Env env, StringValue path_from, StringValue path_to) {
        env.warning(L.l("rename not supported by protocol"));
        return false;
    }

    public boolean mkdir(Env env, StringValue path, LongValue mode, LongValue options) {
        env.warning(L.l("mkdir not supported by protocol"));
        return false;
    }

    public boolean rmdir(Env env, StringValue path, LongValue options) {
        env.warning(L.l("rmdir not supported by protocol"));
        return false;
    }

    public Value url_stat(Env env, StringValue path, LongValue flags) {
        env.warning(L.l("stat not supported by protocol"));
        return BooleanValue.FALSE;
    }
}

