/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.Big5Encoder;
import com.caucho.quercus.lib.i18n.GenericEncoder;
import com.caucho.quercus.lib.i18n.Utf8Encoder;

public abstract class Encoder {
    protected static final int ERROR_CHARACTER = 65534;
    protected String _charset;
    protected String _replacement;
    protected boolean _isIgnore;
    protected boolean _isReplaceUnicode = false;

    protected Encoder(String charset) {
        this._charset = charset;
    }

    public static Encoder create(String charset) {
        if (charset.equalsIgnoreCase("utf8") || charset.equalsIgnoreCase("utf-8")) {
            return new Utf8Encoder();
        }
        if (charset.equalsIgnoreCase("big5") || charset.equalsIgnoreCase("big-5")) {
            return new Big5Encoder(charset);
        }
        return new GenericEncoder(charset);
    }

    public boolean isUtf8() {
        return false;
    }

    public boolean isIgnore() {
        return this._isIgnore;
    }

    public void setIgnoreErrors(boolean isIgnore) {
        this._isIgnore = isIgnore;
    }

    public void setReplacement(String replacement) {
        this._replacement = replacement;
    }

    public final void setReplaceUnicode(boolean isReplaceUnicode) {
        this._isReplaceUnicode = isReplaceUnicode;
    }

    public void reset() {
    }

    public abstract boolean isEncodable(Env var1, StringValue var2);

    public abstract StringValue encode(Env var1, CharSequence var2);

    public final StringValue encode(Env env, CharSequence str, boolean isReset) {
        if (isReset) {
            this.reset();
        }
        return this.encode(env, str);
    }
}

