/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.Encoder;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class Utf8Encoder
extends Encoder {
    private static final Logger log = Logger.getLogger(Utf8Encoder.class.getName());
    private static final L10N L = new L10N(Utf8Encoder.class);

    public Utf8Encoder() {
        super("utf-8");
    }

    public boolean isUtf8() {
        return true;
    }

    public boolean isEncodable(Env env, StringValue str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch = str.charAt(i);
            if (ch <= '\u007f' || '\ud800' > ch || ch > '\udbff') continue;
            if (i + 1 < len && '\udc00' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\udfff') {
                ++i;
                continue;
            }
            return false;
        }
        return true;
    }

    public StringValue encode(Env env, CharSequence str) {
        StringValue sb = env.createBinaryBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int ch = str.charAt(i);
            if (ch <= 127) {
                sb.appendByte(ch);
                continue;
            }
            int code = ch;
            if (55296 <= ch && ch <= 56319) {
                char ch2;
                if (i + 1 < len && '\udc00' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\udfff') {
                    ++i;
                    code = 65536 + (ch - 55296 << 10) + (ch2 - 56320);
                } else {
                    if (this._isIgnore) continue;
                    if (this._replacement != null) {
                        sb.append(this._replacement);
                        continue;
                    }
                    return sb;
                }
            }
            if (128 <= code && code <= 2047) {
                sb.appendByte(0xC0 | code >> 6);
                sb.appendByte(0x80 | code & 0x3F);
                continue;
            }
            if (2048 <= code && code <= 65535) {
                sb.appendByte(0xE0 | code >> 12);
                sb.appendByte(0x80 | code >> 6 & 0x3F);
                sb.appendByte(0x80 | code & 0x3F);
                continue;
            }
            sb.appendByte(0xF0 | code >> 18);
            sb.appendByte(0x80 | code >> 12 & 0x3F);
            sb.appendByte(0x80 | code >> 6 & 0x3F);
            sb.appendByte(0x80 | code & 0x3F);
        }
        return sb;
    }
}

