/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.json;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;

class JsonDecoder {
    private static final L10N L = new L10N(JsonDecoder.class);
    private StringValue _str;
    private int _len;
    private int _offset;
    private boolean _isAssociative;

    JsonDecoder() {
    }

    public Value jsonDecode(Env env, StringValue s, boolean assoc) {
        this._str = s;
        this._len = this._str.length();
        this._offset = 0;
        this._isAssociative = assoc;
        Value val = this.jsonDecodeImpl(env, true);
        this.skipWhitespace();
        if (this._offset < this._len) {
            return this.errorReturn(env, "expected no more input");
        }
        return val;
    }

    private Value jsonDecodeImpl(Env env, boolean isTop) {
        this.skipWhitespace();
        if (this._len <= this._offset) {
            return this.errorReturn(env);
        }
        char ch = this._str.charAt(this._offset);
        switch (ch) {
            case '\"': {
                ++this._offset;
                return this.decodeString(env, true);
            }
            case 'T': 
            case 't': {
                if (isTop && this._offset + 4 < this._len) {
                    return this.decodeString(env, false);
                }
                if (this._offset + 3 < this._len) {
                    char ch2 = this._str.charAt(this._offset + 1);
                    char ch3 = this._str.charAt(this._offset + 2);
                    char ch4 = this._str.charAt(this._offset + 3);
                    if (!(ch2 != 'r' && ch2 != 'R' || ch3 != 'u' && ch3 != 'U' || ch4 != 'e' && ch4 != 'E')) {
                        if (this._offset + 4 < this._len && (ch = this._str.charAt(this._offset + 4)) != ',' && ch != ']' && ch != '}' && !Character.isWhitespace(ch)) {
                            return this.errorReturn(env, "malformed 'true'");
                        }
                        this._offset += 4;
                        return BooleanValue.TRUE;
                    }
                }
                if (isTop) {
                    return this.decodeString(env, false);
                }
                return this.errorReturn(env, "expected 'true'");
            }
            case 'F': 
            case 'f': {
                if (isTop && this._offset + 5 < this._len) {
                    return this.decodeString(env, false);
                }
                if (this._offset + 4 < this._len) {
                    char ch2 = this._str.charAt(this._offset + 1);
                    char ch3 = this._str.charAt(this._offset + 2);
                    char ch4 = this._str.charAt(this._offset + 3);
                    char ch5 = this._str.charAt(this._offset + 4);
                    if (!(ch2 != 'a' && ch2 != 'A' || ch3 != 'l' && ch3 != 'L' || ch4 != 's' && ch4 != 'S' || ch5 != 'e' && ch5 != 'E')) {
                        if (this._offset + 5 < this._len && (ch = this._str.charAt(this._offset + 5)) != ',' && ch != ']' && ch != '}' && !Character.isWhitespace(ch)) {
                            return this.errorReturn(env, "malformed 'false'");
                        }
                        this._offset += 5;
                        return BooleanValue.FALSE;
                    }
                }
                if (isTop) {
                    return this.decodeString(env, false);
                }
                return this.errorReturn(env, "expected 'false'");
            }
            case 'N': 
            case 'n': {
                if (isTop && this._offset + 4 < this._len) {
                    return this.decodeString(env, false);
                }
                if (this._offset + 3 < this._len) {
                    char ch2 = this._str.charAt(this._offset + 1);
                    char ch3 = this._str.charAt(this._offset + 2);
                    char ch4 = this._str.charAt(this._offset + 3);
                    if (!(ch2 != 'u' && ch2 != 'U' || ch3 != 'l' && ch3 != 'L' || ch4 != 'l' && ch4 != 'L')) {
                        if (this._offset + 4 < this._len && (ch = this._str.charAt(this._offset + 4)) != ',' && ch != ']' && ch != '}' && !Character.isWhitespace(ch)) {
                            return this.errorReturn(env, "malformed 'null'");
                        }
                        this._offset += 4;
                        return NullValue.NULL;
                    }
                }
                if (isTop) {
                    return this.decodeString(env, false);
                }
                return this.errorReturn(env, "expected 'null'");
            }
            case '[': {
                return this.decodeArray(env);
            }
            case '{': {
                return this.decodeObject(env);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.decodeNumber(env);
            }
        }
        if (isTop) {
            return this.decodeString(env, false);
        }
        return this.errorReturn(env);
    }

    private Value decodeNumber(Env env) {
        int startOffset = this._offset;
        long value = 0L;
        int sign = 1;
        char ch = this._str.charAt(this._offset);
        if (ch == '-') {
            sign = -1;
            ++this._offset;
        }
        if (this._len <= this._offset) {
            return this.errorReturn(env, "expected 1-9");
        }
        if ((ch = this._str.charAt(this._offset++)) != '0' && '1' <= ch && ch <= '9') {
            value = ch - 48;
            while (this._offset < this._len && '0' <= (ch = this._str.charAt(this._offset)) && ch <= '9') {
                ++this._offset;
                value = 10L * value + (long)ch - 48L;
            }
        }
        boolean isDouble = false;
        if (this._offset < this._len && (ch = this._str.charAt(this._offset)) == '.') {
            ++this._offset;
            isDouble = true;
            while (this._offset < this._len && '0' <= (ch = this._str.charAt(this._offset)) && ch <= '9') {
                ++this._offset;
            }
        }
        if (this._offset < this._len && (ch = this._str.charAt(this._offset)) == 'e' || ch == 'E') {
            ++this._offset;
            isDouble = true;
            if (this._offset < this._len && (ch = this._str.charAt(this._offset)) == '+' || ch == '-') {
                ++this._offset;
            }
            while (this._offset < this._len && '0' <= (ch = this._str.charAt(this._offset)) && ch <= '9') {
                ++this._offset;
            }
        }
        if (isDouble) {
            String strValue = this._str.stringSubstring(startOffset, this._offset);
            return DoubleValue.create(Double.parseDouble(strValue));
        }
        return LongValue.create((long)sign * value);
    }

    private Value decodeArray(Env env) {
        ArrayValueImpl array;
        block4: {
            char ch;
            array = new ArrayValueImpl();
            ++this._offset;
            do {
                this.skipWhitespace();
                if (this._offset >= this._len) {
                    return this.errorReturn(env, "expected either ',' or ']'");
                }
                if (this._str.charAt(this._offset) == ']') {
                    ++this._offset;
                    break block4;
                }
                array.append(this.jsonDecodeImpl(env, false));
                this.skipWhitespace();
                if (this._offset < this._len) continue;
                return this.errorReturn(env, "expected either ',' or ']'");
            } while ((ch = this._str.charAt(this._offset++)) == ',');
            if (ch != ']') {
                return this.errorReturn(env, "expected either ',' or ']'");
            }
        }
        return array;
    }

    private Value decodeObject(Env env) {
        if (this._isAssociative) {
            return this.decodeObjectToArray(env);
        }
        return this.decodeObjectToObject(env);
    }

    private Value decodeObjectToArray(Env env) {
        ArrayValueImpl array;
        block4: {
            char ch;
            array = new ArrayValueImpl();
            ++this._offset;
            do {
                this.skipWhitespace();
                if (this._offset >= this._len || this._str.charAt(this._offset) == '}') {
                    ++this._offset;
                    break block4;
                }
                Value name = this.jsonDecodeImpl(env, false);
                this.skipWhitespace();
                if (this._offset >= this._len || this._str.charAt(this._offset++) != ':') {
                    return this.errorReturn(env, "expected ':'");
                }
                ((ArrayValue)array).append(name, this.jsonDecodeImpl(env, false));
                this.skipWhitespace();
                if (this._offset < this._len) continue;
                return this.errorReturn(env, "expected either ',' or '}'");
            } while ((ch = this._str.charAt(this._offset++)) == ',');
            if (ch != '}') {
                return this.errorReturn(env, "expected either ',' or '}'");
            }
        }
        return array;
    }

    private Value decodeObjectToObject(Env env) {
        ObjectValue object;
        block4: {
            char ch;
            object = env.createObject();
            ++this._offset;
            do {
                this.skipWhitespace();
                if (this._len <= this._offset || this._str.charAt(this._offset) == '}') {
                    ++this._offset;
                    break block4;
                }
                Value name = this.jsonDecodeImpl(env, false);
                this.skipWhitespace();
                if (this._len <= this._offset || this._str.charAt(this._offset++) != ':') {
                    return this.errorReturn(env, "expected ':'");
                }
                object.putField(env, name.toString(), this.jsonDecodeImpl(env, false));
                this.skipWhitespace();
                if (this._offset < this._len) continue;
                return this.errorReturn(env, "expected either ',' or '}'");
            } while ((ch = this._str.charAt(this._offset++)) == ',');
            if (ch != '}') {
                return this.errorReturn(env, "expected either ',' or '}'");
            }
        }
        return object;
    }

    private Value decodeString(Env env, boolean isQuoted) {
        StringValue sb = env.createUnicodeBuilder();
        block15: while (this._offset < this._len) {
            char ch = this._str.charAt(this._offset++);
            switch (ch) {
                case '\\': {
                    if (this._offset >= this._len) {
                        return this.errorReturn(env, "invalid escape character");
                    }
                    ch = this._str.charAt(this._offset++);
                    switch (ch) {
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        case '/': {
                            sb.append('/');
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            int hex = 0;
                            for (int i = 0; this._offset < this._len && i < 4; ++i) {
                                hex <<= 4;
                                if ('0' <= (ch = this._str.charAt(this._offset++)) && ch <= '9') {
                                    hex += ch - 48;
                                    continue;
                                }
                                if (ch >= 'a' && ch <= 'f') {
                                    hex += ch - 97 + 10;
                                    continue;
                                }
                                if (ch >= 'A' && ch <= 'F') {
                                    hex += ch - 65 + 10;
                                    continue;
                                }
                                return this.errorReturn(env, "invalid escaped hex character");
                            }
                            if (hex < 128) {
                                sb.append((char)hex);
                                break;
                            }
                            if (hex < 2048) {
                                sb.append((char)(192 + (hex >> 6)));
                                sb.append((char)(128 + (hex & 0x3F)));
                                break;
                            }
                            sb.append((char)(224 + (hex >> 12)));
                            sb.append((char)(128 + (hex >> 6 & 0x3F)));
                            sb.append((char)(128 + (hex & 0x3F)));
                        }
                    }
                    continue block15;
                }
                case '\"': {
                    return sb;
                }
            }
            sb.append(ch);
        }
        if (isQuoted) {
            return this.errorReturn(env, "error decoding string");
        }
        return sb;
    }

    private Value errorReturn(Env env) {
        return this.errorReturn(env, null);
    }

    private Value errorReturn(Env env, String message) {
        int end = Math.min(this._len, this._offset + 1);
        String token = this._str.substring(this._offset, end).toString();
        if (message != null) {
            env.warning(L.l("error parsing '{0}': {1}", (Object)token, message));
        } else {
            env.warning(L.l("error parsing '{0}'", token));
        }
        return NullValue.NULL;
    }

    private void skipWhitespace() {
        char ch;
        while (this._offset < this._len && ((ch = this._str.charAt(this._offset)) == ' ' || ch == '\n' || ch == '\r' || ch == '\t')) {
            ++this._offset;
        }
    }
}

