/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.reflection.ReflectionClass;
import com.caucho.quercus.lib.reflection.ReflectionFunction;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.ModuleInfo;
import com.caucho.util.L10N;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReflectionExtension
implements Reflector {
    private static final L10N L = new L10N(ReflectionExtension.class);
    private String _name;

    protected ReflectionExtension(Env env, String extension) {
        this._name = extension;
    }

    private final void __clone() {
    }

    public static ReflectionExtension __construct(Env env, String name) {
        return new ReflectionExtension(env, name);
    }

    public static String export(Env env, String name, @Optional boolean isReturn) {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return null;
    }

    public ArrayValue getFunctions(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        for (ModuleInfo moduleInfo : env.getQuercus().getModules()) {
            HashSet<String> extensionSet = moduleInfo.getLoadedExtensions();
            if (!extensionSet.contains(this._name)) continue;
            for (String functionName : moduleInfo.getFunctions().keySet()) {
                AbstractFunction fun = env.findFunction(functionName);
                ((ArrayValue)array).put(env.wrapJava(new ReflectionFunction(fun)));
            }
        }
        return array;
    }

    public ArrayValue getConstants(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        for (ModuleInfo moduleInfo : env.getQuercus().getModules()) {
            HashSet<String> extensionSet = moduleInfo.getLoadedExtensions();
            if (!extensionSet.contains(this._name)) continue;
            for (Map.Entry<StringValue, Value> entry : moduleInfo.getConstMap().entrySet()) {
                array.put(entry.getKey(), entry.getValue());
            }
        }
        return array;
    }

    public ArrayValue getINIEntries(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        for (ModuleInfo moduleInfo : env.getQuercus().getModules()) {
            IniDefinitions iniDefs;
            Set<Map.Entry<String, IniDefinition>> entrySet;
            HashSet<String> extensionSet = moduleInfo.getLoadedExtensions();
            if (!extensionSet.contains(this._name) || (entrySet = (iniDefs = moduleInfo.getIniDefinitions()).entrySet()) == null) continue;
            for (Map.Entry<String, IniDefinition> entry : entrySet) {
                array.put(StringValue.create(entry.getKey()), entry.getValue().getValue(env));
            }
        }
        return array;
    }

    public ArrayValue getClasses(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashSet<String> exts = env.getModuleContext().getExtensionClasses(this._name);
        if (exts != null) {
            for (String name : exts) {
                array.put(StringValue.create(name), env.wrapJava(new ReflectionClass(env, name)));
            }
        }
        return array;
    }

    public ArrayValue getClassNames(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashSet<String> exts = env.getModuleContext().getExtensionClasses(this._name);
        if (exts != null) {
            for (String name : exts) {
                array.put(name);
            }
        }
        return array;
    }

    public String toString() {
        return "ReflectionExtension[" + this._name + "]";
    }
}

