/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.reflection.ReflectionClass;
import com.caucho.quercus.lib.reflection.ReflectionException;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;

public class ReflectionProperty
implements Reflector {
    private static final L10N L = new L10N(ReflectionProperty.class);
    public static final int IS_STATIC = 1;
    public static final int IS_PUBLIC = 256;
    public static final int IS_PROTECTED = 512;
    public static final int IS_PRIVATE = 1024;
    private Property _prop;

    protected ReflectionProperty(Property prop) {
        this._prop = prop;
    }

    protected ReflectionProperty(Env env, QuercusClass cls, StringValue nameV) {
        this._prop = Property.create(env, cls, nameV);
    }

    protected static ReflectionProperty create(Env env, QuercusClass cls, StringValue propName, boolean isStatic) {
        Property prop = isStatic ? new StaticProperty(cls, propName) : new Property(cls, propName);
        return new ReflectionProperty(prop);
    }

    private final void __clone() {
    }

    public static ReflectionProperty __construct(Env env, String clsName, StringValue propName) {
        QuercusClass cls = env.findClass(clsName);
        if (cls == null) {
            throw new ReflectionException(L.l("Cannot find class '{0}'", clsName));
        }
        return new ReflectionProperty(env, cls, propName);
    }

    public static String export(Env env, Value cls, String name, @Optional boolean isReturn) {
        return null;
    }

    public StringValue getName() {
        return this._prop.getName();
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isStatic() {
        return this._prop.isStatic();
    }

    public boolean isDefault() {
        return true;
    }

    public int getModifiers() {
        return -1;
    }

    public Value getValue(Env env, @Optional ObjectValue obj) {
        return this._prop.getValue(env, obj);
    }

    public void setValue(Env env, ObjectValue obj, Value value) {
        this._prop.setValue(env, obj, value);
    }

    public ReflectionClass getDeclaringClass(Env env) {
        return this._prop.getDeclaringClass(env);
    }

    @ReturnNullAsFalse
    public String getDocComment(Env env) {
        return this._prop.getComment(env);
    }

    public String toString() {
        return "ReflectionProperty[" + this._prop.toString() + "]";
    }

    static class StaticProperty
    extends Property {
        private StringValue _name;

        public StaticProperty(QuercusClass cls, StringValue nameV) {
            super(cls, nameV);
            this._name = nameV;
        }

        public boolean isStatic() {
            return true;
        }

        public Value getValue(Env env, ObjectValue obj) {
            return this._cls.getStaticFieldValue(env, this._name);
        }

        public void setValue(Env env, ObjectValue obj, Value value) {
            this._cls.getStaticFieldVar(env, this._name).set(value);
        }

        protected QuercusClass getDeclaringClassImpl(Env env, QuercusClass cls) {
            if (cls == null) {
                return null;
            }
            QuercusClass refClass = this.getDeclaringClassImpl(env, cls.getParent());
            if (refClass != null) {
                return refClass;
            }
            if (cls.getStaticField(env, this._name) != null) {
                return cls;
            }
            return null;
        }

        public String getComment(Env env) {
            QuercusClass cls = this.getDeclaringClass(env, this._cls);
            ClassDef def = cls.getClassDef();
            return def.getStaticFieldComment(this._name.toString());
        }

        public String toString() {
            if (this._cls.getName() != null) {
                return this._cls.getName() + "::" + this._name;
            }
            return this._name.toString();
        }
    }

    static class Property {
        final QuercusClass _cls;
        final StringValue _nameV;
        QuercusClass _declaringClass;

        public static Property create(Env env, QuercusClass cls, StringValue nameV) {
            if (cls.getClassField(nameV) != null) {
                return new Property(cls, nameV);
            }
            if (cls.getStaticFieldValue(env, nameV) != null) {
                return new StaticProperty(cls, nameV);
            }
            throw new ReflectionException(L.l("Property {0}->${1} does not exist", (Object)cls.getName(), nameV));
        }

        protected Property(QuercusClass cls, StringValue nameV) {
            this._cls = cls;
            this._nameV = nameV;
        }

        public boolean isStatic() {
            return false;
        }

        public final StringValue getName() {
            return this._nameV;
        }

        public Value getValue(Env env, ObjectValue obj) {
            return obj.getField(env, this._nameV);
        }

        public void setValue(Env env, ObjectValue obj, Value value) {
            obj.putField(env, this._nameV, value);
        }

        public final ReflectionClass getDeclaringClass(Env env) {
            QuercusClass cls = this.getDeclaringClass(env, this._cls);
            if (cls != null) {
                return new ReflectionClass(cls);
            }
            return null;
        }

        protected final QuercusClass getDeclaringClass(Env env, QuercusClass cls) {
            if (this._declaringClass == null) {
                this._declaringClass = this.getDeclaringClassImpl(env, cls);
            }
            return this._declaringClass;
        }

        protected QuercusClass getDeclaringClassImpl(Env env, QuercusClass cls) {
            if (cls == null) {
                return null;
            }
            QuercusClass refClass = this.getDeclaringClassImpl(env, cls.getParent());
            if (refClass != null) {
                return refClass;
            }
            if (cls.getClassField(this._nameV) != null) {
                return cls;
            }
            return null;
        }

        public String getComment(Env env) {
            QuercusClass cls = this.getDeclaringClass(env, this._cls);
            ClassDef def = cls.getClassDef();
            return def.getFieldComment(this._nameV);
        }

        public String toString() {
            if (this._cls.getName() != null) {
                return this._cls.getName() + "->" + this._nameV;
            }
            return this._nameV.toString();
        }
    }
}

