/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.Hide;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.i18n.MbstringModule;
import com.caucho.quercus.lib.regexp.Ereg;
import com.caucho.quercus.lib.regexp.Eregi;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpState;
import com.caucho.quercus.lib.regexp.UnicodeEreg;
import com.caucho.quercus.lib.regexp.UnicodeEregi;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(RegexpModule.class.getName());
    private static final L10N L = new L10N(RegexpModule.class);
    public static final int PREG_REPLACE_EVAL = 1;
    public static final int PCRE_UTF8 = 2;
    public static final int PREG_PATTERN_ORDER = 1;
    public static final int PREG_SET_ORDER = 2;
    public static final int PREG_OFFSET_CAPTURE = 256;
    public static final int PREG_SPLIT_NO_EMPTY = 1;
    public static final int PREG_SPLIT_DELIM_CAPTURE = 2;
    public static final int PREG_SPLIT_OFFSET_CAPTURE = 4;
    public static final int PREG_GREP_INVERT = 1;
    public static final int PREG_NO_ERROR = 0;
    public static final int PREG_INTERNAL_ERROR = 1;
    public static final int PREG_BACKTRACK_LIMIT_ERROR = 2;
    public static final int PREG_RECURSION_LIMIT_ERROR = 3;
    public static final int PREG_BAD_UTF8_ERROR = 4;
    public static final int PREG_BAD_UTF8_OFFSET_ERROR = 5;
    public static final String PCRE_VERSION = "7.0 18-Dec-2006";
    private static final long LONG_MAX = 0x7FFFFFFFFFFFFFFEL;
    public static final boolean[] PREG_QUOTE = new boolean[256];
    private static LruCache<StringValue, RegexpCacheItem> _regexpCache = new LruCache(1024);
    private static LruCache<StringValue, Ereg> _eregCache = new LruCache(1024);
    private static LruCache<StringValue, Eregi> _eregiCache = new LruCache(1024);
    private static LruCache<UnicodeEregKey, UnicodeEreg> _unicodeEregCache = new LruCache(1024);
    private static LruCache<UnicodeEregKey, UnicodeEregi> _unicodeEregiCache = new LruCache(1024);
    private static LruCache<StringValue, ArrayList<Replacement>> _replacementCache = new LruCache(1024);

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"ereg", "pcre"};
    }

    @Hide
    public static int getRegexpCacheSize() {
        return _regexpCache.getCapacity();
    }

    @Hide
    public static void setRegexpCacheSize(int size) {
        if (size < 0 || size == _regexpCache.getCapacity()) {
            return;
        }
        _regexpCache = new LruCache(size);
        _eregCache = new LruCache(size);
        _eregiCache = new LruCache(size);
        _unicodeEregCache = new LruCache(size);
        _unicodeEregiCache = new LruCache(size);
        _replacementCache = new LruCache(size);
    }

    public static Value ereg(Env env, Ereg regexp, StringValue string, @Optional @Reference Value regsV) {
        if (regexp.getRawRegexp().length() == 0) {
            env.warning(L.l("empty pattern argument"));
            return BooleanValue.FALSE;
        }
        return RegexpModule.eregImpl(env, regexp, string, regsV);
    }

    public static Value eregi(Env env, Eregi regexp, StringValue string, @Optional @Reference Value regsV) {
        if (regexp.getRawRegexp().length() == 0) {
            env.warning(L.l("empty pattern argument"));
            return BooleanValue.FALSE;
        }
        return RegexpModule.eregImpl(env, regexp, string, regsV);
    }

    public static Value eregImpl(Env env, Ereg regexp, StringValue string, Value regsV) {
        if (regexp == null) {
            return BooleanValue.FALSE;
        }
        RegexpState regexpState = RegexpState.create(env, regexp, string);
        if (regexpState.exec(env, string, 0) < 0) {
            RegexpState.free(env, regexpState);
            return BooleanValue.FALSE;
        }
        if (regsV != null && !(regsV instanceof NullValue)) {
            ArrayValueImpl regs = new ArrayValueImpl();
            regsV.set(regs);
            regs.put(LongValue.ZERO, regexpState.group(env));
            int count = regexpState.groupCount();
            for (int i = 1; i < count; ++i) {
                StringValue group = regexpState.group(env, i);
                Value value = group == null || group.length() == 0 ? BooleanValue.FALSE : group;
                regs.put(LongValue.create(i), value);
            }
            int len = regexpState.end() - regexpState.start();
            RegexpState.free(env, regexpState);
            if (len == 0) {
                return LongValue.ONE;
            }
            return LongValue.create(len);
        }
        RegexpState.free(env, regexpState);
        return LongValue.ONE;
    }

    public static Regexp compileRegexp(StringValue regexpValue) {
        try {
            return RegexpModule.createRegexp(regexpValue);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public static Regexp createRegexp(StringValue regexpValue) {
        try {
            return RegexpModule.createRegexpImpl(regexpValue);
        }
        catch (IllegalRegexpException e) {
            throw new QuercusException(e);
        }
    }

    public static Regexp createRegexp(Env env, StringValue regexpValue) {
        try {
            return RegexpModule.createRegexpImpl(regexpValue);
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    private static Regexp createRegexpImpl(StringValue regexpValue) throws IllegalRegexpException {
        if (regexpValue.length() < 2) {
            throw new QuercusException(L.l("Regexp pattern must have opening and closing delimiters"));
        }
        RegexpCacheItem cacheItem = _regexpCache.get(regexpValue);
        if (cacheItem == null) {
            cacheItem = new RegexpCacheItem(regexpValue);
            _regexpCache.putIfNew(regexpValue, cacheItem);
            cacheItem = _regexpCache.get(regexpValue);
        }
        return cacheItem.get();
    }

    public static Regexp[] createRegexpArray(Value pattern) {
        if (pattern.isArray()) {
            ArrayValue array = (ArrayValue)pattern;
            Regexp[] regexpArray = new Regexp[array.getSize()];
            int i = 0;
            for (Value value : array.values()) {
                Regexp regexp = RegexpModule.createRegexp(value.toStringValue());
                regexpArray[i++] = regexp;
            }
            return regexpArray;
        }
        Regexp regexp = RegexpModule.createRegexp(pattern.toStringValue());
        return new Regexp[]{regexp};
    }

    public static Regexp[] createRegexpArray(Env env, Value pattern) {
        try {
            if (pattern.isArray()) {
                ArrayValue array = pattern.toArrayValue(env);
                Regexp[] regexpArray = new Regexp[array.getSize()];
                int i = 0;
                for (Value value : array.values()) {
                    Regexp regexp = RegexpModule.createRegexp(env, value.toStringValue(env));
                    regexpArray[i++] = regexp;
                }
                return regexpArray;
            }
            Regexp regexp = RegexpModule.createRegexp(env, pattern.toStringValue(env));
            return new Regexp[]{regexp};
        }
        catch (Exception e) {
            env.warning(e);
            return null;
        }
    }

    public static Ereg createEreg(Env env, Value value) {
        try {
            StringValue regexpStr = value.isNull() || value.isBoolean() ? env.getEmptyString() : (!value.isString() ? value.toLongValue().toStringValue() : value.toStringValue());
            Ereg ereg = _eregCache.get(regexpStr);
            if (ereg == null) {
                StringValue cleanPattern = RegexpModule.cleanEregRegexp(regexpStr, false);
                ereg = new Ereg(cleanPattern);
                _eregCache.put(regexpStr, ereg);
            }
            return ereg;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    public static Ereg createEreg(Value value) {
        try {
            StringValue regexpStr = value.isNull() || value.isBoolean() ? StringValue.EMPTY : (!value.isString() ? value.toLongValue().toStringValue() : value.toStringValue());
            Ereg ereg = _eregCache.get(regexpStr);
            if (ereg == null) {
                StringValue cleanPattern = RegexpModule.cleanEregRegexp(regexpStr, false);
                ereg = new Ereg(cleanPattern);
                _eregCache.put(regexpStr, ereg);
            }
            return ereg;
        }
        catch (IllegalRegexpException e) {
            throw new QuercusException(e);
        }
    }

    public static Eregi createEregi(Env env, Value value) {
        try {
            StringValue regexpStr = value.isNull() || value.isBoolean() ? env.getEmptyString() : (!value.isString() ? value.toLongValue().toStringValue() : value.toStringValue());
            Eregi eregi = _eregiCache.get(regexpStr);
            if (eregi == null) {
                StringValue cleanPattern = RegexpModule.cleanEregRegexp(regexpStr, false);
                eregi = new Eregi(cleanPattern);
                _eregiCache.put(regexpStr, eregi);
            }
            return eregi;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    public static Eregi createEregi(Value value) {
        try {
            StringValue regexpStr = value.isNull() || value.isBoolean() ? StringValue.EMPTY : (!value.isString() ? value.toLongValue().toStringValue() : value.toStringValue());
            Eregi eregi = _eregiCache.get(regexpStr);
            if (eregi == null) {
                StringValue cleanPattern = RegexpModule.cleanEregRegexp(regexpStr, false);
                eregi = new Eregi(cleanPattern);
                _eregiCache.put(regexpStr, eregi);
            }
            return eregi;
        }
        catch (IllegalRegexpException e) {
            throw new QuercusException(e);
        }
    }

    public static UnicodeEreg createUnicodeEreg(Env env, StringValue pattern) {
        return RegexpModule.createUnicodeEreg(env, pattern, MbstringModule.getEncoding(env));
    }

    public static UnicodeEreg createUnicodeEreg(Env env, StringValue pattern, String encoding) {
        try {
            UnicodeEregKey key = new UnicodeEregKey(pattern, encoding);
            UnicodeEreg ereg = _unicodeEregCache.get(key);
            if (ereg == null) {
                pattern = pattern.convertToUnicode(env, encoding);
                StringValue cleanPattern = RegexpModule.cleanEregRegexp(pattern, false);
                ereg = new UnicodeEreg(cleanPattern);
                _unicodeEregCache.put(key, ereg);
            }
            return ereg;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    public static UnicodeEregi createUnicodeEregi(Env env, StringValue pattern) {
        return RegexpModule.createUnicodeEregi(env, pattern, MbstringModule.getEncoding(env));
    }

    public static UnicodeEregi createUnicodeEregi(Env env, StringValue pattern, String encoding) {
        try {
            UnicodeEregKey key = new UnicodeEregKey(pattern, encoding);
            UnicodeEregi ereg = _unicodeEregiCache.get(key);
            if (ereg == null) {
                pattern = pattern.convertToUnicode(env, encoding);
                StringValue cleanPattern = RegexpModule.cleanEregRegexp(pattern, false);
                ereg = new UnicodeEregi(cleanPattern);
                _unicodeEregiCache.put(key, ereg);
            }
            return ereg;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return null;
        }
    }

    public static Value preg_last_error(Env env) {
        return LongValue.ZERO;
    }

    public static Value preg_match(Env env, Regexp regexp, StringValue subject, @Optional @Reference Value matchRef, @Optional int flags, @Optional int offset) {
        boolean isOffsetCapture;
        if (regexp == null) {
            return BooleanValue.FALSE;
        }
        StringValue empty = StringValue.EMPTY;
        RegexpState regexpState = RegexpState.create(env, regexp, subject);
        ArrayValueImpl regs = matchRef.isDefault() ? null : new ArrayValueImpl();
        if (regexpState == null || regexpState.exec(env, subject, offset) < 0) {
            if (regs != null) {
                matchRef.set(regs);
            }
            env.freeRegexpState(regexpState);
            return LongValue.ZERO;
        }
        boolean bl = isOffsetCapture = (flags & 0x100) != 0;
        if (regs != null) {
            if (isOffsetCapture) {
                ArrayValueImpl part = new ArrayValueImpl();
                part.append(regexpState.group(env));
                part.append(LongValue.create(regexpState.start()));
                regs.put(LongValue.ZERO, part);
            } else {
                regs.put(LongValue.ZERO, regexpState.group(env));
            }
            int count = regexpState.groupCount();
            for (int i = 1; i < count; ++i) {
                if (!regexpState.isMatchedGroup(i)) continue;
                StringValue group = regexpState.group(env, i);
                if (isOffsetCapture) {
                    for (int j = ((ArrayValue)regs).getSize(); j < i; ++j) {
                        ArrayValueImpl part = new ArrayValueImpl();
                        part.append(empty);
                        part.append(LongValue.MINUS_ONE);
                        regs.put(LongValue.create(j), part);
                    }
                    ArrayValueImpl part = new ArrayValueImpl();
                    part.append(group);
                    part.append(LongValue.create(regexpState.start(i)));
                    StringValue name = regexpState.getGroupName(i);
                    if (name != null) {
                        regs.put(name, part);
                    }
                    regs.put(LongValue.create(i), part);
                    continue;
                }
                for (int j = ((ArrayValue)regs).getSize(); j < i; ++j) {
                    regs.put(LongValue.create(j), empty);
                }
                StringValue name = regexp.getGroupName(i);
                if (name != null) {
                    regs.put(name, group);
                }
                regs.put(LongValue.create(i), group);
            }
            matchRef.set(regs);
        }
        env.freeRegexpState(regexpState);
        return LongValue.ONE;
    }

    public static Value preg_match_all(Env env, Regexp regexp, StringValue subject, @Reference Value matchRef, @Optional(value="PREG_PATTERN_ORDER") int flags, @Optional int offset) {
        if (regexp == null) {
            return BooleanValue.FALSE;
        }
        if (offset < 0) {
            offset = subject.length() + offset;
        }
        if ((flags & 1) == 0) {
            if ((flags & 2) == 0) {
                flags |= 1;
            }
        } else if ((flags & 2) != 0) {
            env.warning(L.l("Cannot combine PREG_PATTER_ORDER and PREG_SET_ORDER"));
            return BooleanValue.FALSE;
        }
        RegexpState regexpState = RegexpState.create(env, regexp, subject);
        if (offset > 0) {
            regexpState.setFirst(offset);
        }
        ArrayValue matches = matchRef instanceof ArrayValue ? (ArrayValue)matchRef : new ArrayValueImpl();
        matches.clear();
        matchRef.set(matches);
        LongValue result = null;
        if ((flags & 1) != 0) {
            result = RegexpModule.pregMatchAllPatternOrder(env, regexpState, subject, matches, flags, offset);
        } else if ((flags & 2) != 0) {
            result = RegexpModule.pregMatchAllSetOrder(env, regexp, regexpState, subject, matches, flags, offset);
        } else {
            throw new UnsupportedOperationException();
        }
        env.freeRegexpState(regexpState);
        return result;
    }

    public static LongValue pregMatchAllPatternOrder(Env env, RegexpState regexpState, StringValue subject, ArrayValue matches, int flags, int offset) {
        int groupCount = regexpState == null ? 0 : regexpState.groupCount();
        ArrayValue[] matchList = new ArrayValue[groupCount + 1];
        StringValue emptyStr = StringValue.EMPTY;
        for (int j = 0; j < groupCount; ++j) {
            ArrayValueImpl values = new ArrayValueImpl();
            StringValue patternName = regexpState.getGroupName(j);
            if (patternName != null) {
                matches.put(patternName, values);
            }
            matches.put(values);
            matchList[j] = values;
        }
        int count = 0;
        while (regexpState.find()) {
            ++count;
            for (int j = 0; j < groupCount; ++j) {
                ArrayValue values = matchList[j];
                if (!regexpState.isMatchedGroup(j)) {
                    values.put(emptyStr);
                    continue;
                }
                StringValue groupValue = regexpState.group(env, j);
                Value result = NullValue.NULL;
                if (groupValue != null) {
                    if ((flags & 0x100) != 0) {
                        result = new ArrayValueImpl();
                        result.put(groupValue);
                        result.put(LongValue.create(regexpState.getBegin(j)));
                    } else {
                        result = groupValue;
                    }
                }
                values.put(result);
            }
        }
        return LongValue.create(count);
    }

    private static LongValue pregMatchAllSetOrder(Env env, Regexp regexp, RegexpState regexpState, StringValue subject, ArrayValue matches, int flags, int offset) {
        if (regexpState == null || !regexpState.find()) {
            return LongValue.ZERO;
        }
        StringValue empty = StringValue.EMPTY;
        int count = 0;
        do {
            ++count;
            ArrayValueImpl matchResult = new ArrayValueImpl();
            matches.put(matchResult);
            int groupCount = regexpState.groupCount();
            for (int i = 0; i < groupCount; ++i) {
                int start = regexpState.start(i);
                int end = regexpState.end(i);
                if (start < 0 || end < start || end == start && i == groupCount - 1) continue;
                StringValue groupValue = regexpState.group(env, i);
                Value result = NullValue.NULL;
                if (groupValue != null) {
                    int j;
                    StringValue patternName = regexpState.getGroupName(i);
                    if (patternName != null) {
                        matchResult.put(patternName, groupValue);
                    }
                    if ((flags & 0x100) != 0) {
                        for (j = ((ArrayValue)matchResult).getSize(); j < i; ++j) {
                            ArrayValueImpl part = new ArrayValueImpl();
                            part.append(empty);
                            part.append(LongValue.MINUS_ONE);
                            matchResult.put(LongValue.create(j), part);
                        }
                        result = new ArrayValueImpl();
                        result.put(groupValue);
                        result.put(LongValue.create(start));
                    } else {
                        for (j = ((ArrayValue)matchResult).getSize(); j < i; ++j) {
                            matchResult.put(LongValue.create(j), empty);
                        }
                        result = groupValue;
                    }
                }
                ((ArrayValue)matchResult).put(result);
            }
        } while (regexpState.find());
        return LongValue.create(count);
    }

    public static StringValue preg_quote(StringValue string, @Optional StringValue delim) {
        StringValue sb = string.createStringBuilder();
        boolean[] extra = null;
        if (delim != null && delim.length() > 0) {
            extra = new boolean[256];
            for (int i = 0; i < delim.length(); ++i) {
                extra[delim.charAt((int)i)] = true;
            }
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch >= '\u0100') {
                sb.append(ch);
                continue;
            }
            if (PREG_QUOTE[ch]) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            if (extra != null && extra[ch]) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            if (ch == '\u0000') {
                sb.append("\\000");
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    @UsesSymbolTable
    public static Value preg_replace(Env env, Regexp regexp, Value replacement, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (regexp == null) {
            return BooleanValue.FALSE;
        }
        if (count != null) {
            count.set(LongValue.ZERO);
        }
        try {
            if (subject instanceof ArrayValue) {
                ArrayValueImpl result = new ArrayValueImpl();
                for (Map.Entry<Value, Value> entry : ((ArrayValue)subject).entrySet()) {
                    Value key = entry.getKey();
                    Value value = entry.getValue();
                    result.put(key, RegexpModule.pregReplace(env, regexp, replacement, value.toStringValue(), limit, count));
                }
                return result;
            }
            if (subject.isset()) {
                return RegexpModule.pregReplace(env, regexp, replacement, subject.toStringValue(), limit, count);
            }
            return env.getEmptyString();
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    private static Value pregReplace(Env env, Regexp regexp, Value replacement, StringValue subject, @Optional(value="-1") long limit, Value countV) throws IllegalRegexpException {
        StringValue string = subject;
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        if (replacement.isArray()) {
            ArrayValue replacementArray = (ArrayValue)replacement;
            Iterator<Value> replacementIter = replacementArray.values().iterator();
            StringValue replacementStr = replacementIter.hasNext() ? replacementIter.next().toStringValue() : env.getEmptyString();
            string = RegexpModule.pregReplaceString(env, regexp, replacementStr, string, limit, countV);
        } else {
            string = RegexpModule.pregReplaceString(env, regexp, replacement.toStringValue(), string, limit, countV);
        }
        if (string != null) {
            return string;
        }
        return NullValue.NULL;
    }

    @UsesSymbolTable
    public static Value preg_replace(Env env, Value pattern, Value replacement, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        try {
            Regexp[] regexpList = RegexpModule.createRegexpArray(env, pattern);
            if (regexpList == null) {
                return NullValue.NULL;
            }
            if (subject instanceof ArrayValue) {
                ArrayValueImpl result = new ArrayValueImpl();
                for (Value value : ((ArrayValue)subject).values()) {
                    ((ArrayValue)result).put(RegexpModule.pregReplace(env, regexpList, replacement, value.toStringValue(), limit, count));
                }
                return result;
            }
            if (subject.isset()) {
                return RegexpModule.pregReplace(env, regexpList, replacement, subject.toStringValue(), limit, count);
            }
            return env.getEmptyString();
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    private static Value pregReplace(Env env, Regexp[] regexpList, Value replacement, StringValue subject, @Optional(value="-1") long limit, Value countV) throws IllegalRegexpException {
        StringValue string = subject;
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        if (replacement.isArray()) {
            ArrayValue replacementArray = (ArrayValue)replacement;
            Iterator<Value> replacementIter = replacementArray.values().iterator();
            for (int i = 0; i < regexpList.length; ++i) {
                StringValue replacementStr = replacementIter.hasNext() ? replacementIter.next().toStringValue() : env.getEmptyString();
                string = RegexpModule.pregReplaceString(env, regexpList[i], replacementStr, string, limit, countV);
            }
        } else {
            for (int i = 0; i < regexpList.length; ++i) {
                string = RegexpModule.pregReplaceString(env, regexpList[i], replacement.toStringValue(), string, limit, countV);
            }
        }
        if (string != null) {
            return string;
        }
        return NullValue.NULL;
    }

    private static StringValue pregReplaceCallbackImpl(Env env, Regexp regexp, Callable fun, StringValue subject, long limit, Value countV) throws IllegalRegexpException {
        StringValue empty = StringValue.EMPTY;
        long numberOfMatches = 0L;
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        RegexpState regexpState = RegexpState.create(env, regexp);
        regexpState.setSubject(env, subject);
        StringValue result = subject.createStringBuilder();
        int tail = 0;
        while (regexpState.find() && numberOfMatches < limit) {
            int start;
            if (countV != null && countV instanceof Var) {
                long count = countV.toValue().toLong();
                countV.set(LongValue.create(count + 1L));
            }
            if (tail < (start = regexpState.start())) {
                result = result.append(regexpState.substring(env, tail, start));
            }
            ArrayValueImpl regs = new ArrayValueImpl();
            for (int i = 0; i < regexpState.groupCount(); ++i) {
                StringValue group = regexpState.group(env, i);
                if (group != null) {
                    ((ArrayValue)regs).put(group);
                    continue;
                }
                ((ArrayValue)regs).put(empty);
            }
            Value replacement = fun.call(env, regs);
            result = result.append(replacement);
            tail = regexpState.end();
            ++numberOfMatches;
        }
        if (tail < regexpState.getSubjectLength()) {
            result = result.append(regexpState.substring(env, tail));
        }
        env.freeRegexpState(regexpState);
        return result;
    }

    static StringValue pregReplaceString(Env env, Regexp regexp, StringValue replacement, StringValue subject, long limit, Value countV) {
        RegexpState regexpState = RegexpState.create(env, regexp);
        if (!regexpState.setSubject(env, subject)) {
            return null;
        }
        boolean isEval = regexp.isEval();
        ArrayList<Replacement> replacementProgram = _replacementCache.get(replacement);
        if (replacementProgram == null) {
            replacementProgram = RegexpModule.compileReplacement(env, replacement, isEval);
            if (replacementProgram == null) {
                return null;
            }
            _replacementCache.put(replacement, replacementProgram);
        }
        StringValue result = RegexpModule.pregReplaceStringImpl(env, regexp, regexpState, replacementProgram, subject, limit, countV, isEval);
        env.freeRegexpState(regexpState);
        return result;
    }

    public static Value ereg_replace(Env env, Value regexpValue, Value replacement, StringValue subject) {
        StringValue regexpStr = regexpValue.isLong() ? env.createString((char)regexpValue.toInt()) : regexpValue.toStringValue(env);
        if (regexpStr.length() == 0) {
            env.warning(L.l("empty pattern argument"));
            return BooleanValue.FALSE;
        }
        Ereg regexp = RegexpModule.createEreg(env, regexpStr);
        return RegexpModule.eregReplaceImpl(env, regexp, replacement, subject, false);
    }

    public static Value eregi_replace(Env env, Value regexpValue, Value replacement, StringValue subject) {
        StringValue regexpStr = regexpValue.isLong() ? env.createString((char)regexpValue.toInt()) : regexpValue.toStringValue(env);
        if (regexpStr.length() == 0) {
            env.warning(L.l("empty pattern argument"));
            return BooleanValue.FALSE;
        }
        Eregi regexp = RegexpModule.createEregi(env, regexpStr);
        return RegexpModule.eregReplaceImpl(env, regexp, replacement, subject, true);
    }

    public static Value eregReplaceImpl(Env env, Ereg regexp, Value replacement, StringValue subject, boolean isCaseInsensitive) {
        StringValue replacementStr = replacement instanceof NullValue ? env.getEmptyString() : (replacement instanceof StringValue ? replacement.toStringValue() : env.createString(String.valueOf((char)replacement.toLong())));
        RegexpState regexpState = RegexpState.create(env, regexp);
        regexpState.setSubject(env, subject);
        ArrayList<Replacement> replacementProgram = _replacementCache.get(replacementStr);
        if (replacementProgram == null) {
            replacementProgram = RegexpModule.compileReplacement(env, replacementStr, false);
            if (replacementProgram == null) {
                return null;
            }
            _replacementCache.put(replacementStr, replacementProgram);
        }
        StringValue result = RegexpModule.pregReplaceStringImpl(env, regexp, regexpState, replacementProgram, subject, -1L, NullValue.NULL, false);
        env.freeRegexpState(regexpState);
        return result;
    }

    private static StringValue pregReplaceStringImpl(Env env, Regexp regexp, RegexpState regexpState, ArrayList<Replacement> replacementProgram, StringValue subject, long limit, Value countV, boolean isEval) {
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        StringValue result = subject.createStringBuilder();
        int tail = 0;
        boolean isMatched = false;
        int replacementLen = replacementProgram.size();
        while (limit-- > 0L && regexpState.find()) {
            int start;
            isMatched = true;
            if (countV != null && countV instanceof Var) {
                countV.set(LongValue.create(countV.toLong() + 1L));
            }
            if (tail < (start = regexpState.start())) {
                result = result.append(regexpState.substring(env, tail, start));
            }
            if (isEval) {
                StringValue evalString = subject.createStringBuilder();
                try {
                    for (int i = 0; i < replacementLen; ++i) {
                        Replacement replacement = replacementProgram.get(i);
                        evalString = replacement.eval(env, evalString, regexpState);
                    }
                }
                catch (Exception e) {
                    env.warning(e);
                }
                try {
                    if (evalString.length() > 0) {
                        result = result.append(env.evalCode(evalString.toString()));
                    }
                }
                catch (Exception e) {
                    env.warning(e);
                }
            } else {
                for (int i = 0; i < replacementLen; ++i) {
                    Replacement replacement = replacementProgram.get(i);
                    result = replacement.eval(env, result, regexpState);
                }
            }
            tail = regexpState.end();
        }
        if (!isMatched) {
            return subject;
        }
        if (tail < regexpState.getSubjectLength()) {
            result = result.append(regexpState.substring(env, tail));
        }
        return result;
    }

    public static Value preg_replace_callback(Env env, Regexp regexp, @NotNull Callable fun, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (fun == null) {
            env.warning(L.l("callable argument can't be null in preg_replace_callback"));
            return subject;
        }
        if (regexp == null) {
            return NullValue.NULL;
        }
        if (regexp.isEval()) {
            env.warning(L.l("regexp can't use /e preg_replace_callback /{0}/", regexp.getPattern()));
            return NullValue.NULL;
        }
        if (count != null) {
            count.set(LongValue.ZERO);
        }
        try {
            if (subject instanceof ArrayValue) {
                ArrayValueImpl result = new ArrayValueImpl();
                for (Value value : ((ArrayValue)subject).values()) {
                    ((ArrayValue)result).put(RegexpModule.pregReplaceCallback(env, regexp, fun, value.toStringValue(), limit, count));
                }
                return result;
            }
            if (subject.isset()) {
                return RegexpModule.pregReplaceCallback(env, regexp, fun, subject.toStringValue(), limit, count);
            }
            return env.getEmptyString();
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value preg_replace_callback(Env env, Value regexpValue, Callable fun, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (!regexpValue.isArray()) {
            Regexp regexp = RegexpModule.createRegexp(env, regexpValue.toStringValue());
            return RegexpModule.preg_replace_callback(env, regexp, fun, subject, limit, count);
        }
        Regexp[] regexpList = RegexpModule.createRegexpArray(env, regexpValue);
        if (regexpList == null) {
            return NullValue.NULL;
        }
        try {
            if (subject instanceof ArrayValue) {
                ArrayValueImpl result = new ArrayValueImpl();
                for (Value value : ((ArrayValue)subject).values()) {
                    ((ArrayValue)result).put(RegexpModule.pregReplaceCallback(env, regexpList, fun, value.toStringValue(), limit, count));
                }
                return result;
            }
            if (subject.isset()) {
                return RegexpModule.pregReplaceCallback(env, regexpList, fun, subject.toStringValue(), limit, count);
            }
            return env.getEmptyString();
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    private static Value pregReplaceCallback(Env env, Regexp regexp, Callable fun, StringValue subject, @Optional(value="-1") long limit, @Optional @Reference Value countV) throws IllegalRegexpException {
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        if (!subject.isset()) {
            return env.getEmptyString();
        }
        return RegexpModule.pregReplaceCallbackImpl(env, regexp, fun, subject, limit, countV);
    }

    private static Value pregReplaceCallback(Env env, Regexp[] regexpList, Callable fun, StringValue subject, @Optional(value="-1") long limit, @Optional @Reference Value countV) throws IllegalRegexpException {
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        if (!subject.isset()) {
            return env.getEmptyString();
        }
        for (int i = 0; i < regexpList.length; ++i) {
            subject = RegexpModule.pregReplaceCallbackImpl(env, regexpList[i], fun, subject, limit, countV);
        }
        return subject;
    }

    public static Value preg_split(Env env, Regexp regexp, StringValue string, @Optional(value="-1") long limit, @Optional int flags) {
        if (regexp == null) {
            return BooleanValue.FALSE;
        }
        if (limit <= 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        StringValue empty = StringValue.EMPTY;
        RegexpState regexpState = RegexpState.create(env, regexp);
        regexpState.setSubject(env, string);
        ArrayValueImpl result = new ArrayValueImpl();
        int head = 0;
        long count = 0L;
        boolean allowEmpty = (flags & 1) == 0;
        boolean isCaptureOffset = (flags & 4) != 0;
        boolean isCaptureDelim = (flags & 2) != 0;
        GroupNeighborMap neighborMap = new GroupNeighborMap(regexp.getPattern(), regexpState.groupCount());
        while (regexpState.find()) {
            StringValue unmatched;
            int startPosition = head;
            if (count == limit - 1L) {
                unmatched = regexpState.substring(env, head);
                head = regexpState.getSubjectLength();
            } else {
                unmatched = regexpState.substring(env, head, regexpState.start());
                head = regexpState.end();
            }
            if (unmatched.length() != 0 || allowEmpty) {
                if (isCaptureOffset) {
                    ArrayValueImpl part = new ArrayValueImpl();
                    ((ArrayValue)part).put(unmatched);
                    ((ArrayValue)part).put(LongValue.create(startPosition));
                    ((ArrayValue)result).put(part);
                } else {
                    ((ArrayValue)result).put(unmatched);
                }
                ++count;
            }
            if (count == limit) break;
            if (!isCaptureDelim) continue;
            for (int i = 1; i < regexpState.groupCount(); ++i) {
                ArrayValueImpl part;
                int start = regexpState.start(i);
                int end = regexpState.end(i);
                if (!regexpState.isMatchedGroup(i)) continue;
                if (allowEmpty) {
                    int group = i;
                    while (neighborMap.hasNeighbor(group) && !regexpState.isMatchedGroup(group = neighborMap.getNeighbor(group))) {
                        if (isCaptureOffset) {
                            part = new ArrayValueImpl();
                            ((ArrayValue)part).put(empty);
                            ((ArrayValue)part).put(LongValue.create(startPosition));
                            ((ArrayValue)result).put(part);
                            continue;
                        }
                        ((ArrayValue)result).put(empty);
                    }
                }
                if (end - start <= 0 && !allowEmpty) continue;
                StringValue groupValue = regexpState.group(env, i);
                if (isCaptureOffset) {
                    part = new ArrayValueImpl();
                    ((ArrayValue)part).put(groupValue);
                    ((ArrayValue)part).put(LongValue.create(start));
                    ((ArrayValue)result).put(part);
                    continue;
                }
                ((ArrayValue)result).put(groupValue);
            }
        }
        if (count < limit && (head < regexpState.getSubjectLength() || allowEmpty)) {
            if (isCaptureOffset) {
                ArrayValueImpl part = new ArrayValueImpl();
                ((ArrayValue)part).put(regexpState.substring(env, head));
                ((ArrayValue)part).put(LongValue.create(head));
                ((ArrayValue)result).put(part);
            } else {
                ((ArrayValue)result).put(regexpState.substring(env, head));
            }
        }
        env.freeRegexpState(regexpState);
        return result;
    }

    public static StringValue sql_regcase(StringValue string) {
        StringValue sb = string.createStringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (Character.isLowerCase(ch)) {
                sb.append('[');
                sb.append(Character.toUpperCase(ch));
                sb.append(ch);
                sb.append(']');
                continue;
            }
            if (Character.isUpperCase(ch)) {
                sb.append('[');
                sb.append(ch);
                sb.append(Character.toLowerCase(ch));
                sb.append(']');
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    public static Value split(Env env, Ereg regexp, StringValue string, @Optional(value="-1") long limit) {
        return RegexpModule.splitImpl(env, regexp, string, limit);
    }

    public static Value spliti(Env env, Eregi regexp, StringValue string, @Optional(value="-1") long limit) {
        return RegexpModule.splitImpl(env, regexp, string, limit);
    }

    private static Value splitImpl(Env env, Ereg regexp, StringValue string, long limit) {
        long count;
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFEL;
        }
        RegexpState regexpState = RegexpState.create(env, regexp);
        regexpState.setSubject(env, string);
        ArrayValueImpl result = new ArrayValueImpl();
        int head = 0;
        for (count = 0L; regexpState.find() && count < limit; ++count) {
            StringValue value;
            if (count == limit - 1L) {
                value = regexpState.substring(env, head);
                head = string.length();
            } else {
                value = regexpState.substring(env, head, regexpState.start());
                head = regexpState.end();
            }
            ((ArrayValue)result).put(value);
        }
        if (head <= string.length() && count != limit) {
            ((ArrayValue)result).put(regexpState.substring(env, head));
        }
        env.freeRegexpState(regexpState);
        return result;
    }

    public static Value preg_grep(Env env, Regexp regexp, ArrayValue input, @Optional(value="0") int flag) {
        if (input == null) {
            return NullValue.NULL;
        }
        if (regexp == null) {
            return BooleanValue.FALSE;
        }
        RegexpState regexpState = RegexpState.create(env, regexp);
        ArrayValueImpl matchArray = new ArrayValueImpl();
        for (ArrayValue.Entry entry = input.getHead(); entry != null; entry = entry.getNext()) {
            Value entryValue = entry.getRawValue();
            Value entryKey = entry.getKey();
            boolean found = regexpState.find(env, entryValue.toStringValue());
            if (!found && flag == 1) {
                ((ArrayValue)matchArray).append(entryKey, entryValue);
                continue;
            }
            if (!found || flag == 1) continue;
            ((ArrayValue)matchArray).append(entryKey, entryValue);
        }
        env.freeRegexpState(regexpState);
        return matchArray;
    }

    private static StringValue addDelimiters(Env env, StringValue str, String startDelim, String endDelim) {
        StringValue sb = str.createStringBuilder();
        sb = sb.appendBytes(startDelim);
        sb = sb.append(str);
        sb = sb.appendBytes(endDelim);
        return sb;
    }

    private static ArrayList<Replacement> compileReplacement(Env env, StringValue replacement, boolean isEval) {
        ArrayList<Replacement> program = new ArrayList<Replacement>();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < replacement.length(); ++i) {
            char ch = replacement.charAt(i);
            if ((ch == '\\' || ch == '$') && i + 1 < replacement.length()) {
                int group;
                char digit = replacement.charAt(i + 1);
                if ('0' <= digit && digit <= '9') {
                    group = digit - 48;
                    if (++i + 1 < replacement.length() && '0' <= (digit = replacement.charAt(i + 1)) && digit <= '9') {
                        group = 10 * group + digit - 48;
                        ++i;
                    }
                    if (text.length() > 0) {
                        program.add(new TextReplacement(text));
                    }
                    if (isEval) {
                        program.add(new GroupEscapeReplacement(group));
                    } else {
                        program.add(new GroupReplacement(group));
                    }
                    text.setLength(0);
                    continue;
                }
                if (ch == '\\') {
                    ++i;
                    if (digit != '\\') {
                        text.append('\\');
                    }
                    text.append(digit);
                    continue;
                }
                if (digit == '{') {
                    i += 2;
                    group = 0;
                    while (i < replacement.length() && '0' <= (digit = replacement.charAt(i)) && digit <= '9') {
                        group = 10 * group + digit - 48;
                        ++i;
                    }
                    if (digit != '}') {
                        text.append("${");
                        text.append(group);
                        continue;
                    }
                    if (text.length() > 0) {
                        program.add(new TextReplacement(text));
                    }
                    if (isEval) {
                        program.add(new GroupEscapeReplacement(group));
                    } else {
                        program.add(new GroupReplacement(group));
                    }
                    text.setLength(0);
                    continue;
                }
                text.append(ch);
                continue;
            }
            text.append(ch);
        }
        if (text.length() > 0) {
            program.add(new TextReplacement(text));
        }
        return program;
    }

    private static StringValue cleanEregRegexp(StringValue regexp, boolean isComments) {
        int len = regexp.length();
        StringValue sb = regexp.createStringBuilder();
        int quote = 0;
        block12: for (int i = 0; i < len; ++i) {
            char ch = regexp.charAt(i);
            switch (ch) {
                case '\\': {
                    if (quote == 91) {
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(92);
                        continue block12;
                    }
                    if (i + 1 < len) {
                        if ((ch = regexp.charAt(++i)) == '0' || '1' <= ch && ch <= '3' && i + 1 < len && '0' <= regexp.charAt(i + 1) && ch <= '7') {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(48);
                            sb = sb.appendByte(ch);
                            continue block12;
                        }
                        if (ch == 'x' && i + 1 < len && regexp.charAt(i + 1) == '{') {
                            sb = sb.appendByte(92);
                            int tail = regexp.indexOf('}', i + 1);
                            if (tail > 0) {
                                StringValue hex = regexp.substring(i + 2, tail);
                                int length = hex.length();
                                if (length == 1) {
                                    sb = sb.appendBytes("x0" + hex);
                                } else if (length == 2) {
                                    sb = sb.appendBytes("x" + hex);
                                } else if (length == 3) {
                                    sb = sb.appendBytes("u0" + hex);
                                } else if (length == 4) {
                                    sb = sb.appendBytes("u" + hex);
                                } else {
                                    throw new QuercusRuntimeException(L.l("illegal hex escape"));
                                }
                                i = tail;
                                continue block12;
                            }
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(120);
                            continue block12;
                        }
                        if (Character.isLetter(ch)) {
                            switch (ch) {
                                case 'A': 
                                case 'B': 
                                case 'D': 
                                case 'G': 
                                case 'P': 
                                case 'S': 
                                case 'W': 
                                case 'X': 
                                case 'Z': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': 
                                case 'n': 
                                case 'p': 
                                case 'r': 
                                case 's': 
                                case 't': 
                                case 'w': 
                                case 'x': 
                                case 'z': {
                                    sb = sb.appendByte(92);
                                    sb = sb.appendByte(ch);
                                    continue block12;
                                }
                            }
                            sb = sb.appendByte(ch);
                            continue block12;
                        }
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(ch);
                        continue block12;
                    }
                    sb = sb.appendByte(92);
                    continue block12;
                }
                case '[': {
                    if (quote == 91) {
                        if (i + 1 < len && regexp.charAt(i + 1) == ':') {
                            sb = sb.appendByte(91);
                        } else {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(91);
                        }
                    } else if (i + 1 < len && regexp.charAt(i + 1) == '[' && (i + 2 >= len || regexp.charAt(i + 2) != ':')) {
                        sb = sb.appendByte(91);
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(91);
                        ++i;
                    } else {
                        sb = sb.appendByte(91);
                    }
                    if (quote != 0) continue block12;
                    quote = 91;
                    continue block12;
                }
                case '#': {
                    if (quote == 91) {
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(35);
                        continue block12;
                    }
                    if (isComments) {
                        sb = sb.appendByte(ch);
                        ++i;
                        while (i < len) {
                            ch = regexp.charAt(i);
                            sb = sb.appendByte(ch);
                            if (ch == '\n' || ch == '\r') continue block12;
                            ++i;
                        }
                        continue block12;
                    }
                    sb = sb.appendByte(ch);
                    continue block12;
                }
                case ']': {
                    sb = sb.appendByte(ch);
                    if (quote != 91) continue block12;
                    quote = 0;
                    continue block12;
                }
                case '{': {
                    if (i + 1 < len && ('0' <= (ch = regexp.charAt(i + 1)) && ch <= '9' || ch == ',')) {
                        sb = sb.appendByte(123);
                        ++i;
                        while (i < len && ('0' <= (ch = regexp.charAt(i)) && ch <= '9' || ch == ',')) {
                            sb = sb.appendByte(ch);
                            ++i;
                        }
                        if (i >= len) continue block12;
                        sb = sb.appendByte(regexp.charAt(i));
                        continue block12;
                    }
                    sb = sb.appendByte(92);
                    sb = sb.appendByte(123);
                    continue block12;
                }
                case '}': {
                    sb = sb.appendByte(92);
                    sb = sb.appendByte(125);
                    continue block12;
                }
                case '|': {
                    sb = sb.appendByte(124);
                    continue block12;
                }
                default: {
                    sb = sb.appendByte(ch);
                }
            }
        }
        return sb;
    }

    static {
        RegexpModule.PREG_QUOTE[92] = true;
        RegexpModule.PREG_QUOTE[43] = true;
        RegexpModule.PREG_QUOTE[42] = true;
        RegexpModule.PREG_QUOTE[63] = true;
        RegexpModule.PREG_QUOTE[91] = true;
        RegexpModule.PREG_QUOTE[94] = true;
        RegexpModule.PREG_QUOTE[93] = true;
        RegexpModule.PREG_QUOTE[36] = true;
        RegexpModule.PREG_QUOTE[40] = true;
        RegexpModule.PREG_QUOTE[41] = true;
        RegexpModule.PREG_QUOTE[123] = true;
        RegexpModule.PREG_QUOTE[125] = true;
        RegexpModule.PREG_QUOTE[61] = true;
        RegexpModule.PREG_QUOTE[33] = true;
        RegexpModule.PREG_QUOTE[60] = true;
        RegexpModule.PREG_QUOTE[62] = true;
        RegexpModule.PREG_QUOTE[124] = true;
        RegexpModule.PREG_QUOTE[58] = true;
        RegexpModule.PREG_QUOTE[46] = true;
        RegexpModule.PREG_QUOTE[45] = true;
    }

    static final class RegexpCacheItem {
        private final StringValue _pattern;
        private Regexp _regexp;
        private IllegalRegexpException _exn;

        RegexpCacheItem(StringValue pattern) {
            this._pattern = pattern;
        }

        public Regexp get() throws IllegalRegexpException {
            if (this._regexp != null) {
                return this._regexp;
            }
            if (this._exn != null) {
                throw this._exn;
            }
            RegexpCacheItem regexpCacheItem = this;
            synchronized (regexpCacheItem) {
                try {
                    this._regexp = new Regexp(this._pattern);
                    return this._regexp;
                }
                catch (IllegalRegexpException e) {
                    this._exn = e;
                    throw e;
                }
            }
        }
    }

    static class UnicodeEregKey {
        StringValue _regexpValue;
        String _encoding;

        UnicodeEregKey(StringValue regexpValue, String encoding) {
            this._regexpValue = regexpValue;
            this._encoding = encoding;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UnicodeEregKey)) {
                return false;
            }
            UnicodeEregKey ereg = (UnicodeEregKey)o;
            return this._regexpValue.equals(ereg._regexpValue) && this._encoding.equals(ereg._encoding);
        }
    }

    static class GroupNeighborMap {
        private int[] _neighborMap;
        private static int UNSET = -1;

        public GroupNeighborMap(CharSequence regexp, int groups) {
            this._neighborMap = new int[groups + 1];
            for (int i = 1; i <= groups; ++i) {
                this._neighborMap[i] = UNSET;
            }
            boolean sawEscape = false;
            boolean sawVerticalBar = false;
            boolean isLiteral = false;
            int group = 0;
            int parent = UNSET;
            int length = regexp.length();
            ArrayList<Boolean> openParenStack = new ArrayList<Boolean>(groups);
            for (int i = 0; i < length; ++i) {
                char ch = regexp.charAt(i);
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == 'r' || ch == '\f') continue;
                if (ch == '\\') {
                    sawEscape = !sawEscape;
                    continue;
                }
                if (ch == '[' && !sawEscape) {
                    isLiteral = true;
                    continue;
                }
                if (ch == ']' && !sawEscape) {
                    isLiteral = false;
                    continue;
                }
                if (isLiteral || sawEscape) {
                    sawEscape = false;
                    continue;
                }
                if (ch == '(') {
                    if (i + 1 < length && regexp.charAt(i + 1) == '?') {
                        openParenStack.add(true);
                        continue;
                    }
                    openParenStack.add(false);
                    ++group;
                    if (sawVerticalBar) {
                        sawVerticalBar = false;
                        this._neighborMap[group] = group - 1;
                        continue;
                    }
                    this._neighborMap[group] = parent;
                    parent = group;
                    continue;
                }
                if (ch == ')') {
                    if (((Boolean)openParenStack.remove(openParenStack.size() - 1)).booleanValue()) continue;
                    sawVerticalBar = false;
                    continue;
                }
                if (ch != '|') continue;
                sawVerticalBar = true;
            }
        }

        public boolean hasNeighbor(int group) {
            return this._neighborMap[group] != UNSET;
        }

        public int getNeighbor(int group) {
            return this._neighborMap[group];
        }
    }

    static class GroupEscapeReplacement
    extends Replacement {
        private int _group;

        GroupEscapeReplacement(int group) {
            this._group = group;
        }

        StringValue eval(Env env, StringValue sb, RegexpState regexpState) {
            if (this._group < regexpState.groupCount()) {
                StringValue group = regexpState.group(env, this._group);
                int len = group.length();
                block6: for (int i = 0; i < len; ++i) {
                    char ch = group.charAt(i);
                    switch (ch) {
                        case '\'': {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(39);
                            continue block6;
                        }
                        case '\"': {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(34);
                            continue block6;
                        }
                        case '\\': {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(92);
                            continue block6;
                        }
                        case '\u0000': {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(48);
                            continue block6;
                        }
                        default: {
                            sb = sb.appendByte(ch);
                        }
                    }
                }
            }
            return sb;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "]";
        }
    }

    static class GroupReplacement
    extends Replacement {
        private int _group;

        GroupReplacement(int group) {
            this._group = group;
        }

        StringValue eval(Env env, StringValue sb, RegexpState regexpState) {
            if (this._group < regexpState.groupCount()) {
                sb = sb.append(regexpState.group(env, this._group));
            }
            return sb;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "]";
        }
    }

    static class TextReplacement
    extends Replacement {
        private char[] _text;

        TextReplacement(StringBuilder text) {
            int length = text.length();
            this._text = new char[length];
            text.getChars(0, length, this._text, 0);
        }

        StringValue eval(Env env, StringValue sb, RegexpState regexpState) {
            return sb.appendBytes(this._text, 0, this._text.length);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('[');
            for (char ch : this._text) {
                sb.append(ch);
            }
            sb.append(']');
            return sb.toString();
        }
    }

    static abstract class Replacement {
        Replacement() {
        }

        abstract StringValue eval(Env var1, StringValue var2, RegexpState var3);

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

