/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegexpState {
    private static final Logger log = Logger.getLogger(RegexpState.class.getName());
    private static final L10N L = new L10N(Regexp.class);
    public static final int FAIL = -1;
    public static final int SUCCESS = 0;
    private Regexp _regexp;
    private StringValue _subject;
    private int _subjectLength;
    boolean _isGlobal;
    int _first;
    int _start;
    CharBuffer _prefix;
    int _minLength;
    boolean _isUnicode;
    boolean _isPHP5String;
    boolean _isUTF8;
    boolean _isEval;
    int _groupLength;
    int[] _groupBegin;
    int[] _groupEnd;
    int[] _loopCount;
    int[] _loopOffset;

    private RegexpState() {
        int size = 32;
        this._groupBegin = new int[size];
        this._groupEnd = new int[size];
        this._loopCount = new int[size];
        this._loopOffset = new int[size];
    }

    private void init(Regexp regexp) {
        int nLoop;
        this._regexp = regexp;
        int nGroup = regexp._nGroup;
        if (this._groupBegin.length < nGroup) {
            this._groupBegin = new int[nGroup];
            this._groupEnd = new int[nGroup];
        }
        if (this._loopCount.length < (nLoop = regexp._nLoop)) {
            this._loopCount = new int[nLoop];
            this._loopOffset = new int[nLoop];
        }
        this._subject = null;
        this._subjectLength = 0;
        this._isGlobal = false;
        this._first = 0;
        this._start = 0;
        this._prefix = null;
        this._minLength = 0;
        this._isUnicode = false;
        this._isPHP5String = false;
        this._isUTF8 = false;
        this._isEval = false;
    }

    public static RegexpState create(Env env, Regexp regexp) {
        RegexpState state = env.allocateRegexpState();
        if (state == null) {
            state = new RegexpState();
        }
        state.init(regexp);
        return state;
    }

    public static RegexpState create(Env env, Regexp regexp, StringValue subject) {
        RegexpState state = RegexpState.create(env, regexp);
        state.setSubject(env, subject);
        return state;
    }

    public static void free(Env env, RegexpState state) {
        env.freeRegexpState(state);
    }

    public int getSubjectLength() {
        return this._subjectLength;
    }

    public boolean setSubject(Env env, StringValue subject) {
        this._subject = this._regexp.convertSubject(env, subject);
        this._subjectLength = this._subject != null ? this._subject.length() : 0;
        return this._subject != null;
    }

    public void setFirst(int first) {
        this._first = first;
        this._start = first;
    }

    public boolean find() {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " find()");
            }
            int minLength = this._regexp._minLength;
            boolean[] firstSet = this._regexp._firstSet;
            if (this._subject == null) {
                return false;
            }
            StringValue subject = this._subject;
            int length = this._subjectLength;
            while (this._first + minLength <= length) {
                char firstChar;
                if (firstSet == null || this._first >= length || (firstChar = subject.charAt(this._first)) >= '\u0100' || firstSet[firstChar]) {
                    this.clearGroup();
                    int offset = this._regexp._prog.match(subject, length, this._first, this);
                    if (offset >= 0) {
                        this._groupBegin[0] = this._first;
                        this._groupEnd[0] = offset;
                        this._first = this._first < offset ? offset : ++this._first;
                        return true;
                    }
                }
                ++this._first;
            }
            this._first = length + 1;
            return false;
        }
        catch (StackOverflowError e) {
            log.warning(L.l("regexp '{0}' produces a StackOverflowError for\n{1}", (Object)this._regexp, this._subject));
            throw new QuercusRuntimeException(L.l("regexp '{0}' produces a StackOverflowError", this._regexp), e);
        }
    }

    public boolean find(Env env, StringValue subject) {
        try {
            subject = this._regexp.convertSubject(env, subject);
            if (subject == null) {
                throw new QuercusException(L.l("error converting subject to utf8"));
            }
            this._subject = subject;
            this._subjectLength = subject != null ? subject.length() : 0;
            this._first = 0;
            return this.find();
        }
        catch (StackOverflowError e) {
            log.warning(L.l("regexp '{0}' produces a StackOverflowError for\n{1}", (Object)this._regexp, subject));
            throw new QuercusRuntimeException(L.l("regexp '{0}' produces a StackOverflowError", this._regexp), e);
        }
    }

    public int find(Env env, StringValue subject, int first) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " find(" + subject + ")");
            }
            if ((subject = this._regexp.convertSubject(env, subject)) == null) {
                throw new QuercusException(L.l("error converting subject to utf8"));
            }
            this._subject = subject;
            this._subjectLength = subject != null ? subject.length() : 0;
            this._first = first;
            this.clearGroup();
            return this._regexp._prog.match(this._subject, this._subjectLength, first, this);
        }
        catch (StackOverflowError e) {
            log.warning(L.l("regexp '{0}' produces a StackOverflowError for\n{1}", (Object)this._regexp, subject));
            throw new QuercusRuntimeException(L.l("regexp '{0}' produces a StackOverflowError", this._regexp), e);
        }
    }

    public int exec(Env env, StringValue subject, int start) {
        try {
            int subjectLength;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " exec(" + subject + ")");
            }
            if ((subject = this._regexp.convertSubject(env, subject)) == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(L.l("error converting subject to utf8"));
                }
                return -1;
            }
            this.clearGroup();
            this._start = start;
            this._first = start;
            this._subject = subject;
            this._subjectLength = subjectLength = subject != null ? subject.length() : 0;
            int minLength = this._regexp._minLength;
            boolean[] firstSet = this._regexp._firstSet;
            int end = subjectLength - minLength;
            RegexpNode prog = this._regexp._prog;
            if (this._regexp._isAnchorBegin) {
                end = start;
            }
            while (start <= end) {
                int value;
                char firstChar;
                if ((firstSet == null || start >= end && minLength <= 0 || (firstChar = subject.charAt(start)) >= '\u0100' || firstSet[firstChar]) && (value = prog.match(subject, subjectLength, start, this)) >= 0) {
                    this._groupBegin[0] = start;
                    this._groupEnd[0] = value;
                    return start;
                }
                ++start;
            }
            return -1;
        }
        catch (StackOverflowError e) {
            log.warning(L.l("regexp '{0}' produces a StackOverflowError for\n{1}", (Object)this._regexp, subject));
            throw new QuercusRuntimeException(L.l("regexp '{0}' produces a StackOverflowError", this._regexp), e);
        }
    }

    private void clearGroup() {
        this._groupLength = 0;
        for (int i = this._groupBegin.length - 1; i > 0; --i) {
            this._groupBegin[i] = -1;
            this._groupEnd[i] = -1;
        }
    }

    public int getBegin(int i) {
        return this._groupBegin[i];
    }

    public int getEnd(int i) {
        return this._groupEnd[i];
    }

    public void setBegin(int i, int v) {
        this._groupBegin[i] = v;
    }

    public void setEnd(int i, int v) {
        this._groupEnd[i] = v;
    }

    public int getLength() {
        return this._groupLength;
    }

    public void setLength(int length) {
        this._groupLength = length;
    }

    public int length() {
        return this._groupLength;
    }

    public int start() {
        return this.getBegin(0);
    }

    public int start(int i) {
        return this.getBegin(i);
    }

    public int end() {
        return this.getEnd(0);
    }

    public int end(int i) {
        return this.getEnd(i);
    }

    public int groupCount() {
        return this._regexp._nGroup;
    }

    public boolean isMatchedGroup(int i) {
        return i <= this._groupLength;
    }

    public StringValue group(Env env) {
        return this.group(env, 0);
    }

    public StringValue group(Env env, int i) {
        int begin = this.getBegin(i);
        int end = this.getEnd(i);
        StringValue s = this._subject.substring(begin, end);
        return this._regexp.convertResult(env, s);
    }

    public StringValue getGroupName(int i) {
        StringValue[] groupNames = this._regexp._groupNames;
        if (groupNames == null || groupNames.length <= i) {
            return null;
        }
        return groupNames[i];
    }

    public StringValue substring(Env env, int start) {
        StringValue result = this._subject.substring(start);
        return this._regexp.convertResult(env, result);
    }

    public StringValue substring(Env env, int start, int end) {
        StringValue result = this._subject.substring(start, end);
        return this._regexp.convertResult(env, result);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._regexp + "]";
    }
}

