/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.annotation.EntrySet;
import com.caucho.quercus.annotation.Hide;
import com.caucho.quercus.annotation.JsonEncode;
import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtJavaValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.SelectedXMLElement;
import com.caucho.quercus.lib.simplexml.SimpleXMLAttribute;
import com.caucho.quercus.lib.simplexml.SimpleXMLAttributeList;
import com.caucho.quercus.lib.simplexml.SimpleXMLChildren;
import com.caucho.quercus.lib.simplexml.SimpleXMLNamespaceAttribute;
import com.caucho.quercus.lib.simplexml.SimpleXMLText;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXMLElement
implements Map.Entry<String, Object> {
    private static final Logger log = Logger.getLogger(SimpleXMLElement.class.getName());
    private static final L10N L = new L10N(SimpleXMLElement.class);
    protected SimpleXMLElement _parent;
    protected String _name;
    protected StringValue _text;
    protected ArrayList<SimpleXMLElement> _children;
    protected ArrayList<SimpleXMLElement> _attributes;
    protected String _namespace;
    protected String _prefix;
    protected LinkedHashMap<String, String> _namespaceMap;
    protected Env _env;
    protected QuercusClass _cls;

    protected SimpleXMLElement(Env env, QuercusClass cls) {
        this._env = env;
        this._cls = cls;
    }

    protected SimpleXMLElement(Env env, QuercusClass cls, SimpleXMLElement parent, String name) {
        this._env = env;
        this._cls = cls;
        this._parent = parent;
        this._name = name;
    }

    protected SimpleXMLElement(Env env, QuercusClass cls, SimpleXMLElement parent, String name, String namespace) {
        this._env = env;
        this._cls = cls;
        this._parent = parent;
        int p = name.indexOf(58);
        if (p > 0) {
            this._name = name.substring(p + 1);
            this._prefix = name.substring(0, p);
        } else {
            this._name = name;
        }
        if ("".equals(this._name)) {
            throw new IllegalArgumentException(L.l("name can't be empty"));
        }
        this._namespace = namespace;
        if (namespace != null) {
            if (this._prefix == null) {
                this._prefix = "";
            }
            if (!this.hasNamespace(this._prefix, namespace)) {
                String ns = "".equals(this._prefix) ? "xmlns" : "xmlns:" + this._prefix;
                this.addNamespaceAttribute(env, ns, namespace);
            }
        }
    }

    protected static Value create(Env env, QuercusClass cls, Value data, int options, boolean dataIsUrl, Value namespaceV, boolean isPrefix) {
        if (data.length() == 0) {
            env.warning(L.l("xml data must have length greater than 0"));
            return BooleanValue.FALSE;
        }
        try {
            Node node;
            String namespace = null;
            if (!namespaceV.isNull()) {
                namespace = namespaceV.toString();
            }
            if ((node = SimpleXMLElement.parse(env, data, options, dataIsUrl, namespace, isPrefix)) == null) {
                return BooleanValue.FALSE;
            }
            SimpleXMLElement elt = SimpleXMLElement.buildNode(env, cls, null, node, namespace, isPrefix);
            return SimpleXMLElement.wrapJava(env, cls, elt);
        }
        catch (IOException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
        catch (ParserConfigurationException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
        catch (SAXException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    protected static Value wrapJava(Env env, QuercusClass cls, SimpleXMLElement element) {
        if (!"SimpleXMLElement".equals(cls.getName())) {
            return new ObjectExtJavaValue(cls, element, cls.getJavaClassDef());
        }
        return new JavaValue(env, element, cls.getJavaClassDef());
    }

    protected QuercusClass getQuercusClass() {
        return this._cls;
    }

    protected void setQuercusClass(QuercusClass cls) {
        this._cls = cls;
    }

    protected void addNamespace(String prefix, String namespace) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.hasNamespace(prefix, namespace)) {
            return;
        }
        if (this._namespaceMap == null) {
            this._namespaceMap = new LinkedHashMap();
        }
        this._namespaceMap.put(prefix, namespace);
    }

    protected boolean hasNamespace(String prefix, String namespace) {
        String uri = this.getNamespace(prefix);
        return uri != null && uri.equals(namespace);
    }

    protected String getNamespace(String prefix) {
        String uri;
        if (prefix == null) {
            prefix = "";
        }
        if (this._namespaceMap != null && (uri = this._namespaceMap.get(prefix)) != null) {
            return uri;
        }
        if (this._parent != null) {
            return this._parent.getNamespace(prefix);
        }
        return null;
    }

    public static Value __construct(Env env, Value data, @Optional int options, @Optional boolean dataIsUrl, @Optional Value namespaceV, @Optional boolean isPrefix) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            cls = env.getClass("SimpleXMLElement");
        }
        return SimpleXMLElement.create(env, cls, data, options, dataIsUrl, namespaceV, isPrefix);
    }

    protected String getName() {
        return this._name;
    }

    protected String getNamespace() {
        return this._namespace != null ? this._namespace : "";
    }

    protected SimpleXMLElement getOwner() {
        return this;
    }

    protected boolean isElement() {
        return true;
    }

    protected boolean isNamespaceAttribute() {
        return false;
    }

    protected void setText(StringValue text) {
        this._text = text.createStringBuilder().append(text);
    }

    protected void addText(StringValue text) {
        if (this._text == null) {
            this._text = text.createStringBuilder();
        }
        this._text = this._text.append(text);
    }

    protected boolean isSameNamespace(String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return true;
        }
        if (this._namespace != null && this._namespace.length() > 0) {
            return namespace.equals(this._namespace);
        }
        if (this._parent != null) {
            return this._parent.isSameNamespace(namespace);
        }
        return false;
    }

    protected boolean isSamePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return prefix.equals(this._prefix);
    }

    protected SimpleXMLElement getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        int size = this._attributes.size();
        for (int i = 0; i < size; ++i) {
            SimpleXMLElement attr = this._attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    private SimpleXMLElement getElement(String name) {
        if (this._children == null) {
            return null;
        }
        int size = this._children.size();
        for (int i = 0; i < size; ++i) {
            SimpleXMLElement elt = this._children.get(i);
            if (!elt.getName().equals(name)) continue;
            return elt;
        }
        return null;
    }

    @Override
    @Hide
    public String getKey() {
        return this._name;
    }

    @Override
    @Hide
    public Object getValue() {
        if (this._children == null) {
            return this._text;
        }
        return SimpleXMLElement.wrapJava(this._env, this._cls, this);
    }

    @Override
    @Hide
    public Object setValue(Object value) {
        return SimpleXMLElement.wrapJava(this._env, this._cls, this);
    }

    public void addAttribute(Env env, String name, StringValue value, @Optional String namespace) {
        int colonIndex;
        if (namespace != null && namespace.length() > 0 && ((colonIndex = name.indexOf(":")) <= 0 || colonIndex >= name.length())) {
            env.warning(L.l("Adding attributes with namespaces requires attribute name with a prefix"));
            return;
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        SimpleXMLAttribute attr = new SimpleXMLAttribute(env, this._cls, this, name, namespace, value);
        this._attributes.add(attr);
    }

    protected void addNamespaceAttribute(Env env, String name, String namespace) {
        if (namespace == null || "".equals(namespace)) {
            return;
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        SimpleXMLNamespaceAttribute attr = new SimpleXMLNamespaceAttribute(env, this._cls, this, name, "", env.createString(namespace));
        int p = name.indexOf(58);
        if (p > 0) {
            String prefix = name.substring(p + 1);
            this.addNamespace(prefix, namespace);
        } else {
            if (this._namespace == null) {
                this._namespace = namespace;
            }
            this.addNamespace("", namespace);
        }
        for (int i = this._attributes.size() - 1; i >= 0; --i) {
            SimpleXMLElement oldAttr = this._attributes.get(i);
            if (!oldAttr.getName().equals(name) || !oldAttr.getNamespace().equals(namespace)) continue;
            this._attributes.set(i, attr);
            return;
        }
        this._attributes.add(attr);
    }

    protected void addAttribute(SimpleXMLElement attr) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(attr);
    }

    public Value addChild(Env env, String name, String value, @Optional Value namespaceV) {
        String namespace = namespaceV.toString();
        SimpleXMLElement child = new SimpleXMLElement(env, this._cls, this, name, namespace);
        child.setText(env.createString(value));
        this.addChild(child);
        return SimpleXMLElement.wrapJava(env, this._cls, child);
    }

    private void addChild(SimpleXMLElement child) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(child);
    }

    public Value attributes(Env env, @Optional Value namespaceV, @Optional boolean isPrefix) {
        String namespace = null;
        if (!namespaceV.isNull()) {
            namespace = namespaceV.toString();
        }
        SimpleXMLAttributeList attrList = new SimpleXMLAttributeList(env, this._cls, this, "#attrlist", namespace, null);
        if (this._attributes != null) {
            for (SimpleXMLElement attr : this._attributes) {
                if (!attr.isSameNamespace(namespace) || attr.isNamespaceAttribute()) continue;
                attrList.addAttribute(attr);
            }
        }
        return SimpleXMLElement.wrapJava(env, this._cls, attrList);
    }

    public Value children(Env env, @Optional Value namespaceV, @Optional boolean isPrefix) {
        String namespace = null;
        if (!namespaceV.isNull()) {
            namespace = namespaceV.toString();
        }
        SimpleXMLChildren result = new SimpleXMLChildren(env, this._cls, this, this.getName());
        if (this._attributes != null) {
            for (SimpleXMLElement attr : this._attributes) {
                if (!attr.isSameNamespace(namespace)) continue;
                result.addAttribute(attr);
            }
        }
        if (this._children != null) {
            for (SimpleXMLElement child : this._children) {
                if (isPrefix) {
                    if (!child.isSamePrefix(namespace)) continue;
                    super.addChild(child);
                    continue;
                }
                if (!child.isSameNamespace(namespace)) continue;
                super.addChild(child);
            }
        }
        return SimpleXMLElement.wrapJava(env, this._cls, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node parse(Env env, Value data, int options, boolean dataIsUrl, String namespace, boolean isPrefix) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = null;
        if (dataIsUrl) {
            Path path = env.lookup(data.toStringValue());
            if (path == null) {
                log.log(Level.FINE, L.l("Cannot read file/URL '{0}'", data));
                env.warning(L.l("Cannot read file/URL '{0}'", data));
                return null;
            }
            ReadStream is = path.openRead();
            try {
                document = builder.parse(is);
            }
            finally {
                is.close();
            }
        } else {
            StringReader reader = new StringReader(data.toString());
            document = builder.parse(new InputSource(reader));
        }
        NodeList childList = document.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (childList.item(i).getNodeType() != 1) continue;
            return childList.item(i);
        }
        return childList.item(0);
    }

    private static SimpleXMLElement buildNode(Env env, QuercusClass cls, SimpleXMLElement parent, Node node, String namespace, boolean isPrefix) {
        NamedNodeMap attrs;
        if (node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (parent != null) {
                parent.addChild(new SimpleXMLText(env, cls, env.createString(value)));
                if (!SimpleXMLElement.isWhitespace(value)) {
                    parent.addText(env.createString(value));
                }
            }
            return parent;
        }
        SimpleXMLElement elt = new SimpleXMLElement(env, cls, parent, node.getNodeName(), namespace);
        if (parent != null) {
            parent.addChild(elt);
        }
        if ((attrs = node.getAttributes()) != null) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (attr.getName().startsWith("xmlns")) {
                    elt.addNamespaceAttribute(env, attr.getName(), attr.getValue());
                    continue;
                }
                elt.addAttribute(env, attr.getName(), env.createString(attr.getValue()), namespace);
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            SimpleXMLElement.buildNode(env, cls, elt, child, namespace, isPrefix);
        }
        return elt;
    }

    @ReturnNullAsFalse
    public StringValue asXML(Env env) {
        if (this._parent == null) {
            StringValue sb = env.createBinaryBuilder();
            sb.append("<?xml version=\"1.0\"?>\n");
            this.toXMLImpl(sb);
            sb.append("\n");
            return sb;
        }
        return this.toXML(env);
    }

    public StringValue toXML(Env env) {
        StringValue sb = env.createBinaryBuilder();
        this.toXMLImpl(sb);
        return sb;
    }

    protected void toXMLImpl(StringValue sb) {
        int i;
        int size;
        sb.append("<");
        boolean hasPrefix = false;
        if (this._prefix != null && !"".equals(this._prefix) && this.getNamespace(this._prefix) != null) {
            hasPrefix = true;
        }
        if (hasPrefix) {
            sb.append(this._prefix);
            sb.append(":");
        }
        sb.append(this._name);
        if (this._attributes != null) {
            size = this._attributes.size();
            for (i = 0; i < size; ++i) {
                SimpleXMLElement attr = this._attributes.get(i);
                attr.toXMLImpl(sb);
            }
        }
        if (this._children != null) {
            sb.append(">");
            size = this._children.size();
            for (i = 0; i < size; ++i) {
                SimpleXMLElement child = this._children.get(i);
                child.toXMLImpl(sb);
            }
        } else {
            if (this._text == null || this._text.length() == 0) {
                sb.append("/>");
                return;
            }
            sb.append(">");
            sb.append(this._text);
        }
        sb.append("</");
        if (hasPrefix) {
            sb.append(this._prefix);
            sb.append(":");
        }
        sb.append(this._name);
        sb.append(">");
    }

    @Name(value="getName")
    public String simplexml_getName() {
        return this._name;
    }

    public Value getDocNamespaces(Env env, @Optional boolean isRecursive) {
        return this.getNamespaces(env, isRecursive);
    }

    public Value getNamespaces(Env env, @Optional boolean isRecursive) {
        ArrayValueImpl array = new ArrayValueImpl();
        if (isRecursive) {
            this.getNamespacesRec(env, array);
        } else {
            this.getNamespaces(env, array);
        }
        return array;
    }

    private void getNamespacesRec(Env env, ArrayValue array) {
        this.getNamespaces(env, array);
        if (this._children != null) {
            for (SimpleXMLElement child : this._children) {
                child.getNamespacesRec(env, array);
            }
        }
    }

    private void getNamespaces(Env env, ArrayValue array) {
        if (this._namespaceMap != null) {
            for (Map.Entry<String, String> entry : this._namespaceMap.entrySet()) {
                StringValue name = env.createString(entry.getKey());
                StringValue uri = env.createString(entry.getValue());
                SimpleXMLAttribute attr = new SimpleXMLAttribute(env, this._cls, this, entry.getKey());
                attr.setText(uri);
                array.append(name, env.wrapJava(attr));
            }
        }
    }

    public Value xpath(Env env, String expression) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            InputSource is = new InputSource(this.asXML(env).toInputStream());
            NodeList nodes = (NodeList)xpath.evaluate(expression, is, XPathConstants.NODESET);
            int nodeLength = nodes.getLength();
            if (nodeLength == 0) {
                return NullValue.NULL;
            }
            ArrayValueImpl result = new ArrayValueImpl();
            for (int i = 0; i < nodeLength; ++i) {
                Node node = nodes.item(i);
                boolean isPrefix = node.getPrefix() != null;
                SimpleXMLElement xml = SimpleXMLElement.buildNode(env, this._cls, null, nodes.item(i), node.getNamespaceURI(), isPrefix);
                ((ArrayValue)result).put(SimpleXMLElement.wrapJava(env, this._cls, xml));
            }
            return result;
        }
        catch (XPathExpressionException e) {
            env.warning(e);
            log.log(Level.FINE, e.getMessage());
            return NullValue.NULL;
        }
    }

    public Value __get(Env env, Value indexV) {
        if (indexV.isString()) {
            String name = indexV.toString();
            SimpleXMLElement attr = this.getAttribute(name);
            if (attr == null) {
                return NullValue.NULL;
            }
            return SimpleXMLElement.wrapJava(env, this._cls, attr);
        }
        if (indexV.isLongConvertible()) {
            int i = indexV.toInt();
            if (i == 0) {
                return SimpleXMLElement.wrapJava(env, this._cls, this.getOwner());
            }
            if (this._parent == null) {
                return NullValue.NULL;
            }
            ArrayList<SimpleXMLElement> children = this._parent._children;
            if (children != null) {
                int size = children.size();
                for (int j = 0; j < size; ++j) {
                    SimpleXMLElement child = children.get(j);
                    if (!child.getName().equals(this.getName()) || i-- != 0) continue;
                    return SimpleXMLElement.wrapJava(env, this._cls, child);
                }
            }
            return NullValue.NULL;
        }
        return NullValue.NULL;
    }

    public void __set(String name, StringValue value) {
        this.addAttribute(this._env, name, value, null);
    }

    public Value __getField(String name) {
        SimpleXMLElement elt = this.getElement(name);
        if (elt != null) {
            return SimpleXMLElement.wrapJava(this._env, this._cls, new SelectedXMLElement(this._env, this._cls, elt));
        }
        return NullValue.NULL;
    }

    public void __setField(String name, Value value) {
        SimpleXMLElement child = this.getElement(name);
        if (child == null) {
            child = new SimpleXMLElement(this._env, this._cls, this, name);
            child.setText(value.toStringValue());
            this.addChild(child);
        } else {
            child._children = null;
            child.setText(value.toStringValue());
        }
    }

    public Iterator iterator() {
        if (this._children != null) {
            return new ElementIterator(this._children);
        }
        return null;
    }

    @EntrySet
    public Set<Map.Entry<Value, Value>> entrySet() {
        LinkedHashMap<Value, Value> map = new LinkedHashMap<Value, Value>();
        if (this._attributes != null) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (SimpleXMLElement attr : this._attributes) {
                StringValue value = attr._text;
                array.put(this._env.createString(attr._name), value);
            }
            map.put(this._env.createString("@attributes"), array);
        }
        boolean hasElement = false;
        if (this._children != null) {
            for (SimpleXMLElement child : this._children) {
                ArrayValue array;
                if (!child.isElement()) continue;
                hasElement = true;
                StringValue name = this._env.createString(child.getName());
                Value oldChild = (Value)map.get(name);
                Value childValue = child._text != null ? child._text : SimpleXMLElement.wrapJava(this._env, this._cls, child);
                if (oldChild == null) {
                    map.put(name, childValue);
                    continue;
                }
                if (oldChild.isArray()) {
                    array = (ArrayValue)oldChild;
                    array.append(childValue);
                    continue;
                }
                array = new ArrayValueImpl();
                array.append(oldChild);
                array.append(childValue);
                map.put(name, array);
            }
        }
        if (!hasElement && this._text != null) {
            map.put(LongValue.ZERO, this._text);
        }
        return map.entrySet();
    }

    public void varDumpImpl(Env env, Value obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        String name = "SimpleXMLElement";
        if (obj != null) {
            name = obj.getClassName();
        }
        if (this._text != null && this._children == null && this._attributes == null) {
            if (depth > 0) {
                this._text.varDump(env, out, depth, valueSet);
                return;
            }
            out.println("object(" + name + ") (1) {");
            this.printDepth(out, 2 * (depth + 1));
            out.println("[0]=>");
            this.printDepth(out, 2 * (depth + 1));
            this._text.varDump(env, out, depth, valueSet);
            out.println();
            this.printDepth(out, 2 * depth);
            out.print("}");
            return;
        }
        Set<Map.Entry<Value, Value>> entrySet = this.entrySet();
        out.println("object(" + name + ") (" + entrySet.size() + ") {");
        for (Map.Entry<Value, Value> entry : entrySet) {
            this.printDepth(out, 2 * (depth + 1));
            out.print("[");
            if (entry.getKey().isString()) {
                out.print("\"" + entry.getKey() + "\"");
            } else {
                out.print(entry.getKey());
            }
            out.println("]=>");
            this.printDepth(out, 2 * (depth + 1));
            entry.getValue().varDump(env, out, depth + 1, valueSet);
            out.println();
        }
        this.printDepth(out, 2 * depth);
        out.print('}');
    }

    @JsonEncode
    public void jsonEncode(Env env, StringValue sb) {
        sb.append('{');
        this.jsonEncodeImpl(env, sb, true);
        sb.append('}');
    }

    protected void jsonEncodeImpl(Env env, StringValue sb, boolean isTop) {
        if (!isTop) {
            sb.append('\"');
            sb.append(this.getName());
            sb.append('\"');
            sb.append(':');
        }
        if (this._attributes == null && this._children != null && this._children.size() == 1 && !this._children.get(0).isElement()) {
            this._children.get(0).jsonEncodeImpl(env, sb, false);
        } else {
            boolean hasChildren;
            int length = 0;
            boolean bl = hasChildren = this._attributes != null && this._children != null;
            if (hasChildren) {
                sb.append('{');
            }
            if (this._attributes != null) {
                ++length;
                sb.append("\"@attributes\"");
                sb.append(':');
                sb.append('{');
                for (SimpleXMLElement attribute : this._attributes) {
                    attribute.jsonEncodeImpl(env, sb, false);
                }
                sb.append('}');
            }
            if (this._children != null) {
                for (SimpleXMLElement child : this._children) {
                    if (!child.isElement()) continue;
                    if (length++ > 0) {
                        sb.append(',');
                    }
                    child.jsonEncodeImpl(env, sb, false);
                }
            }
            if (hasChildren) {
                sb.append('}');
            }
        }
    }

    protected void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.print(' ');
        }
    }

    public StringValue __toString(Env env) {
        if (this._text != null) {
            return this._text;
        }
        return env.getEmptyString();
    }

    private static boolean isWhitespace(String text) {
        for (int i = text.length() - 1; i >= 0; --i) {
            if (SimpleXMLElement.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhitespace(int ch) {
        return ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 13);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementIterator
    implements Iterator {
        private ArrayList<SimpleXMLElement> _children;
        private int _index;
        private int _size;

        ElementIterator(ArrayList<SimpleXMLElement> children) {
            this._children = children;
            this._size = children.size();
        }

        @Override
        public boolean hasNext() {
            while (this._index < this._size) {
                SimpleXMLElement elt = this._children.get(this._index);
                if (elt.isElement()) {
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        public Object next() {
            while (this._index < this._size) {
                SimpleXMLElement elt;
                if (!(elt = this._children.get(this._index++)).isElement()) continue;
                return elt;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

