/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.string;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Post;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.util.L10N;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;

public class StringUtility {
    private static final L10N L = new L10N(StringModule.class);

    public static Value parseStr(Env env, CharSequence str, ArrayValue result, boolean isRef, String encoding) {
        return StringUtility.parseStr(env, str, result, isRef, encoding, env.getIniBoolean("magic_quotes_gpc"), Env.DEFAULT_QUERY_SEPARATOR_MAP);
    }

    public static Value parseStr(Env env, CharSequence str, ArrayValue result, boolean isRef, String encoding, boolean isMagicQuotes, int[] querySeparatorMap) {
        try {
            ByteToChar byteToChar = env.getByteToChar();
            if (encoding != null) {
                byteToChar.setEncoding(encoding);
            }
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                String value;
                char ch = '\u0000';
                byteToChar.clear();
                while (i < len && querySeparatorMap[ch = str.charAt(i)] > 0) {
                    ++i;
                }
                while (i < len && (ch = str.charAt(i)) != '=' && querySeparatorMap[ch] == 0) {
                    i = StringUtility.addQueryChar(byteToChar, str, len, i, ch);
                    ++i;
                }
                String key = byteToChar.getConvertedString();
                byteToChar.clear();
                if (ch == '=') {
                    ++i;
                    while (i < len && querySeparatorMap[ch = str.charAt(i)] == 0) {
                        i = StringUtility.addQueryChar(byteToChar, str, len, i, ch);
                        ++i;
                    }
                    value = byteToChar.getConvertedString();
                } else {
                    value = "";
                }
                if (isRef) {
                    Post.addFormValue(env, result, key, new String[]{value}, isMagicQuotes);
                    continue;
                }
                int openBracketIndex = key.indexOf(91);
                int closeBracketIndex = key.indexOf(93);
                if (openBracketIndex > 0) {
                    String arrayName = key.substring(0, openBracketIndex);
                    Value v = env.getVar(arrayName = arrayName.replaceAll("\\.", "_")).getRawValue();
                    if (v instanceof ArrayValue) {
                        if (closeBracketIndex < 0) {
                            env.warning(L.l("invalid array {0}", key));
                            return NullValue.NULL;
                        }
                        if (closeBracketIndex > openBracketIndex + 1) {
                            String index = key.substring(key.indexOf(91) + 1, key.indexOf(93));
                            v.put(env.createString(index), env.createString(value));
                            continue;
                        }
                        v.put(env.createString(value));
                        continue;
                    }
                    Post.addFormValue(env, result, key, new String[]{value}, isMagicQuotes);
                    continue;
                }
                Post.addFormValue(env, result, key, new String[]{value}, isMagicQuotes);
            }
            if (!isRef) {
                ArrayModule.extract(env, result, 0L, null);
            }
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    protected static int addQueryChar(ByteToChar byteToChar, CharSequence str, int len, int i, int ch) throws IOException {
        if (str == null) {
            str = "";
        }
        switch (ch) {
            case 43: {
                byteToChar.addChar(' ');
                return i;
            }
            case 37: {
                if (i + 2 < len) {
                    int d1 = StringModule.hexToDigit(str.charAt(i + 1));
                    int d2 = StringModule.hexToDigit(str.charAt(i + 2));
                    byteToChar.addByte(d1 * 16 + d2);
                    return i + 2;
                }
                byteToChar.addByte((byte)ch);
                return i;
            }
        }
        byteToChar.addByte((byte)ch);
        return i;
    }

    public static void addQueryValue(Env env, ArrayValue array, String key, String valueStr) {
        if (key == null) {
            key = "";
        }
        if (valueStr == null) {
            valueStr = "";
        }
        StringValue value = env.createString(valueStr);
        int p = key.indexOf(91);
        if (p > 0 && key.endsWith("]")) {
            String index = key.substring(p + 1, key.length() - 1);
            key = key.substring(0, p);
            StringValue keyValue = env.createString(key);
            Value part = array != null ? array.get(keyValue) : env.getVar(key);
            if (!part.isArray()) {
                part = new ArrayValueImpl();
            }
            if (index.equals("")) {
                part.put(value);
            } else {
                part.put(env.createString(index), value);
            }
            if (array != null) {
                array.put(keyValue, part);
            } else {
                env.setVar(key, part);
            }
        } else if (array != null) {
            array.put(env.createString(key), value);
        } else {
            env.setVar(key, value);
        }
    }
}

