/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.xml;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlReader {
    private static final Logger log = Logger.getLogger(XmlReader.class.getName());
    private static final L10N L = new L10N(XmlReader.class);
    private int _depth = 0;
    private int _lastNodeType = -1;
    private int _currentNodeType = 7;
    private boolean _hasAttribute = false;
    private XMLStreamReader _streamReader = null;
    private static final HashMap<Integer, Integer> _constConvertMap = new HashMap();
    private HashMap<String, Integer> _startElements = new HashMap();
    public static final int NONE = 0;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int CDATA = 4;
    public static final int ENTITY_REF = 5;
    public static final int ENTITY = 6;
    public static final int PI = 7;
    public static final int COMMENT = 8;
    public static final int DOC = 9;
    public static final int DOC_TYPE = 10;
    public static final int DOC_FRAGMENT = 11;
    public static final int NOTATION = 12;
    public static final int WHITESPACE = 13;
    public static final int SIGNIFICANT_WHITESPACE = 14;
    public static final int END_ELEMENT = 15;
    public static final int END_ENTITY = 16;
    public static final int XML_DECLARATION = 17;
    public static final int LOADDTD = 1;
    public static final int DEFAULTATTRS = 2;
    public static final int VALIDATE = 3;
    public static final int SUBST_ENTITIES = 4;

    public XmlReader(@Optional String[] string) {
    }

    private boolean streamIsOpen(Env env, String operation) {
        if (!this.streamIsOpen()) {
            env.warning(L.l("Load Data before trying to " + operation));
            return false;
        }
        return true;
    }

    private boolean streamIsOpen() {
        return this._streamReader != null;
    }

    public Value getAttributeCount() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        try {
            if (this._currentNodeType == 1) {
                return LongValue.create(this._streamReader.getAttributeCount());
            }
            return LongValue.create(0L);
        }
        catch (IllegalStateException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            return NullValue.NULL;
        }
    }

    public Value getBaseURI() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return StringValue.create(this._streamReader.getLocation().getSystemId());
    }

    public Value getDepth() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return LongValue.create(this._depth);
    }

    public Value getHasAttributes() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        try {
            if (this._currentNodeType == 4) {
                return BooleanValue.FALSE;
            }
            return BooleanValue.create(this._hasAttribute || this._streamReader.getAttributeCount() > 0);
        }
        catch (IllegalStateException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            return NullValue.NULL;
        }
    }

    public Value getHasValue() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return BooleanValue.create(this._streamReader.hasText());
    }

    public Value getIsDefault() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return BooleanValue.FALSE;
    }

    public Value getIsEmptyElement() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        if (this._currentNodeType == 1 && this._streamReader.isEndElement()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public Value getLocalName() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        String name = "";
        name = this._currentNodeType == 4 ? "#text" : (this._currentNodeType == 5 ? "#comment" : this._streamReader.getLocalName());
        return StringValue.create(name);
    }

    public Value getName(Env env) {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        try {
            String name = "";
            String prefix = this._streamReader.getPrefix();
            name = this._currentNodeType == 4 ? "#text" : (this._currentNodeType == 5 ? "#comment" : (prefix == null || prefix.length() == 0 ? this._streamReader.getName().toString() : prefix + ":" + this._streamReader.getLocalName().toString()));
            return StringValue.create(name);
        }
        catch (IllegalStateException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            return NullValue.NULL;
        }
    }

    public Value getNamespaceURI() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return StringValue.create(this._streamReader.getNamespaceURI());
    }

    public Value getNodeType() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        int convertedInt = 14;
        if (!this._streamReader.isWhiteSpace()) {
            Integer convertedInteger = _constConvertMap.get(this._streamReader.getEventType());
            convertedInt = convertedInteger;
        }
        return LongValue.create(convertedInt);
    }

    public Value getPrefix() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return StringValue.create(this._streamReader.getPrefix());
    }

    public Value getValue() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        if (this._currentNodeType != 2) {
            return StringValue.create(this._streamReader.getText());
        }
        return StringValue.create(null);
    }

    public Value getXmlLang() {
        if (!this.streamIsOpen()) {
            return NullValue.NULL;
        }
        return StringValue.create("");
    }

    public BooleanValue close() {
        if (!this.streamIsOpen()) {
            return BooleanValue.TRUE;
        }
        try {
            this._streamReader.close();
        }
        catch (XMLStreamException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public Value expand() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue getAttribute(String name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue getAttributeNo(int index) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue getAttributeNS(String localName, String namespaceURI) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue getParserProperty(int property) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue isValid() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue lookupNamespace(String prefix) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue moveToAttribute(String name) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue moveToAttributeNo(int index) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue moveToAttributeNs(String localName, String namespaceURI) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue moveToElement() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue moveToFirstAttribute() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue moveToNextAttribute() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue next(@Optional String localname) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue open(Env env, Path path) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this._streamReader = factory.createXMLStreamReader(path.getNativePath(), path.openRead());
        }
        catch (XMLStreamException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            env.warning(L.l("XML input file '{0}' cannot be opened for reading.", path));
            return BooleanValue.FALSE;
        }
        catch (IOException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            env.warning(L.l("Unable to open source data"));
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    private void updateDepth(Env env) {
        if (this._lastNodeType == 1 && !this._streamReader.isEndElement()) {
            ++this._depth;
        } else if ((this._lastNodeType == 4 || this._lastNodeType == 5) && this._currentNodeType == 2) {
            --this._depth;
        }
    }

    private void updateAttribute(Env env) {
        this._hasAttribute = false;
        String key = this.getName(env).toString() + this._depth;
        if (this._currentNodeType == 1 && this._streamReader.getAttributeCount() > 0) {
            this._startElements.put(key, this._depth);
            this._hasAttribute = true;
        }
        if (this._currentNodeType == 2 && this._startElements.containsKey(key)) {
            this._hasAttribute = true;
            this._startElements.remove(key);
        }
    }

    public BooleanValue read(Env env) {
        if (!this.streamIsOpen(env, "read")) {
            return BooleanValue.FALSE;
        }
        try {
            if (!this._streamReader.hasNext()) {
                return BooleanValue.FALSE;
            }
            this._lastNodeType = this._currentNodeType;
            Value isEmptyElement = this.getIsEmptyElement();
            this._currentNodeType = this._streamReader.next();
            if (isEmptyElement.toBoolean()) {
                return this.read(env);
            }
            if (this._currentNodeType == 6) {
                return this.read(env);
            }
            if (this._currentNodeType == 8) {
                return BooleanValue.FALSE;
            }
            this.updateDepth(env);
            this.updateAttribute(env);
        }
        catch (XMLStreamException ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            env.warning(L.l("Unable to read :" + ex.toString()));
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public LongValue getNextType() {
        return LongValue.create(this._currentNodeType);
    }

    public BooleanValue setParserProperty(int property, boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue setRelaxNGSchema(String filename) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue setRelaxNGSchemaSource(String source) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BooleanValue XML(String source) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    static {
        _constConvertMap.put(10, 2);
        _constConvertMap.put(12, 4);
        _constConvertMap.put(4, 3);
        _constConvertMap.put(5, 8);
        _constConvertMap.put(2, 15);
        _constConvertMap.put(15, 6);
        _constConvertMap.put(9, 5);
        _constConvertMap.put(14, 12);
        _constConvertMap.put(3, 7);
        _constConvertMap.put(6, 13);
        _constConvertMap.put(1, 1);
        _constConvertMap.put(11, 0);
        _constConvertMap.put(8, 0);
        _constConvertMap.put(13, 0);
        _constConvertMap.put(7, 0);
        _constConvertMap.put(0, 0);
        _constConvertMap.put(-1, 0);
        _constConvertMap.put(-1, 9);
        _constConvertMap.put(-1, 10);
        _constConvertMap.put(-1, 11);
        _constConvertMap.put(-1, 10);
        _constConvertMap.put(-1, 17);
    }
}

