/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ServerArrayValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.OutputModule;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.zlib.ZlibInputStream;
import com.caucho.quercus.lib.zlib.ZlibOutputStream;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamImplOutputStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ZlibModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(ZlibModule.class.getName());
    private static final L10N L = new L10N(ZlibModule.class);
    public static final int FORCE_GZIP = 1;
    public static final int FORCE_DEFLATE = 2;
    private int _dbg;

    public String[] getLoadedExtensions() {
        return new String[]{"zlib"};
    }

    @ReturnNullAsFalse
    public static BinaryStream gzopen(Env env, StringValue fileName, String mode, @Optional(value="false") boolean useIncludePath) {
        String filemode = ZlibModule.getFileMode(mode);
        int compressionLevel = ZlibModule.getCompressionLevel(mode);
        int compressionStrategy = ZlibModule.getCompressionStrategy(mode);
        BinaryStream val = FileModule.fopen(env, fileName, mode, useIncludePath, null);
        if (val == null) {
            return null;
        }
        try {
            char ch = filemode.charAt(0);
            if (ch == 'r') {
                BinaryInput is = (BinaryInput)val;
                return new ZlibInputStream(env, is);
            }
            if (ch == 'w') {
                return new ZlibOutputStream(((BinaryOutput)val).getOutputStream(), compressionLevel, compressionStrategy);
            }
            if (ch == 'a') {
                return new ZlibOutputStream(((BinaryOutput)val).getOutputStream(), compressionLevel, compressionStrategy);
            }
            if (ch == 'x') {
                return new ZlibOutputStream(((BinaryOutput)val).getOutputStream(), compressionLevel, compressionStrategy);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
        }
        return null;
    }

    @ReturnNullAsFalse
    public static ArrayValue gzfile(Env env, StringValue fileName, @Optional boolean useIncludePath) {
        BinaryInput is = (BinaryInput)ZlibModule.gzopen(env, fileName, "r", useIncludePath);
        if (is == null) {
            return null;
        }
        try {
            StringValue line;
            ArrayValueImpl result = new ArrayValueImpl();
            while ((line = is.readLine(Integer.MAX_VALUE)) != null && line.length() > 0) {
                ((ArrayValue)result).put(line);
            }
            ArrayValueImpl arrayValueImpl = result;
            return arrayValueImpl;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            is.close();
        }
    }

    public static Value ob_gzhandler(Env env, StringValue buffer, int state) {
        return OutputModule.ob_gzhandler(env, buffer, state);
    }

    public static Value readgzfile(Env env, StringValue fileName, @Optional boolean useIncludePath) {
        BinaryInput is = (BinaryInput)ZlibModule.gzopen(env, fileName, "r", useIncludePath);
        if (is == null) {
            return BooleanValue.FALSE;
        }
        try {
            LongValue longValue = LongValue.create(env.getOut().writeStream(is.getInputStream()));
            return longValue;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            is.close();
        }
    }

    public static int gzwrite(@NotNull BinaryOutput os, InputStream is, @Optional(value="0x7fffffff") int length) {
        if (os == null) {
            return 0;
        }
        try {
            return os.write(is, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public int gzputs(Env env, @NotNull BinaryOutput os, InputStream is, @Optional(value="0x7ffffff") int length) {
        if (os == null) {
            return 0;
        }
        try {
            return os.write(is, length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public boolean gzclose(@NotNull BinaryStream os) {
        if (os == null) {
            return false;
        }
        os.close();
        return true;
    }

    public boolean gzeof(@NotNull BinaryStream binaryStream) {
        if (binaryStream == null) {
            return true;
        }
        return binaryStream.isEOF();
    }

    public static Value gzgetc(Env env, @NotNull BinaryInput is) {
        if (is == null) {
            return BooleanValue.FALSE;
        }
        try {
            int ch = is.read();
            if (ch < 0) {
                return BooleanValue.FALSE;
            }
            StringValue sb = env.createBinaryBuilder(1);
            sb.appendByte(ch);
            return sb;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value gzread(@NotNull BinaryInput is, int length) {
        if (is == null) {
            return BooleanValue.FALSE;
        }
        try {
            return is.read(length);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value gzgets(Env env, @NotNull BinaryInput is, int length) {
        return FileModule.fgets(env, is, length);
    }

    public static Value gzgetss(Env env, @NotNull BinaryInput is, int length, @Optional Value allowedTags) {
        return FileModule.fgetss(env, is, length, allowedTags);
    }

    public boolean gzrewind(@NotNull BinaryStream binaryStream) {
        if (binaryStream == null) {
            return false;
        }
        return binaryStream.setPosition(0L);
    }

    public int gzseek(@NotNull BinaryStream binaryStream, long offset, @Optional(value="FileModule.SEEK_SET") int whence) {
        if (binaryStream == null) {
            return -1;
        }
        if (binaryStream.seek(offset, whence) == -1L) {
            return -1;
        }
        return 0;
    }

    public Value gztell(@NotNull BinaryStream binaryStream) {
        if (binaryStream == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(binaryStream.getPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value gzpassthru(Env env, @NotNull BinaryInput is) {
        WriteStream out = env.getOut();
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buffer = tempBuf.getBuffer();
        int length = 0;
        try {
            int sublen = is.read(buffer, 0, buffer.length);
            while (sublen > 0) {
                out.write(buffer, 0, sublen);
                length += sublen;
                sublen = is.read(buffer, 0, buffer.length);
            }
            LongValue longValue = LongValue.create(length);
            return longValue;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            TempBuffer.free(tempBuf);
        }
    }

    public Value zlib_get_coding_type(Env env) {
        char ch;
        String ini = env.getIniString("zlib.output_compression");
        if (ini == null || ini == "") {
            return BooleanValue.FALSE;
        }
        if (!(ini.equalsIgnoreCase("on") || (ch = ini.charAt(0)) >= '0' && ch <= '9')) {
            return BooleanValue.FALSE;
        }
        ServerArrayValue sav = new ServerArrayValue(env);
        Value val = sav.get(env.createString("HTTP_ACCEPT_ENCODING"));
        if (!val.isset()) {
            return BooleanValue.FALSE;
        }
        String s = val.toString();
        if (s.contains("gzip")) {
            return env.createString("gzip");
        }
        if (s.contains("deflate")) {
            return env.createString("deflate");
        }
        return BooleanValue.FALSE;
    }

    public Value gzcompress(Env env, InputStream data, @Optional(value="6") int level) {
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buffer = tempBuf.getBuffer();
        Deflater deflater = null;
        try {
            deflater = new Deflater(level, true);
            Adler32 crc = new Adler32();
            boolean isFinished = false;
            StringValue out = env.createLargeBinaryBuilder();
            buffer[0] = 120;
            buffer[1] = level <= 1 ? 1 : (level < 6 ? 94 : (level == 6 ? -100 : -38));
            out.append(buffer, 0, 2);
            while (!isFinished) {
                int len;
                while (!isFinished && deflater.needsInput()) {
                    len = data.read(buffer, 0, buffer.length);
                    if (len > 0) {
                        crc.update(buffer, 0, len);
                        deflater.setInput(buffer, 0, len);
                        continue;
                    }
                    isFinished = true;
                    deflater.finish();
                }
                while ((len = deflater.deflate(buffer, 0, buffer.length)) > 0) {
                    out.append(buffer, 0, len);
                }
            }
            long value = crc.getValue();
            buffer[0] = (byte)(value >> 24);
            buffer[1] = (byte)(value >> 16);
            buffer[2] = (byte)(value >> 8);
            buffer[3] = (byte)(value >> 0);
            out.append(buffer, 0, 4);
            StringValue stringValue = out;
            return stringValue;
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
        finally {
            TempBuffer.free(tempBuf);
            if (deflater != null) {
                deflater.end();
            }
        }
    }

    public Value gzuncompress(Env env, InputStream is, @Optional(value="0") long length) {
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buffer = tempBuf.getBuffer();
        InflaterInputStream in = null;
        try {
            int len;
            if (length == 0L) {
                length = Long.MAX_VALUE;
            }
            in = new InflaterInputStream(is);
            StringValue sb = env.createLargeBinaryBuilder();
            while ((len = in.read(buffer, 0, buffer.length)) >= 0) {
                sb.append(buffer, 0, len);
            }
            StringValue stringValue = sb;
            return stringValue;
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
        finally {
            TempBuffer.free(tempBuf);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Value gzdeflate(Env env, InputStream data, @Optional(value="6") int level) {
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buffer = tempBuf.getBuffer();
        Deflater deflater = null;
        try {
            deflater = new Deflater(level, true);
            boolean isFinished = false;
            TempStream out = new TempStream();
            while (!isFinished) {
                int len;
                if (!isFinished && deflater.needsInput()) {
                    len = data.read(buffer, 0, buffer.length);
                    if (len > 0) {
                        deflater.setInput(buffer, 0, len);
                    } else {
                        isFinished = true;
                        deflater.finish();
                    }
                }
                while ((len = deflater.deflate(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, len, false);
                }
            }
            deflater.end();
            StringValue stringValue = env.createBinaryString(out.getHead());
            return stringValue;
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
        finally {
            TempBuffer.free(tempBuf);
            if (deflater != null) {
                deflater.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value gzinflate(Env env, InputStream data, @Optional(value="0") int length) {
        if (length <= 0) {
            length = Integer.MAX_VALUE;
        }
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buffer = tempBuf.getBuffer();
        Inflater inflater = null;
        try {
            inflater = new Inflater(true);
            StringValue sb = env.createBinaryBuilder();
            block7: while (true) {
                int sublen = Math.min(length, buffer.length);
                if ((sublen = data.read(buffer, 0, sublen)) <= 0) break;
                inflater.setInput(buffer, 0, sublen);
                length -= sublen;
                while (true) {
                    int inflatedLength;
                    if ((inflatedLength = inflater.inflate(buffer, 0, sublen)) <= 0) continue block7;
                    sb.append(buffer, 0, inflatedLength);
                }
                break;
            }
            StringValue stringValue = sb;
            return stringValue;
        }
        catch (OutOfMemoryError e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        catch (Exception e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            TempBuffer.free(tempBuf);
            if (inflater != null) {
                inflater.end();
            }
        }
    }

    public Value gzencode(Env env, InputStream is, @Optional(value="6") int level, @Optional(value="1") int encodingMode) {
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buffer = tempBuf.getBuffer();
        TempStream ts = new TempStream();
        StreamImplOutputStream out = new StreamImplOutputStream(ts);
        ZlibOutputStream gzOut = null;
        try {
            int len;
            gzOut = new ZlibOutputStream(out, level, 0, encodingMode);
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                gzOut.write(buffer, 0, len);
            }
            gzOut.close();
            StringValue sb = env.createBinaryBuilder();
            for (TempBuffer ptr = ts.getHead(); ptr != null; ptr = ptr.getNext()) {
                sb.append(ptr.getBuffer(), 0, ptr.getLength());
            }
            StringValue stringValue = sb;
            return stringValue;
        }
        catch (IOException e) {
            throw QuercusModuleException.create(e);
        }
        finally {
            TempBuffer.free(tempBuf);
            ts.destroy();
            if (gzOut != null) {
                gzOut.close();
            }
        }
    }

    private static String getFileMode(String input) {
        String modifier = "";
        String filemode = input.substring(0, 1);
        block7: for (int i = 1; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case 'r': {
                    filemode = "r";
                    continue block7;
                }
                case 'w': {
                    filemode = "w";
                    continue block7;
                }
                case 'a': {
                    filemode = "a";
                    continue block7;
                }
                case 'b': {
                    modifier = "b";
                    continue block7;
                }
                case 't': {
                    modifier = "t";
                }
            }
        }
        return filemode + modifier;
    }

    private static int getCompressionLevel(String input) {
        for (int i = input.length() - 1; i >= 0; --i) {
            char ch = input.charAt(i);
            if (ch < '0' || ch > '9') continue;
            return ch - 48;
        }
        return -1;
    }

    private static int getCompressionStrategy(String input) {
        for (int i = input.length() - 1; i >= 0; --i) {
            char ch = input.charAt(i);
            switch (ch) {
                case 'f': {
                    return 1;
                }
                case 'h': {
                    return 2;
                }
            }
        }
        return 0;
    }
}

