/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.WriteStreamOutput;
import com.caucho.quercus.marshal.Marshal;
import java.io.OutputStream;

public class BinaryOutputMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BinaryOutputMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryOutput) {
            return (BinaryOutput)((Object)value);
        }
        Object javaObj = value.toJavaObject();
        if (javaObj instanceof BinaryOutput) {
            return (BinaryOutput)javaObj;
        }
        if (javaObj instanceof OutputStream) {
            return new WriteStreamOutput((OutputStream)javaObj);
        }
        throw new IllegalStateException(L.l("Cannot marshal {0} to BinaryOutput", javaObj));
    }

    public static BinaryOutput marshal(Env env, Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryOutput) {
            return (BinaryOutput)((Object)value);
        }
        Object javaObj = value.toJavaObject();
        if (javaObj instanceof BinaryOutput) {
            return (BinaryOutput)javaObj;
        }
        if (javaObj instanceof OutputStream) {
            return new WriteStreamOutput((OutputStream)javaObj);
        }
        throw new IllegalStateException(L.l("Cannot marshal {0} to BinaryOutput", javaObj));
    }

    public Value unmarshal(Env env, Object value) {
        return (Value)value;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaValue && OutputStream.class.isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return BinaryOutput.class;
    }
}

