/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class CallableMarshal
extends Marshal {
    public static final Marshal MARSHAL = new CallableMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        Callable callable = value.toCallable(env);
        return callable;
    }

    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException();
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof CallbackFunction) {
            return 0;
        }
        if (argValue.isString()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Callback.class;
    }
}

