/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaListAdapter;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.marshal.JavaMarshal;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import java.util.List;

public class JavaListMarshal
extends JavaMarshal {
    private static final L10N L = new L10N(JavaMarshal.class);

    public JavaListMarshal(JavaClassDef def, boolean isNotNull) {
        this(def, isNotNull, false);
    }

    public JavaListMarshal(JavaClassDef def, boolean isNotNull, boolean isUnmarshalNullAsFalse) {
        super(def, isNotNull, isUnmarshalNullAsFalse);
    }

    public Object marshal(Env env, Value value, Class argClass) {
        if (!value.isset()) {
            if (this._isNotNull) {
                env.warning(L.l("null is an unexpected argument, expected {0}", JavaListMarshal.shortName(argClass)));
            }
            return null;
        }
        List<?> obj = value.toJavaList(env, argClass);
        if (obj == null) {
            if (this._isNotNull) {
                env.warning(L.l("null is an unexpected argument, expected {0}", JavaListMarshal.shortName(argClass)));
            }
            return null;
        }
        if (!argClass.isAssignableFrom(obj.getClass())) {
            env.warning(L.l("'{0}' of type '{1}' is an unexpected argument, expected {2}", value, JavaListMarshal.shortName(value.getClass()), JavaListMarshal.shortName(argClass)));
            return null;
        }
        return obj;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaListAdapter && this.getExpectedClass().isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        if (argValue.isArray()) {
            return 300;
        }
        return 400;
    }
}

