/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.page;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuercusPage {
    private static final L10N L = new L10N(QuercusPage.class);
    private HashMap<String, AbstractFunction> _funMap = new HashMap();
    private HashMap<String, AbstractFunction> _funMapLowerCase = new HashMap();
    private HashMap<String, ClassDef> _classMap = new HashMap();
    private QuercusPage _profilePage;

    public boolean isModified() {
        return false;
    }

    public QuercusPage getCompiledPage() {
        return null;
    }

    public String getUserPath() {
        return null;
    }

    public QuercusPage getProfilePage() {
        return this._profilePage;
    }

    public void setProfilePage(QuercusPage profilePage) {
        this._profilePage = profilePage;
    }

    public abstract Path getSelfPath(Env var1);

    public AbstractFunction findFunction(String name) {
        AbstractFunction fun = this._funMap.get(name);
        if (fun != null) {
            return fun;
        }
        fun = this._funMapLowerCase.get(name.toLowerCase());
        return fun;
    }

    public ClassDef findClass(String name) {
        return this._classMap.get(name);
    }

    public HashMap<String, ClassDef> getClassMap() {
        return this._classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value executeTop(Env env) {
        QuercusPage compile = this.getCompiledPage();
        Path oldPwd = env.getPwd();
        Path pwd = this.getPwd(env);
        env.setPwd(pwd);
        try {
            if (compile != null) {
                Value value = compile.executeTop(env);
                return value;
            }
            Value value = this.execute(env);
            return value;
        }
        catch (QuercusLanguageException e) {
            if (env.getExceptionHandler() != null) {
                try {
                    env.getExceptionHandler().call(env, e.getValue());
                }
                catch (QuercusLanguageException e2) {
                    this.uncaughtExceptionError(env, e2);
                }
            } else {
                this.uncaughtExceptionError(env, e);
            }
            NullValue nullValue = NullValue.NULL;
            return nullValue;
        }
        finally {
            env.setPwd(oldPwd);
        }
    }

    private void uncaughtExceptionError(Env env, QuercusLanguageException e) {
        Location location = e.getLocation(env);
        String type = e.getValue().getClassName();
        String message = e.getMessage(env);
        env.error(location, L.l("Uncaught exception of type '{0}' with message '{1}'", (Object)type, message));
    }

    public Path getPwd(Env env) {
        return this.getSelfPath(env).getParent();
    }

    public abstract Value execute(Env var1);

    public void init(QuercusContext quercus) {
    }

    public void init(Env env) {
    }

    public void importDefinitions(Env env) {
        for (Map.Entry<String, AbstractFunction> entry : this._funMap.entrySet()) {
            AbstractFunction fun = entry.getValue();
            if (!fun.isGlobal()) continue;
            env.addFunction(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this._classMap.entrySet()) {
            env.addClassDef(entry.getKey(), (ClassDef)entry.getValue());
        }
    }

    protected void addFunction(String name, AbstractFunction fun) {
        AbstractFunction oldFun = this._funMap.put(name, fun);
        this._funMapLowerCase.put(name.toLowerCase(), fun);
    }

    protected void addClass(String name, ClassDef cl) {
        this._classMap.put(name, cl);
    }

    public boolean setRuntimeFunction(AbstractFunction[] funList) {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

