/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.parser;

import com.caucho.quercus.Location;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.Scope;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalScope
extends Scope {
    private static final L10N L = new L10N(GlobalScope.class);
    private ExprFactory _exprFactory;
    private HashMap<String, Function> _functionMap = new HashMap();
    private ArrayList<Function> _functionList = new ArrayList();
    private HashMap<String, Function> _conditionalFunctionMap = new HashMap();
    private HashMap<String, InterpretedClassDef> _classMap = new HashMap();
    private ArrayList<InterpretedClassDef> _classList = new ArrayList();
    private HashMap<String, InterpretedClassDef> _conditionalClassMap = new HashMap();

    GlobalScope(ExprFactory exprFactory) {
        this._exprFactory = exprFactory;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public void addFunction(String name, Function function, boolean isTop) {
        if (isTop) {
            this._functionMap.put(name.toLowerCase(), function);
        }
        this._functionList.add(function);
    }

    @Override
    protected void addConditionalFunction(String name, Function function) {
        this._conditionalFunctionMap.put(name, function);
    }

    @Override
    public InterpretedClassDef addClass(Location location, String name, String parentName, ArrayList<String> ifaceList, int index, boolean isTop) {
        InterpretedClassDef cl = null;
        if (isTop) {
            cl = this._classMap.get(name);
        }
        if (cl == null) {
            String[] ifaceArray = new String[ifaceList.size()];
            ifaceList.toArray(ifaceArray);
            cl = this._exprFactory.createClassDef(location, name, parentName, ifaceArray, index);
            if (isTop) {
                cl.setTopScope(true);
                this._classMap.put(name, cl);
            }
        } else {
            cl = this._exprFactory.createClassDef(location, name, parentName, new String[0], index);
        }
        this._classList.add(cl);
        return cl;
    }

    @Override
    protected void addConditionalClass(InterpretedClassDef def) {
        this._classList.add(def);
    }

    public HashMap<String, Function> getFunctionMap() {
        return this._functionMap;
    }

    public ArrayList<Function> getFunctionList() {
        return this._functionList;
    }

    public HashMap<String, Function> getConditionalFunctionMap() {
        return this._conditionalFunctionMap;
    }

    public HashMap<String, InterpretedClassDef> getClassMap() {
        return this._classMap;
    }

    public ArrayList<InterpretedClassDef> getClassList() {
        return this._classList;
    }

    public HashMap<String, InterpretedClassDef> getConditionalClassMap() {
        return this._conditionalClassMap;
    }
}

