/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.L10N;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassDef {
    private static final L10N L = new L10N(ClassDef.class);
    private final Location _location;
    private final String _name;
    private final String _parentName;
    private String[] _ifaceList;

    protected ClassDef(Location location, String name, String parentName, String[] ifaceList) {
        this._location = location;
        this._name = name;
        this._parentName = parentName;
        this._ifaceList = ifaceList;
    }

    public Location getLocation() {
        return this._location;
    }

    public String getName() {
        return this._name;
    }

    public String getParentName() {
        return this._parentName;
    }

    public String getExtension() {
        return null;
    }

    protected void addInterface(String iface) {
        for (int i = 0; i < this._ifaceList.length; ++i) {
            if (!this._ifaceList[i].equals(iface)) continue;
            return;
        }
        String[] ifaceList = new String[this._ifaceList.length + 1];
        System.arraycopy(this._ifaceList, 0, ifaceList, 0, this._ifaceList.length);
        ifaceList[ifaceList.length - 1] = iface;
        this._ifaceList = ifaceList;
    }

    public ClassDef loadClassDef() {
        return this;
    }

    public AbstractFunction getCall() {
        return null;
    }

    public void init() {
    }

    public void init(QuercusClass cl) {
    }

    public String[] getInterfaces() {
        return this._ifaceList;
    }

    public void addInterfaces(HashSet<String> interfaceSet) {
        interfaceSet.add(this.getName().toLowerCase());
        for (String name : this.getInterfaces()) {
            interfaceSet.add(name.toLowerCase());
        }
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean hasNonPublicMethods() {
        return false;
    }

    public void initClass(QuercusClass cl) {
    }

    public ObjectValue newInstance(Env env, QuercusClass qcl) {
        if (this.isAbstract()) {
            throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", this.getName()));
        }
        if (this.isInterface()) {
            throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", this.getName()));
        }
        return new ObjectExtValue(qcl);
    }

    public ObjectValue createObject(Env env, QuercusClass cls) {
        if (this.isAbstract()) {
            throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", this.getName()));
        }
        if (this.isInterface()) {
            throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", this.getName()));
        }
        return new ObjectExtValue(cls);
    }

    public Value callNew(Env env, Expr[] args) {
        return null;
    }

    public Value callNew(Env env, Value[] args) {
        return null;
    }

    public boolean isA(String name) {
        if (this._name.equalsIgnoreCase(name)) {
            return true;
        }
        for (int i = 0; i < this._ifaceList.length; ++i) {
            if (!this._ifaceList[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public abstract AbstractFunction findConstructor();

    public Expr findConstant(String name) {
        return null;
    }

    public String getComment() {
        return null;
    }

    public String getFieldComment(StringValue name) {
        return null;
    }

    public String getStaticFieldComment(String name) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._name + "]";
    }

    public Set<Map.Entry<StringValue, FieldEntry>> fieldSet() {
        return null;
    }

    public Set<Map.Entry<String, StaticFieldEntry>> staticFieldSet() {
        return null;
    }

    public Set<Map.Entry<String, AbstractFunction>> functionSet() {
        return null;
    }

    public static class StaticFieldEntry {
        private final Expr _value;
        private final String _comment;

        public StaticFieldEntry(Expr value) {
            this._value = value;
            this._comment = null;
        }

        public StaticFieldEntry(Expr value, String comment) {
            this._value = value;
            this._comment = comment;
        }

        public Expr getValue() {
            return this._value;
        }

        public String getComment() {
            return this._comment;
        }
    }

    public static class FieldEntry {
        private final Expr _value;
        private final FieldVisibility _visibility;
        private final String _comment;

        public FieldEntry(Expr value, FieldVisibility visibility) {
            this._value = value;
            this._visibility = visibility;
            this._comment = null;
        }

        public FieldEntry(Expr value, FieldVisibility visibility, String comment) {
            this._value = value;
            this._visibility = visibility;
            this._comment = comment;
        }

        public Expr getValue() {
            return this._value;
        }

        public FieldVisibility getVisibility() {
            return this._visibility;
        }

        public String getComment() {
            return this._comment;
        }
    }
}

