/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.script;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.script.QuercusCompiledScript;
import com.caucho.quercus.script.QuercusScriptEngineFactory;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReaderStream;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.WriterStreamImpl;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class QuercusScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private QuercusScriptEngineFactory _factory;
    private final QuercusContext _quercus;

    QuercusScriptEngine(QuercusScriptEngineFactory factory) {
        this(factory, QuercusScriptEngine.createQuercus());
    }

    public QuercusScriptEngine(QuercusScriptEngineFactory factory, QuercusContext quercus) {
        this._factory = factory;
        this._quercus = quercus;
    }

    private static QuercusContext createQuercus() {
        QuercusContext quercus = new QuercusContext();
        quercus.init();
        quercus.start();
        return quercus;
    }

    public QuercusContext getQuercus() {
        return this._quercus;
    }

    public Object eval(Reader script, ScriptContext cxt) throws ScriptException {
        Env env = null;
        try {
            WriteStream out;
            ReadStream reader = ReaderStream.open(script);
            QuercusProgram program = QuercusParser.parse(this._quercus, null, reader);
            Writer writer = cxt.getWriter();
            if (writer != null) {
                WriterStreamImpl s = new WriterStreamImpl();
                s.setWriter(writer);
                WriteStream os = new WriteStream(s);
                os.setNewlineString("\n");
                try {
                    os.setEncoding("iso-8859-1");
                }
                catch (Exception e) {
                    // empty catch block
                }
                out = os;
            } else {
                out = new NullWriteStream();
            }
            InterpretedPage page = new InterpretedPage(program);
            env = new Env(this._quercus, page, out, null, null);
            env.setScriptContext(cxt);
            env.start();
            Object result = null;
            try {
                Value value = program.execute(env);
                if (value != null) {
                    result = value.toJavaObject();
                }
            }
            catch (QuercusExitException e) {
                // empty catch block
            }
            out.flushBuffer();
            out.free();
            writer.flush();
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (env != null) {
                env.close();
            }
        }
    }

    public Object eval(String script, ScriptContext cxt) throws ScriptException {
        return this.eval((Reader)new StringReader(script), cxt);
    }

    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            ReadStream reader = ReaderStream.open(script);
            QuercusProgram program = QuercusParser.parse(this._quercus, null, reader);
            return new QuercusCompiledScript(this, program);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    public QuercusScriptEngineFactory getFactory() {
        return this._factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public String toString() {
        return "QuercusScriptEngine[]";
    }
}

