/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.statement.Statement;

public class ClassStaticStatement
extends Statement {
    protected final String _className;
    protected final VarExpr _var;
    protected final Expr _initValue;
    protected StringValue _staticName;

    public ClassStaticStatement(Location location, String className, VarExpr var, Expr initValue) {
        super(location);
        this._className = className;
        this._var = var;
        this._initValue = initValue;
    }

    public Value execute(Env env) {
        try {
            if (this._staticName == null) {
                this._staticName = env.createStaticName();
            }
            StringValue staticName = this._staticName;
            Value qThis = env.getThis();
            QuercusClass qClass = qThis.getQuercusClass();
            String className = qClass.getName();
            Var var = env.getStaticVar(env.createString(className + "::" + staticName));
            env.setVar(this._var.getName(), var);
            if (!var.isset() && this._initValue != null) {
                var.set(this._initValue.eval(env));
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }
}

