/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote;

import com.caucho.bam.ActorStream;
import com.caucho.bam.Broker;
import com.caucho.config.Admin;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.hemp.broker.HempMemoryQueue;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.hemp.servlet.ServerLinkActor;
import com.caucho.hmtp.HmtpReader;
import com.caucho.hmtp.HmtpWriter;
import com.caucho.security.Authenticator;
import com.caucho.server.cluster.Server;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.servlet.WebSocketContext;
import com.caucho.servlet.WebSocketListener;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HmtpServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(HmtpServlet.class.getName());
    private static final L10N L = new L10N(HmtpServlet.class);
    private boolean _isAdmin;
    private boolean _isAuthenticationRequired = true;
    @Inject
    private Instance<Authenticator> _authInstance;
    @Inject
    @Admin
    private Instance<Authenticator> _adminInstance;
    private Broker _broker;
    private Authenticator _auth;
    private ServerAuthManager _authManager;

    public void setAdmin(boolean isAdmin) {
        this._isAdmin = isAdmin;
    }

    public void setAuthenticationRequired(boolean isAuthRequired) {
        this._isAuthenticationRequired = isAuthRequired;
    }

    public boolean isAuthenticationRequired() {
        return this._isAuthenticationRequired;
    }

    public void init() {
        String admin;
        String authRequired = this.getInitParameter("authentication-required");
        if ("false".equals(authRequired)) {
            this._isAuthenticationRequired = false;
        }
        if ("true".equals(admin = this.getInitParameter("admin"))) {
            this._isAdmin = true;
        }
        try {
            this._auth = this._isAdmin ? (Authenticator)this._adminInstance.get() : (Authenticator)this._authInstance.get();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("{0} requires an active com.caucho.security.Authenticator because HMTP messaging requires authenticated login for security.", (Object)this), e);
            }
            log.info(L.l("{0} requires an active com.caucho.security.Authenticator because HMTP messaging requires authenticated login for security.  In the resin.xml, add an <sec:AdminAuthenticator>", (Object)this));
        }
        this._authManager = new ServerAuthManager();
        this._authManager.setAuthenticationRequired(this._isAuthenticationRequired);
        this._broker = this._isAdmin ? Server.getCurrent().getAdminBroker() : HempBroker.getCurrent();
        log.fine(L.l("{0} starting with broker={1}", (Object)this, this._broker));
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequestImpl req = (HttpServletRequestImpl)request;
        HttpServletResponseImpl res = (HttpServletResponseImpl)response;
        String upgrade = req.getHeader("Upgrade");
        if (!"WebSocket".equals(upgrade)) {
            res.sendError(400, "Upgrade denied:" + upgrade);
            return;
        }
        String ipAddress = req.getRemoteAddr();
        WebSocketHandler handler = new WebSocketHandler(ipAddress);
        WebSocketContext webSocket = req.startWebSocket(handler);
        webSocket.setTimeout(1800000L);
    }

    class WebSocketHandler
    implements WebSocketListener {
        private String _ipAddress;
        private HmtpReader _in;
        private HmtpWriter _out;
        private ActorStream _linkStream;
        private ActorStream _brokerStream;
        private ServerLinkActor _linkService;

        WebSocketHandler(String ipAddress) {
            this._ipAddress = ipAddress;
        }

        public void onStart(WebSocketContext context) throws IOException {
            this._in = new HmtpReader(context.getInputStream());
            this._out = new HmtpWriter(context.getOutputStream());
            this._linkStream = new HempMemoryQueue(this._out, HmtpServlet.this._broker.getBrokerStream(), 1);
            this._linkService = new ServerLinkActor(this._linkStream, HmtpServlet.this._broker, HmtpServlet.this._authManager, this._ipAddress, false);
            this._brokerStream = this._linkService.getBrokerStream();
        }

        public void onComplete(WebSocketContext context) throws IOException {
            this._brokerStream.close();
            this._linkService.close();
        }

        public void onRead(WebSocketContext context) throws IOException {
            InputStream is = context.getInputStream();
            while (this._in.readPacket(this._brokerStream) && is.available() > 0) {
            }
        }

        public void onTimeout(WebSocketContext context) throws IOException {
        }
    }
}

