/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;

public class WebSocketInputStream
extends InputStream {
    private static final L10N L = new L10N(WebSocketInputStream.class);
    private InputStream _is;
    private int _code;
    private int _offset;
    private int _length;

    public WebSocketInputStream() {
    }

    public WebSocketInputStream(InputStream is) throws IOException {
        this.init(is);
    }

    public void init(InputStream is) throws IOException {
        this._is = is;
        this.readChunkLength();
    }

    public int getCode() {
        return this._code;
    }

    public int getLength() {
        return this._length;
    }

    public int read() throws IOException {
        InputStream is = this._is;
        if (is == null) {
            return -1;
        }
        if (this._length <= this._offset && !this.readChunkLength()) {
            return -1;
        }
        int ch = is.read();
        ++this._offset;
        return ch;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        InputStream is = this._is;
        if (this._length <= this._offset && !this.readChunkLength()) {
            return -1;
        }
        int sublen = this._length - this._offset;
        if (sublen <= 0 || is == null) {
            return -1;
        }
        if (length < sublen) {
            sublen = length;
        }
        if ((sublen = is.read(buffer, offset, sublen)) > 0) {
            this._offset += sublen;
            return sublen;
        }
        this.close();
        return -1;
    }

    protected boolean readChunkLength() throws IOException {
        InputStream is = this._is;
        if (is == null) {
            return false;
        }
        int ch = is.read();
        if ((ch & 0x80) != 128) {
            throw new IOException(L.l("{0}: expected 0x80 at '0x{1}' because WebSocket binary protocol expects 0x80 at beginning", (Object)this, Integer.toHexString(ch & 0xFFFF)));
        }
        this._code = ch;
        int length = 0;
        do {
            ch = is.read();
            length = (length << 7) + (ch & 0x7F);
        } while ((ch & 0x80) == 128);
        this._length = length;
        this._offset = 0;
        if (length == 0) {
            this.close();
        }
        return length > 0;
    }

    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
    }
}

