/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class WebSocketReader
extends Reader {
    private static final L10N L = new L10N(WebSocketReader.class);
    private InputStream _is;

    public WebSocketReader() {
    }

    public WebSocketReader(InputStream is) throws IOException {
        this.init(is);
    }

    public void init(InputStream is) throws IOException {
        this._is = is;
        int ch = is.read();
        if (ch != 0) {
            throw new IOException(L.l("{0}: expected 0x00 at '0x{1}' because WebSocket protocol expects 0x00 at beginning", (Object)this, Integer.toHexString(ch & 0xFFFF)));
        }
    }

    public int read() throws IOException {
        InputStream is = this._is;
        if (is == null) {
            return -1;
        }
        int ch = is.read();
        if (ch == 255 || ch < 0) {
            this._is = null;
            return -1;
        }
        if (ch < 128) {
            return ch;
        }
        if ((ch & 0xE0) == 192) {
            int ch2 = is.read();
            if (ch2 < 0) {
                this._is = null;
                return -1;
            }
            return ((ch & 0x1F) << 6) + (ch2 & 0x7F);
        }
        if ((ch & 0xF0) == 224) {
            int ch2 = is.read();
            int ch3 = is.read();
            if (ch2 < 0) {
                this._is = null;
                return -1;
            }
            return ((ch & 0xF) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F);
        }
        return 65279;
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        int ch;
        int start = offset;
        int end = offset + length;
        while (offset < end && (ch = this.read()) >= 0) {
            buffer[offset] = (char)ch;
            ++offset;
        }
        if (start == offset) {
            return -1;
        }
        return offset - start;
    }

    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
    }
}

