/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.cloud.network.NetworkListenService;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.resin.PortEmbed;
import com.caucho.server.cluster.Server;
import com.caucho.server.http.HttpProtocol;

public class HttpEmbed
extends PortEmbed {
    private SocketLinkListener _port;

    public HttpEmbed() {
    }

    public HttpEmbed(int port) {
        this.setPort(port);
    }

    public HttpEmbed(int port, String ipAddress) {
        this.setPort(port);
        this.setAddress(ipAddress);
    }

    public int getLocalPort() {
        if (this._port != null) {
            return this._port.getLocalPort();
        }
        return this.getPort();
    }

    public void bindTo(Server server) {
        try {
            this._port = new SocketLinkListener();
            this._port.setProtocol(new HttpProtocol());
            this._port.setPort(this.getPort());
            this._port.setAddress(this.getAddress());
            this._port.init();
            ResinSystem system = server.getResinSystem();
            NetworkListenService listenService = system.getService(NetworkListenService.class);
            listenService.addListener(this._port);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

