/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Period;
import com.caucho.rewrite.AbstractTargetDispatchRule;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.servlets.FastCGIServlet;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@Configurable
public class FastCgiProxy
extends AbstractTargetDispatchRule {
    private FastCGIServlet _proxyServlet = new FastCGIServlet();
    private ServletConfigImpl _servlet = new ServletConfigImpl();

    public FastCgiProxy() {
        this._servlet.setServletName("resin-dispatch-lb");
        this._servlet.setServlet((Servlet)this._proxyServlet);
    }

    @Configurable
    public void addAddress(String address) {
        this._proxyServlet.addAddress(address);
    }

    @Configurable
    public void setFailRecoverTime(Period period) {
        this._proxyServlet.setFailRecoverTime(period);
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            WebApp webApp = WebApp.getCurrent();
            this._proxyServlet.init(webApp);
            if (webApp != null) {
                webApp.addServlet(this._servlet);
            }
        }
        catch (ServletException ex) {
            throw ConfigException.create(ex);
        }
    }

    public FilterChain createDispatch(DispatcherType type, String uri, String queryString, String target, FilterChain next) {
        try {
            return new ProxyFilterChain(this._servlet.createServletChain(), uri, queryString);
        }
        catch (ServletException e) {
            throw ConfigException.create(e);
        }
    }

    public static class ProxyRequest
    extends HttpServletRequestWrapper {
        private String _uri;
        private String _queryString;

        ProxyRequest(ServletRequest req, String uri, String queryString) {
            super((HttpServletRequest)req);
            this._uri = uri;
            this._queryString = queryString;
        }

        public String getRequestURI() {
            return this._uri;
        }

        public String getQueryString() {
            return this._queryString;
        }
    }

    public static class ProxyFilterChain
    implements FilterChain {
        private final FilterChain _next;
        private final String _uri;
        private final String _queryString;

        ProxyFilterChain(FilterChain next, String uri, String queryString) {
            this._next = next;
            this._uri = uri;
            this._queryString = queryString;
        }

        public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
            this._next.doFilter((ServletRequest)new ProxyRequest(req, this._uri, this._queryString), res);
        }
    }
}

