/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.L10N;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfHeader
implements RequestPredicate {
    private static final L10N L = new L10N(IfHeader.class);
    private String _name;
    private Pattern _regexp;

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    @Configurable
    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public void setValue(Pattern regexp) {
        this.setRegexp(regexp);
    }

    @PostConstruct
    public void init() {
        if (this._name == null) {
            throw new ConfigException(L.l("'name' is a required attribute for {0}", this.getClass().getSimpleName()));
        }
    }

    public boolean isMatch(HttpServletRequest request) {
        String value = request.getHeader(this._name);
        if (value != null) {
            return this._regexp == null || this._regexp.matcher(value).find();
        }
        return false;
    }
}

