/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.L10N;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfLocale
implements RequestPredicate {
    private static final L10N L = new L10N(IfLocale.class);
    private Pattern _regexp;

    @Configurable
    public void setValue(Pattern regexp) {
        this._regexp = regexp;
    }

    @PostConstruct
    public void init() {
        if (this._regexp == null) {
            throw new ConfigException(L.l("'value' is a required attribute for {0}", this.getClass().getSimpleName()));
        }
    }

    public boolean isMatch(HttpServletRequest request) {
        Locale locale = request.getLocale();
        if (locale == null) {
            return false;
        }
        return this._regexp.matcher(locale.toString()).find();
    }
}

