/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Service;
import com.caucho.distcache.AbstractCache;
import com.caucho.distcache.ClusterCache;
import com.caucho.security.SingleSignon;
import java.security.Principal;
import javax.annotation.PostConstruct;

@Service
public class ClusterSingleSignon
implements SingleSignon {
    private AbstractCache _cache;

    public ClusterSingleSignon() {
        this("resin:single-signon");
    }

    public ClusterSingleSignon(String name) {
        this._cache = AbstractCache.getMatchingCache("resin:single-signon:" + name);
        if (this._cache == null) {
            this._cache = new ClusterCache();
            this._cache.setExpireTimeoutMillis(86400000L);
            this._cache.setName("resin:single-signon:" + name);
            this._cache.init();
        }
    }

    public void setName(String name) {
        this._cache.setName("resin:single-signon:" + name);
    }

    @PostConstruct
    public void init() {
        this._cache.init();
    }

    public Principal get(String id) {
        return (Principal)this._cache.get(id);
    }

    public void put(String id, Principal user) {
        this._cache.put(id, user);
    }

    public boolean remove(String id) {
        this._cache.remove(id);
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cache + "]";
    }
}

