/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.security.AbstractCookieAuthenticator;
import com.caucho.security.AuthenticatedUser;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordCredentials;
import com.caucho.security.PasswordUser;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.security.CachingPrincipal;
import com.caucho.util.L10N;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;

public class DatabaseAuthenticator
extends AbstractCookieAuthenticator {
    private static final Logger log = Logger.getLogger(DatabaseAuthenticator.class.getName());
    private static final L10N L = new L10N(DatabaseAuthenticator.class);
    private DataSource _dataSource;
    private String _passwordQuery = "SELECT password FROM LOGIN WHERE username=?";
    private String _cookieUpdate = "UPDATE LOGIN SET cookie=? WHERE username=?";
    private String _cookieQuery = "SELECT username FROM LOGIN where cookie=?";
    private boolean _cookieLogout;
    private String _roleQuery;
    protected boolean _useCookie;
    private String _authCookieName = "resinauthid";
    protected int _cookieVersion = -1;
    protected String _cookieDomain;
    protected long _cookieMaxAge = 31536000000L;

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getPasswordQuery() {
        return this._passwordQuery;
    }

    public void setPasswordQuery(String query) {
        this._passwordQuery = query;
    }

    public String getCookieAuthQuery() {
        return this._cookieQuery;
    }

    public void setCookieAuthQuery(String query) {
        this._cookieQuery = query;
    }

    public String getCookieAuthUpdate() {
        return this._cookieUpdate;
    }

    public void setCookieAuthUpdate(String query) {
        this._cookieUpdate = query;
    }

    public void setCookieLogout(boolean cookieLogout) {
        this._cookieLogout = cookieLogout;
    }

    public String getRoleQuery() {
        return this._roleQuery;
    }

    public void setRoleQuery(String query) {
        this._roleQuery = query;
    }

    public boolean getUseCookie() {
        return this._useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this._useCookie = useCookie;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int version) {
        this._cookieVersion = version;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this._cookieDomain = cookieDomain;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(Period cookieMaxAge) {
        this._cookieMaxAge = cookieMaxAge.getPeriod();
    }

    @PostConstruct
    public void init() throws ServletException {
        super.init();
        if (this._dataSource == null) {
            throw new ConfigException(L.l("JdbcAuthenticator requires a 'data-source' attribute, because it depends on a JDBC database"));
        }
        int i = this._passwordQuery.indexOf(63);
        if (i < 0) {
            throw new ConfigException(L.l("'password-query' expects a parameter"));
        }
        if (this._cookieQuery != null && (i = this._cookieQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'cookie-auth-query' expects a parameter"));
        }
        if (this._cookieUpdate != null) {
            i = this._cookieUpdate.indexOf(63);
            if (i < 0) {
                throw new ConfigException(L.l("'cookie-auth-update' expects two parameters for the cookie id and the user id."));
            }
            int j = this._cookieUpdate.indexOf(63, i + 1);
            if (j < 0) {
                throw new ConfigException(L.l("'cookie-auth-update' expects two parameters"));
            }
        }
        if (this._cookieUpdate != null && this._cookieQuery == null) {
            throw new ServletConfigException(L.l("<cookie-auth-update> expects 'cookie-query' because both update and select queries are needed."));
        }
        if (this._roleQuery != null && (i = this._roleQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'role-query' expects a parameter"));
        }
    }

    protected Principal authenticate(Principal principal, PasswordCredentials cred, Object details) {
        char[] password = cred.getPassword();
        char[] digest = this.getPasswordDigest(principal.getName(), password);
        return this.authenticate(principal.getName(), new String(digest), (HttpServletRequest)details);
    }

    public Principal authenticate(String username, String password, HttpServletRequest request) {
        Principal user = this.loginImpl(username, password);
        if (this._cookieQuery == null || user == null) {
            return user;
        }
        String cookieAuth = (String)request.getAttribute("j_use_cookie_auth");
        if (cookieAuth == null) {
            cookieAuth = request.getParameter("j_use_cookie_auth");
        }
        if ("true".equals(cookieAuth) || "on".equals(cookieAuth) || this._useCookie && cookieAuth == null) {
            this.addAuthCookie(user, request);
        }
        return user;
    }

    public boolean isCookieSupported(String jUseCookieAuth) {
        if (this._cookieQuery == null) {
            return false;
        }
        if ("false".equals(jUseCookieAuth) || "off".equals(jUseCookieAuth)) {
            return false;
        }
        if (this._useCookie) {
            return true;
        }
        return "true".equals(jUseCookieAuth) || "on".equals(jUseCookieAuth);
    }

    protected void addAuthCookie(Principal user, HttpServletRequest request) {
    }

    /*
     * Loose catch block
     */
    public Principal loginImpl(String username, String password) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block39: {
            block35: {
                conn = null;
                stmt = null;
                rs = null;
                conn = this._dataSource.getConnection();
                stmt = conn.prepareStatement(this._passwordQuery);
                stmt.setString(1, username);
                rs = stmt.executeQuery();
                if (rs.next()) break block35;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no such user:" + username);
                }
                Principal principal = null;
                Object var9_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return principal;
            }
            String dbPassword = rs.getString(1);
            if (dbPassword == null || !dbPassword.equals(password)) break block39;
            CachingPrincipal cachingPrincipal = new CachingPrincipal(username);
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return cachingPrincipal;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("mismatched password:" + username);
        }
        Principal principal = null;
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return principal;
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected PasswordUser getPasswordUser(String username) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block27: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (rs.next()) break block27;
            if (log.isLoggable(Level.FINE)) {
                log.fine("no such user:" + username);
            }
            PasswordUser passwordUser = null;
            Object var8_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return passwordUser;
        }
        String dbPassword = rs.getString(1);
        PasswordUser passwordUser = new PasswordUser(new BasicPrincipal(username), dbPassword.toCharArray(), false, false, new String[0]);
        Object var8_9 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return passwordUser;
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Principal authenticateByCookie(String cookieValue) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block38: {
            block34: {
                if (this._cookieQuery == null) {
                    return null;
                }
                conn = null;
                stmt = null;
                rs = null;
                conn = this._dataSource.getConnection();
                stmt = conn.prepareStatement(this._cookieQuery);
                stmt.setString(1, cookieValue);
                rs = stmt.executeQuery();
                if (rs.next()) break block34;
                Principal principal = null;
                Object var8_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return principal;
            }
            String user = rs.getString(1);
            if (user == null) break block38;
            CachingPrincipal cachingPrincipal = new CachingPrincipal(user);
            Object var8_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return cachingPrincipal;
        }
        Principal principal = null;
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return principal;
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean associateCookie(Principal user, String cookieValue) {
        block20: {
            if (this._cookieUpdate == null || user == null || cookieValue == null) {
                return true;
            }
            Connection conn = null;
            PreparedStatement stmt = null;
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._cookieUpdate);
            stmt.setString(1, cookieValue);
            stmt.setString(2, user.getName());
            stmt.executeUpdate();
            Object var7_5 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block20;
            }
            catch (SQLException e2) {}
            break block20;
            {
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                    Object var7_6 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block20;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isUserInRole(Principal principal, String role) {
        Boolean isInRole;
        if (this._roleQuery == null) {
            return principal != null && "user".equals(role);
        }
        if (principal == null || role == null) {
            return false;
        }
        CachingPrincipal cachingPrincipal = null;
        if (principal instanceof CachingPrincipal && (isInRole = (cachingPrincipal = (CachingPrincipal)principal).isInRole(role)) != null) {
            return isInRole.equals(Boolean.TRUE);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this._dataSource.getConnection();
        stmt = conn.prepareStatement(this._roleQuery);
        stmt.setString(1, principal.getName());
        boolean inRole = false;
        rs = stmt.executeQuery();
        while (rs.next()) {
            String dbRole = rs.getString(1);
            if (cachingPrincipal != null) {
                cachingPrincipal.addRole(dbRole);
            }
            if (!role.equals(dbRole)) continue;
            inRole = true;
        }
        boolean bl = inRole;
        Object var10_12 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            try {
                log.log(Level.FINE, e.toString(), e);
                bl2 = false;
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return bl2;
        }
    }

    class JdbcUser
    implements AuthenticatedUser {
        private Principal _user;

        JdbcUser(Principal user) {
            this._user = user;
        }

        public String getName() {
            return this._user.getName();
        }

        public Principal getPrincipal() {
            return this._user;
        }

        public boolean isUserInRole(String role) {
            return DatabaseAuthenticator.this.isUserInRole(this._user, role);
        }

        public void logout() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getName() + "]";
        }
    }
}

