/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.security.AbstractAuthenticator;
import com.caucho.security.PasswordCredentials;
import com.caucho.server.security.RolePrincipal;
import com.caucho.util.L10N;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasAuthenticator
extends AbstractAuthenticator {
    private static final L10N L = new L10N(JaasAuthenticator.class);
    private static final Logger log = Logger.getLogger(JaasAuthenticator.class.getName());
    private Class<?> _loginModuleClass;
    private HashMap<String, String> _options = new HashMap();

    public JaasAuthenticator() {
        this.setPasswordDigest(null);
    }

    public void setLoginModule(Class<?> loginModuleClass) throws ConfigException {
        this._loginModuleClass = loginModuleClass;
        Config.checkCanInstantiate(loginModuleClass);
        if (!LoginModule.class.isAssignableFrom(loginModuleClass)) {
            throw new ConfigException(L.l("'{0}' must implement javax.security.auth.spi.LoginModule", loginModuleClass.getName()));
        }
    }

    public void setInitParam(InitParam init) {
        this._options.putAll(init.getParameters());
    }

    public void setOptions(InitParam init) {
        this._options.putAll(init.getParameters());
    }

    @Override
    @PostConstruct
    public synchronized void init() throws ServletException {
        super.init();
        if (this._loginModuleClass == null) {
            throw new ServletException(L.l("JaasAuthenticator requires login-module"));
        }
    }

    @Override
    protected Principal authenticate(Principal principal, PasswordCredentials cred, Object details) {
        try {
            String userName = principal.getName();
            String password = new String(cred.getPassword());
            LoginModule login = (LoginModule)this._loginModuleClass.newInstance();
            Subject subject = new Subject();
            HashMap<String, String> state = new HashMap<String, String>();
            state.put("javax.security.auth.login.name", userName);
            state.put("javax.security.auth.login.password", password);
            login.initialize(subject, new Handler(userName, password), state, this._options);
            try {
                login.login();
            }
            catch (Exception e) {
                login.abort();
            }
            login.commit();
            Set<Principal> principals = subject.getPrincipals();
            if (principals == null || principals.size() == 0) {
                return null;
            }
            Iterator<Principal> iter = principals.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
            return null;
        }
        catch (LoginException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isUserInRole(Principal principal, String role) {
        if (principal == null) {
            return false;
        }
        if (principal instanceof RolePrincipal) {
            return ((RolePrincipal)principal).isUserInRole(role);
        }
        return "user".equals(role);
    }

    static class Handler
    implements CallbackHandler {
        private String _userName;
        private String _password;

        Handler(String userName, String password) {
            this._userName = userName;
            this._password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback cb = callbacks[i];
                if (cb instanceof NameCallback) {
                    NameCallback name = (NameCallback)cb;
                    name.setName(this._userName);
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback password = (PasswordCallback)cb;
                password.setPassword(this._password.toCharArray());
            }
        }
    }
}

