/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security.x509;

import com.caucho.security.x509.BitString;
import com.caucho.security.x509.Oid;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class X509Parser {
    private static final L10N L = new L10N(X509Parser.class);

    public String parseCertificate(Path path) throws IOException {
        ReadStream is = path.openRead();
        try {
            String line;
            while ((line = is.readLine()) != null) {
                if (!line.startsWith("-----BEGIN CERTIFICATE---")) continue;
                String string = this.parseCertificateContent(is);
                Object var6_5 = null;
                is.close();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            is.close();
            throw throwable;
        }
        throw new IOException(L.l("Can't find certificate in '{0}'", path));
    }

    private String parseCertificateContent(ReadStream is) throws IOException {
        String line;
        TempOutputStream os = new TempOutputStream();
        LineReader reader = new LineReader();
        while ((line = is.readLine()) != null) {
            if (line.startsWith("-----END CERTIFICATE-----")) {
                System.out.println("TOTAL-LEN: " + os.getLength());
                return this.parseCertificateDer(os.openRead());
            }
            reader.init(line);
            Base64.decode(reader, os);
        }
        throw new IOException(L.l("Can't find end certificate"));
    }

    private String parseCertificateDer(ReadStream is) throws IOException {
        int len = this.parseSequenceHeader(is);
        this.parseTbsCertificate(is);
        this.parseSignatureAlgorithm(is);
        this.parseSignature(is);
        return "ok";
    }

    private void parseTbsCertificate(ReadStream is) throws IOException {
        int len = this.parseSequenceHeader(is);
        int field = this.parseFieldHeader(is);
        int version = 0;
        if (field >= 0) {
            version = (int)this.parseInteger(is);
        }
        System.out.println("Version: " + version);
        byte[] serial = this.parseBlob(is, 2);
        Oid algorithmOid = this.parseAlgorithmIdentifier(is);
        System.out.println("ALG: " + algorithmOid);
        System.out.println("ISSUER:");
        String issuer = this.parseName(is);
        this.parseValidity(is);
        System.out.println("SUBJECT:");
        String subject = this.parseName(is);
        this.parseSubjectPublicKeyInfo(is);
    }

    private void parseSignatureAlgorithm(ReadStream is) throws IOException {
    }

    private void parseSignature(ReadStream is) throws IOException {
    }

    private Oid parseAlgorithmIdentifier(ReadStream is) throws IOException {
        int len = this.parseSequenceHeader(is);
        Oid oid = this.parseOid(is);
        while (this.parseOid(is) != null) {
        }
        return oid;
    }

    private void parseSubjectPublicKeyInfo(ReadStream is) throws IOException {
        int len = this.parseSequenceHeader(is);
        long end = is.getPosition() + (long)len;
        while (is.getPosition() < end) {
            Object value = this.parseAny(is);
            System.out.println("PK: " + value);
        }
    }

    private String parseName(ReadStream is) throws IOException {
        int len;
        int length;
        System.out.println("LEN: " + length);
        for (length = this.parseSequenceHeader(is); length > 0; length -= 2 + len) {
            int code = is.read();
            if (code != 49) {
                throw new IOException(L.l("expected 0x31 at {0}", Integer.toHexString(code)));
            }
            len = this.parseLength(is);
            int sublen = this.parseSequenceHeader(is);
            Oid oid = this.parseOid(is);
            Object value = this.parseAny(is);
            System.out.println("NAME: " + oid + " " + value);
        }
        return "name";
    }

    private void parseValidity(ReadStream is) throws IOException {
        int len = this.parseSequenceHeader(is);
        long notBefore = this.parseUtcTime(is);
        long notAfter = this.parseUtcTime(is);
    }

    private Object parseAny(ReadStream is) throws IOException {
        int code = is.read();
        switch (code) {
            case 2: {
                is.unread();
                return this.parseInteger(is);
            }
            case 3: {
                is.unread();
                return this.parseBitString(is);
            }
            case 5: {
                int len = this.parseLength(is);
                is.skip(len);
                return null;
            }
            case 6: {
                is.unread();
                return this.parseOid(is);
            }
            case 19: {
                is.unread();
                return this.parsePrintableString(is);
            }
            case 22: {
                is.unread();
                return this.parseIa5String(is);
            }
            case 48: {
                is.unread();
                return this.parseSequence(is);
            }
        }
        System.out.println(String.format("UNKNOWN: %x", code));
        int len = this.parseLength(is);
        is.skip(len);
        return null;
    }

    private ArrayList parseSequence(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 48) {
            throw new IOException(L.l("expected 0x17 at '0x{0}'", Integer.toHexString(ch)));
        }
        int len = this.parseLength(is);
        long end = is.getPosition() + (long)len;
        ArrayList<Object> value = new ArrayList<Object>();
        while (is.getPosition() < end) {
            value.add(this.parseAny(is));
        }
        return value;
    }

    private long parseUtcTime(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 23) {
            throw new IOException(L.l("expected 0x17 at '{0}'", ch));
        }
        int len = this.parseLength(is);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append((char)is.read());
        }
        return 0L;
    }

    private BitString parseBitString(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 3) {
            throw new IOException(L.l("expected 0x03 at '{0}'", ch));
        }
        int len = this.parseLength(is);
        int unused = is.read();
        byte[] data = new byte[len - 1];
        is.readAll(data, 0, len - 1);
        return new BitString(data, unused);
    }

    private String parsePrintableString(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 19) {
            throw new IOException(L.l("expected 0x13 at '{0}'", ch));
        }
        int len = this.parseLength(is);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append((char)is.read());
        }
        return sb.toString();
    }

    private String parseIa5String(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 22) {
            throw new IOException(L.l("expected 0x13 at '{0}'", ch));
        }
        int len = this.parseLength(is);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append((char)is.read());
        }
        return sb.toString();
    }

    private Oid parseOid(ReadStream is) throws IOException {
        int ch = is.read();
        is.unread();
        if (ch == 5) {
            this.parseNull(is);
            return null;
        }
        return new Oid(this.parseBlob(is, 6));
    }

    private int parseSequenceHeader(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 48) {
            throw new IOException(L.l("expected sequence 0x30 at {0}", Integer.toHexString(ch)));
        }
        return this.parseLength(is);
    }

    private int parseFieldHeader(ReadStream is) throws IOException {
        int ch = is.read();
        if ((ch & 0xF0) != 160) {
            is.unread();
            return -1;
        }
        int len = this.parseLength(is);
        return ch & 0xF;
    }

    private long parseInteger(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 2) {
            throw new IOException(L.l("expected sequence 0x02 at {0}", Integer.toHexString(ch)));
        }
        int len = this.parseLength(is);
        long v = 0L;
        for (int i = 0; i < len; ++i) {
            v = 256L * v + (long)is.read();
        }
        return v;
    }

    private void parseNull(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 5) {
            throw new IOException(L.l("expected sequence 0x05 at {0}", Integer.toHexString(ch)));
        }
        int len = this.parseLength(is);
        is.skip(len);
    }

    private byte[] parseBlob(ReadStream is, int code) throws IOException {
        int ch = is.read();
        if (code != 0 && ch != code) {
            throw new IOException(L.l("expected value {0} at {1}", (Object)Integer.toHexString(code), Integer.toHexString(ch)));
        }
        int len = this.parseLength(is);
        byte[] data = new byte[len];
        is.readAll(data, 0, data.length);
        return data;
    }

    private int parseLength(ReadStream is) throws IOException {
        int ch = is.read();
        if ((ch & 0x80) == 0) {
            return ch & 0x7F;
        }
        int count = ch & 0x7F;
        int len = 0;
        for (int i = 0; i < count; ++i) {
            len = 256 * len + is.read();
        }
        return len;
    }

    static class LineReader
    extends Reader {
        String _string;
        int _offset;
        int _length;

        LineReader() {
        }

        void init(String string) {
            this._string = string;
            this._offset = 0;
            this._length = string.length();
        }

        public int read() {
            if (this._offset < this._length) {
                return this._string.charAt(this._offset++);
            }
            return -1;
        }

        public int read(char[] buffer, int offset, int length) {
            if (this._offset < this._length) {
                buffer[offset] = this._string.charAt(this._offset++);
                return 1;
            }
            return -1;
        }

        public void close() {
        }
    }
}

