/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.bam.ActorClient;
import com.caucho.bam.Broker;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.ServiceUnavailableException;
import com.caucho.cloud.deploy.CopyTagQuery;
import com.caucho.cloud.deploy.RemoveTagQuery;
import com.caucho.cloud.deploy.SetTagQuery;
import com.caucho.env.git.GitCommitJar;
import com.caucho.env.git.GitCommitTree;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositoryException;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.env.repository.RepositoryTagListener;
import com.caucho.hmtp.HmtpClient;
import com.caucho.server.admin.ControllerDeployQuery;
import com.caucho.server.admin.ControllerStartQuery;
import com.caucho.server.admin.ControllerStopQuery;
import com.caucho.server.admin.DeployAddFileQuery;
import com.caucho.server.admin.DeployCommitListQuery;
import com.caucho.server.admin.DeploySendQuery;
import com.caucho.server.admin.GitJarStreamSource;
import com.caucho.server.admin.HostQuery;
import com.caucho.server.admin.ListHostsQuery;
import com.caucho.server.admin.ListTagsQuery;
import com.caucho.server.admin.ListWebAppsQuery;
import com.caucho.server.admin.QueryTagsQuery;
import com.caucho.server.admin.StatusQuery;
import com.caucho.server.admin.TagQuery;
import com.caucho.server.admin.TagResult;
import com.caucho.server.admin.TagStateQuery;
import com.caucho.server.admin.WebAppQuery;
import com.caucho.server.cluster.Server;
import com.caucho.util.L10N;
import com.caucho.vfs.InputStreamSource;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployClient
implements Repository {
    private static final L10N L = new L10N(DeployClient.class);
    public static final String USER_ATTRIBUTE = "user";
    public static final String MESSAGE_ATTRIBUTE = "message";
    public static final String VERSION_ATTRIBUTE = "version";
    private Broker _broker;
    private ActorClient _bamClient;
    private String _deployJid;
    private String _url;

    public DeployClient() {
        Server server = Server.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("DeployClient was not called in a Resin context. For external clients, use the DeployClient constructor with host,port arguments."));
        }
        this._bamClient = server.createAdminClient(this.getClass().getSimpleName());
        this._deployJid = "deploy@resin.caucho";
    }

    public DeployClient(String serverId) {
        Server server = Server.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("DeployClient was not called in a Resin context. For external clients, use the DeployClient constructor with host,port arguments."));
        }
        this._bamClient = server.createAdminClient(this.getClass().getSimpleName());
        this._deployJid = "deploy@" + serverId + ".resin.caucho";
    }

    public DeployClient(String host, int port, String userName, String password) {
        String url;
        this._url = url = "http://" + host + ":" + port + "/hmtp";
        HmtpClient client = new HmtpClient(url);
        try {
            client.setVirtualHost("admin.resin");
            client.connect(userName, password);
            this._bamClient = client;
            this._deployJid = "deploy@resin.caucho";
        }
        catch (RemoteConnectionFailedException e) {
            throw new RemoteConnectionFailedException(L.l("Connection to '{0}' failed for remote deploy. Check the server and make sure <resin:RemoteAdminService> is enabled in the resin.xml.\n  {1}", (Object)url, e.getMessage()), e);
        }
    }

    public String getUrl() {
        return this._url;
    }

    @Override
    public String commitArchive(CommitBuilder commit, Path jar) {
        commit.validate();
        GitCommitJar gitCommit = null;
        try {
            gitCommit = new GitCommitJar(jar);
            String tag = commit.getId();
            String string = this.deployJar(tag, gitCommit, commit.getAttributes());
            Object var7_7 = null;
            if (gitCommit != null) {
                gitCommit.close();
            }
            return string;
        }
        catch (IOException e) {
            try {
                throw new RepositoryException(e);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_8 = null;
                    if (gitCommit == null) break block5;
                    gitCommit.close();
                }
                throw throwable;
            }
        }
    }

    @Override
    public String commitArchive(CommitBuilder commit, InputStream is) {
        commit.validate();
        GitCommitJar gitCommit = null;
        try {
            gitCommit = new GitCommitJar(is);
            String tag = commit.getId();
            String string = this.deployJar(tag, gitCommit, commit.getAttributes());
            Object var7_7 = null;
            if (gitCommit != null) {
                gitCommit.close();
            }
            return string;
        }
        catch (IOException e) {
            try {
                throw new RepositoryException(e);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_8 = null;
                    if (gitCommit == null) break block5;
                    gitCommit.close();
                }
                throw throwable;
            }
        }
    }

    @Override
    public String commitPath(CommitBuilder commit, Path path) {
        commit.validate();
        GitCommitJar gitCommit = null;
        try {
            gitCommit = new GitCommitJar(path);
            String tag = commit.getId();
            String string = this.deployJar(tag, gitCommit, commit.getAttributes());
            Object var7_7 = null;
            if (gitCommit != null) {
                gitCommit.close();
            }
            return string;
        }
        catch (IOException e) {
            try {
                throw new RepositoryException(e);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_8 = null;
                    if (gitCommit == null) break block5;
                    gitCommit.close();
                }
                throw throwable;
            }
        }
    }

    public Boolean copyTag(CommitBuilder target, CommitBuilder source) {
        target.validate();
        source.validate();
        String targetId = target.getId();
        String sourceId = source.getId();
        CopyTagQuery query = new CopyTagQuery(targetId, sourceId, target.getAttributes());
        return (Boolean)this.querySet(query);
    }

    @Override
    public boolean removeTag(CommitBuilder commit) {
        commit.validate();
        String tag = commit.getId();
        RemoveTagQuery query = new RemoveTagQuery(tag, commit.getAttributes());
        return (Boolean)this.querySet(query);
    }

    public String getTagState(String tag) {
        TagStateQuery query = new TagStateQuery(tag);
        if ((query = (TagStateQuery)this.queryGet(query)) != null) {
            return query.getState();
        }
        return null;
    }

    public Throwable getTagException(String tag) {
        TagStateQuery query = new TagStateQuery(tag);
        if ((query = (TagStateQuery)this.queryGet(query)) != null) {
            return query.getThrowable();
        }
        return null;
    }

    private String deployJar(String tag, GitCommitJar commit, Map<String, String> attributes) throws IOException {
        String[] files;
        for (String sha1 : files = this.getCommitList(commit.getCommitList())) {
            GitJarStreamSource gitSource = new GitJarStreamSource(sha1, commit);
            StreamSource source = new StreamSource(gitSource);
            DeploySendQuery query = new DeploySendQuery(sha1, source);
            this.querySet(query);
        }
        this.putTag(tag, commit.getDigest(), attributes);
        return commit.getDigest();
    }

    public void sendFile(String sha1, long length, InputStream is) throws IOException {
        InputStream blobIs = GitCommitTree.writeBlob(is, length);
        this.writeRawGitFile(sha1, blobIs);
    }

    public void writeRawGitFile(String sha1, InputStream is) throws IOException {
        InputStreamSource iss = new InputStreamSource(is);
        StreamSource source = new StreamSource(iss);
        DeploySendQuery query = new DeploySendQuery(sha1, source);
        this.querySet(query);
    }

    public String[] getCommitList(String[] commitList) {
        DeployCommitListQuery query = new DeployCommitListQuery(commitList);
        DeployCommitListQuery result = (DeployCommitListQuery)this.queryGet(query);
        return result.getCommitList();
    }

    public String calculateFileDigest(InputStream is, long length) throws IOException {
        return GitCommitTree.calculateBlobDigest(is, length);
    }

    public String addDeployFile(String tag, String name, String sha1) {
        DeployAddFileQuery query = new DeployAddFileQuery(tag, name, sha1);
        return (String)((Object)this.querySet(query));
    }

    private boolean putTag(String tag, String contentHash, Map<String, String> attributes) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (contentHash == null) {
            throw new NullPointerException();
        }
        HashMap<String, String> attributeCopy = attributes != null ? new HashMap<String, String>(attributes) : new HashMap();
        SetTagQuery query = new SetTagQuery(tag, contentHash, attributeCopy);
        this.querySet(query);
        return true;
    }

    private String setTag(String tag, String contentHash, HashMap<String, String> attributes) {
        HashMap<String, String> attributeCopy = attributes != null ? new HashMap<String, String>(attributes) : new HashMap();
        SetTagQuery query = new SetTagQuery(tag, contentHash, attributeCopy);
        return (String)((Object)this.querySet(query));
    }

    public TagResult[] queryTags(String pattern) {
        QueryTagsQuery query = new QueryTagsQuery(pattern);
        return (TagResult[])this.queryGet(query);
    }

    public Boolean start(String tag) {
        ControllerStartQuery query = new ControllerStartQuery(tag);
        return (Boolean)this.querySet(query);
    }

    public Boolean stop(String tag) {
        ControllerStopQuery query = new ControllerStopQuery(tag);
        return (Boolean)this.querySet(query);
    }

    public Boolean deploy(String tag) {
        ControllerDeployQuery query = new ControllerDeployQuery(tag);
        return (Boolean)this.querySet(query);
    }

    public boolean undeploy(CommitBuilder tag) {
        return this.removeTag(tag);
    }

    public StatusQuery status(String tag) {
        StatusQuery query = new StatusQuery(tag);
        return (StatusQuery)this.queryGet(query);
    }

    public HostQuery[] listHosts() {
        ListHostsQuery query = new ListHostsQuery();
        return (HostQuery[])this.queryGet(query);
    }

    public WebAppQuery[] listWebApps(String host) {
        return (WebAppQuery[])this.queryGet(new ListWebAppsQuery(host));
    }

    public TagQuery[] listTags(String host) {
        return (TagQuery[])this.queryGet(new ListTagsQuery(host));
    }

    protected Serializable queryGet(Serializable query) {
        try {
            return this._bamClient.queryGet(this._deployJid, query);
        }
        catch (ServiceUnavailableException e) {
            throw new ServiceUnavailableException("Deploy service is not available, possibly because the resin.xml is missing a <resin:DeployService> tag\n  " + e.getMessage(), e);
        }
    }

    public void close() {
        this._bamClient.close();
    }

    protected Serializable querySet(Serializable query) {
        return this._bamClient.querySet(this._deployJid, query);
    }

    public String toString() {
        if (this._broker != null) {
            return this.getClass().getSimpleName() + "[" + this._deployJid + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._bamClient + "]";
    }

    @Override
    public void addListener(String tagName, RepositoryTagListener listener) {
    }

    @Override
    public String getTagContentHash(String tag) {
        return null;
    }

    @Override
    public Map<String, RepositoryTagEntry> getTagMap() {
        return null;
    }

    @Override
    public void removeListener(String tagName, RepositoryTagListener listener) {
    }
}

