/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HessianHmuxProxy
implements InvocationHandler {
    private static final L10N L = new L10N(HessianHmuxProxy.class);
    private Path _path;

    private HessianHmuxProxy(Path url) {
        this._path = url;
    }

    public static <X> X create(Path url, Class<X> api) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return (X)Proxy.newProxyInstance(loader, new Class[]{api}, (InvocationHandler)new HessianHmuxProxy(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null) return new Boolean(false);
            if (!Proxy.isProxyClass(value.getClass())) {
                return new Boolean(false);
            }
            HessianHmuxProxy handler = (HessianHmuxProxy)Proxy.getInvocationHandler(value);
            return new Boolean(this._path.equals(handler._path));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this._path.hashCode());
        }
        if (methodName.equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
        }
        if (methodName.equals("getHessianURL")) {
            return this._path.toString();
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "HessianHmuxProxy[" + this._path + "]";
        }
        ReadStream is = null;
        try {
            try {
                methodName = args != null ? methodName + "__" + args.length : methodName + "__0";
                is = this.sendRequest(methodName, args);
                String code = (String)is.getAttribute("status");
                if (!"200".equals(code)) {
                    CharBuffer sb = new CharBuffer();
                    int count = 1024;
                    while (is.readLine(sb, false)) {
                        if (count-- < 0) throw new HessianProtocolException(code + ": " + sb);
                    }
                    throw new HessianProtocolException(code + ": " + sb);
                }
                int ch = is.read();
                if (ch != 72) {
                    throw new HessianProtocolException(L.l("expected 'H' at '{0}'", ch));
                }
                int major = is.read();
                int minor = is.read();
                Hessian2Input in = new Hessian2Input(is);
                object = ((AbstractHessianInput)in).readReply(method.getReturnType());
                Object var14_18 = null;
            }
            catch (HessianProtocolException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (Throwable e2) {
                throw throwable;
            }
        }
        try {}
        catch (Throwable e2) {
            // empty catch block
            return object;
        }
        if (is == null) return object;
        is.close();
        return object;
    }

    private ReadStream sendRequest(String methodName, Object[] args) throws IOException {
        ReadWritePair pair = this._path.openReadWrite();
        ReadStream is = pair.getReadStream();
        WriteStream os = pair.getWriteStream();
        try {
            Hessian2Output out = new Hessian2Output(os);
            out.writeVersion();
            out.call(methodName, args);
            out.flush();
            return is;
        }
        catch (IOException e) {
            try {
                os.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                os.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }
}

