/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.server.admin.DeployClient;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.logging.Logger;

public class WebAppDeployClient
extends DeployClient {
    private static final L10N L = new L10N(WebAppDeployClient.class);
    private static final Logger log = Logger.getLogger(WebAppDeployClient.class.getName());

    public WebAppDeployClient() {
    }

    public WebAppDeployClient(String serverId) {
        super(serverId);
    }

    public WebAppDeployClient(String host, int port, String userName, String password) {
        super(host, port, userName, password);
    }

    public static String createTag(String stage, String host, String name) {
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        return stage + "/webapp/" + host + "/" + name;
    }

    public static String createTag(String stage, String host, String name, String version) {
        if (version != null) {
            return WebAppDeployClient.createTag(stage, host, name) + "-" + version;
        }
        return WebAppDeployClient.createTag(stage, host, name);
    }

    public static String createArchiveTag(String host, String name, String version) {
        QDate qDate = new QDate();
        long time = qDate.getTimeOfDay() / 1000L;
        StringBuilder sb = new StringBuilder();
        sb.append(WebAppDeployClient.createTag("archive", host, name, version));
        sb.append('/');
        sb.append(qDate.printISO8601Date());
        sb.append('T');
        sb.append(time / 36000L % 10L);
        sb.append(time / 3600L % 10L);
        sb.append(':');
        sb.append(time / 600L % 6L);
        sb.append(time / 60L % 10L);
        sb.append(':');
        sb.append(time / 10L % 6L);
        sb.append(time / 1L % 10L);
        return sb.toString();
    }
}

