/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.make.DependencyContainer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.PrecompilePageFilterChain;
import com.caucho.server.dispatch.RedirectFilterChain;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.SubInvocation;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMapper {
    private static final Logger log = Logger.getLogger(ServletMapper.class.getName());
    private static final L10N L = new L10N(ServletMapper.class);
    private static final HashSet<String> _welcomeFileResourceMap = new HashSet();
    private WebApp _webApp;
    private ServletManager _servletManager;
    private UrlMap<ServletMapping> _servletMap = new UrlMap();
    private ArrayList<String> _welcomeFileList = new ArrayList();
    private HashMap<String, ServletMapping> _regexpMap = new HashMap();
    private ArrayList<String> _ignorePatterns = new ArrayList();
    private String _defaultServlet;
    private Map<String, Set<String>> _urlPatterns = new HashMap<String, Set<String>>();
    private Map<String, String> _servletNamesMap = new HashMap<String, String>();

    public ServletMapper(WebApp webApp) {
        this._webApp = webApp;
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public ServletManager getServletManager() {
        return this._servletManager;
    }

    public void setServletManager(ServletManager manager) {
        this._servletManager = manager;
    }

    public void addUrlRegexp(String regexp, String servletName, ServletMapping mapping) throws ServletException {
        this._servletMap.addRegexp(regexp, mapping);
        this._regexpMap.put(servletName, mapping);
    }

    void addUrlMapping(String urlPattern, String servletName, ServletMapping mapping, boolean ifAbsent) throws ServletException {
        try {
            boolean isIgnore = false;
            if (mapping.isInFragmentMode() && this._servletMap.contains(new FragmentFilter(servletName))) {
                return;
            }
            if (servletName == null) {
                throw new ConfigException(L.l("servlets need a servlet-name."));
            }
            if (!servletName.equals("invoker")) {
                if (servletName.equals("plugin_match") || servletName.equals("plugin-match")) {
                    isIgnore = true;
                } else {
                    if (servletName.equals("plugin_ignore") || servletName.equals("plugin-ignore")) {
                        if (urlPattern != null) {
                            this._ignorePatterns.add(urlPattern);
                        }
                        return;
                    }
                    if (mapping.getBean() == null && this._servletManager.getServlet(servletName) == null) {
                        throw new ConfigException(L.l("'{0}' is an unknown servlet-name.  servlet-mapping requires that the named servlet be defined in a <servlet> configuration before the <servlet-mapping>.", servletName));
                    }
                }
            }
            if ("/".equals(urlPattern)) {
                this._defaultServlet = servletName;
            } else if (mapping.isStrictMapping()) {
                this._servletMap.addStrictMap(urlPattern, null, mapping);
            } else {
                this._servletMap.addMap(urlPattern, mapping, isIgnore, ifAbsent);
            }
            Set<String> patterns = this._urlPatterns.get(servletName);
            if (patterns == null) {
                patterns = new HashSet<String>();
                this._urlPatterns.put(servletName, patterns);
            }
            this._servletNamesMap.put(urlPattern, servletName);
            patterns.add(urlPattern);
            log.config("servlet-mapping " + urlPattern + " -> " + servletName);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Set<String> getUrlPatterns(String servletName) {
        return this._urlPatterns.get(servletName);
    }

    public void setDefaultServlet(String servletName) throws ServletException {
        this._defaultServlet = servletName;
    }

    public void addWelcomeFile(String fileName) {
        ArrayList<String> welcomeFileList = new ArrayList<String>(this._welcomeFileList);
        welcomeFileList.add(fileName);
        this._welcomeFileList = welcomeFileList;
    }

    public void setWelcomeFileList(ArrayList<String> list) {
        this._welcomeFileList = new ArrayList<String>(list);
    }

    public FilterChain mapServlet(ServletInvocation invocation) throws ServletException {
        FilterChain chain;
        ServletConfigImpl newConfig;
        MatchResult matchResult;
        String contextURI = invocation.getContextURI();
        String servletName = null;
        ArrayList<String> vars = new ArrayList<String>();
        invocation.setClassLoader(Thread.currentThread().getContextClassLoader());
        ServletConfigImpl config = null;
        if (this._servletMap != null) {
            ServletMapping servletRegexp;
            ServletMapping servletMap = this._servletMap.map(contextURI, vars);
            if (servletMap != null && servletMap.isServletConfig()) {
                config = servletMap;
            }
            if ((servletRegexp = this._regexpMap.get(servletName)) != null) {
                servletName = servletRegexp.initRegexp(this._webApp, this._servletManager, vars);
            } else if (servletMap != null) {
                servletName = servletMap.getServletName();
            }
        }
        if (servletName == null) {
            try {
                InputStream is = this._webApp.getResourceAsStream(contextURI);
                if (is != null) {
                    is.close();
                    servletName = this._defaultServlet;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((matchResult = null) == null && contextURI.endsWith("j_security_check")) {
            servletName = "j_security_check";
        }
        if (servletName == null) {
            matchResult = null;
            if (matchResult != null) {
                servletName = matchResult.getServletName();
            }
            if (matchResult != null && !contextURI.endsWith("/") && !(invocation instanceof SubInvocation)) {
                String contextPath = invocation.getContextPath();
                return new RedirectFilterChain(contextPath + contextURI + "/");
            }
            if (matchResult != null && invocation instanceof Invocation) {
                Invocation inv = (Invocation)invocation;
                inv.setContextURI(matchResult.getContextUri());
            }
        }
        if (servletName == null) {
            servletName = this._defaultServlet;
            vars.clear();
            if (matchResult != null) {
                vars.add(matchResult.getContextUri());
            } else {
                vars.add(contextURI);
            }
            this.addWelcomeFileDependency(invocation);
        }
        if (servletName == null) {
            log.fine(L.l("'{0}' has no default servlet defined", contextURI));
            return new ErrorFilterChain(404);
        }
        String servletPath = vars.get(0);
        invocation.setServletPath(servletPath);
        if (servletPath.length() < contextURI.length()) {
            invocation.setPathInfo(contextURI.substring(servletPath.length()));
        } else {
            invocation.setPathInfo(null);
        }
        ServletMapping regexp = this._regexpMap.get(servletName);
        if (regexp != null) {
            servletName = regexp.initRegexp(this._webApp, this._servletManager, vars);
            if (servletName == null) {
                log.fine(L.l("'{0}' has no matching servlet", contextURI));
                return new ErrorFilterChain(404);
            }
            if (regexp.isServletConfig()) {
                config = regexp;
            }
        }
        if (servletName.equals("invoker")) {
            servletName = this.handleInvoker(invocation);
        }
        invocation.setServletName(servletName);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this._webApp + " map (uri:" + contextURI + " -> " + servletName + ")");
        }
        if ((newConfig = this._servletManager.getServlet(servletName)) != null) {
            config = newConfig;
        }
        if (config != null) {
            invocation.setSecurityRoleMap(config.getRoleMap());
        }
        if ((chain = this._servletManager.createServletChain(servletName, config, invocation)) instanceof PageFilterChain) {
            PageFilterChain pageChain = (PageFilterChain)chain;
            chain = PrecompilePageFilterChain.create(invocation, pageChain);
        }
        return chain;
    }

    private MatchResult matchWelcomeFileResource(ServletInvocation invocation, ArrayList<String> vars) {
        String contextURI = invocation.getContextURI();
        try {
            Path path = this._webApp.getCauchoPath(contextURI);
            if (!path.exists()) {
                return null;
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("can't match a welcome file path {0}", contextURI), e);
            }
            return null;
        }
        ArrayList<String> welcomeFileList = this._welcomeFileList;
        int size = welcomeFileList.size();
        for (int i = 0; i < size; ++i) {
            String file = welcomeFileList.get(i);
            try {
                String welcomeURI = contextURI.endsWith("/") ? contextURI + file : contextURI + '/' + file;
                ServletMapping servletMap = this._servletMap.map(welcomeURI, vars);
                String servletName = null;
                String servletClass = null;
                if (servletMap != null) {
                    servletName = servletMap.getServletName();
                    servletClass = servletMap.getServletClassName();
                }
                if (servletName == null && this._defaultServlet == null) continue;
                if (servletClass == null) {
                    ServletConfigImpl servlet = null;
                    if (servletName != null) {
                        servlet = this._servletManager.getServlet(servletName);
                    } else if (this._defaultServlet != null) {
                        servlet = this._servletManager.getServlet(this._defaultServlet);
                    }
                    if (servlet != null) {
                        servletClass = servlet.getServletClassName();
                    }
                }
                if (servletClass != null && this.isWelcomeFileResource(servletClass) || servletName == null) {
                    InputStream is = this._webApp.getResourceAsStream(welcomeURI);
                    if (is != null) {
                        is.close();
                    }
                    if (is == null) continue;
                }
                if (servletName == null && this._defaultServlet == null) continue;
                contextURI = welcomeURI;
                return new MatchResult(servletName, contextURI);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return null;
    }

    private boolean isWelcomeFileResource(String servletName) {
        return _welcomeFileResourceMap.contains(servletName);
    }

    private void addWelcomeFileDependency(ServletInvocation servletInvocation) {
        if (!(servletInvocation instanceof Invocation)) {
            return;
        }
        Invocation invocation = (Invocation)servletInvocation;
        String contextURI = invocation.getContextURI();
        DependencyContainer dependencyList = new DependencyContainer();
        WebApp app = this._webApp;
        Path contextPath = app.getRootDirectory().lookup(app.getRealPath(contextURI));
        if (!contextPath.isDirectory()) {
            return;
        }
        for (int i = 0; i < this._welcomeFileList.size(); ++i) {
            String file = this._welcomeFileList.get(i);
            String realPath = app.getRealPath(contextURI + "/" + file);
            Path path = app.getRootDirectory().lookup(realPath);
            dependencyList.add(new Depend(path));
        }
        dependencyList.clearModified();
        invocation.setDependency(dependencyList);
    }

    private String handleInvoker(ServletInvocation invocation) throws ServletException {
        String tail = invocation.getPathInfo() != null ? invocation.getPathInfo() : invocation.getServletPath();
        if (!tail.startsWith("/")) {
            throw new ConfigException("expected '/' starting  sp:" + invocation.getServletPath() + " pi:" + invocation.getPathInfo() + " sn:invocation" + invocation);
        }
        int next = tail.indexOf(47, 1);
        String servletName = next < 0 ? tail.substring(1) : tail.substring(1, next);
        if (servletName.startsWith("com.caucho")) {
            throw new ConfigException(L.l("servlet '{0}' forbidden from invoker. com.caucho.* classes must be defined explicitly in a <servlet> declaration.", servletName));
        }
        if (servletName.equals("")) {
            throw new ConfigException(L.l("invoker needs a servlet name in URL '{0}'.", invocation.getContextURI()));
        }
        this.addServlet(servletName);
        String servletPath = invocation.getServletPath();
        if (invocation.getPathInfo() != null) {
            if (next < 0) {
                invocation.setServletPath(servletPath + tail);
                invocation.setPathInfo(null);
            } else if (next < tail.length()) {
                invocation.setServletPath(servletPath + tail.substring(0, next));
                invocation.setPathInfo(tail.substring(next));
            } else {
                invocation.setServletPath(servletPath + tail);
                invocation.setPathInfo(null);
            }
        }
        return servletName;
    }

    public String getServletPattern(String uri) {
        ArrayList<String> vars = new ArrayList<String>();
        ServletMapping value = null;
        if (this._servletMap != null) {
            value = this._servletMap.map(uri, vars);
        }
        if (value != null) {
            return uri;
        }
        return null;
    }

    public String getServletClassByUri(String uri) {
        ArrayList<String> vars = new ArrayList<String>();
        ServletConfigImpl value = null;
        if (this._servletMap != null) {
            value = this._servletMap.map(uri, vars);
        }
        if (value != null) {
            Class servletClass = value.getServletClass();
            if (servletClass != null) {
                return value.getServletClass().getName();
            }
            String servletName = value.getServletName();
            ServletConfigImpl config = this._servletManager.getServlet(servletName);
            if (config != null) {
                return config.getServletClassName();
            }
            return servletName;
        }
        return null;
    }

    public ArrayList<String> getURLPatterns() {
        ArrayList<String> patterns = this._servletMap.getURLPatterns();
        return patterns;
    }

    public String getServletName(String pattern) {
        return this._servletNamesMap.get(pattern);
    }

    public ArrayList<String> getIgnorePatterns() {
        return this._ignorePatterns;
    }

    private void addServlet(String servletName) throws ServletException {
        if (this._servletManager.getServlet(servletName) != null) {
            return;
        }
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletContext(this._webApp);
        config.setServletName(servletName);
        try {
            config.setServletClass(servletName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        config.init();
        this._servletManager.addServlet(config);
    }

    public void destroy() {
        this._servletManager.destroy();
    }

    static {
        _welcomeFileResourceMap.add("com.caucho.servlets.FileServlet");
        _welcomeFileResourceMap.add("com.caucho.jsp.JspServlet");
        _welcomeFileResourceMap.add("com.caucho.jsp.JspXmlServlet");
        _welcomeFileResourceMap.add("com.caucho.quercus.servlet.QuercusServlet");
        _welcomeFileResourceMap.add("com.caucho.jsp.XtpServlet");
    }

    private static class MatchResult {
        String _servletName;
        String _contextUri;

        private MatchResult(String servletName, String contextUri) {
            this._servletName = servletName;
            this._contextUri = contextUri;
        }

        public String getServletName() {
            return this._servletName;
        }

        public String getContextUri() {
            return this._contextUri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FragmentFilter
    implements UrlMap.Filter<ServletMapping> {
        private String _servletName;

        public FragmentFilter(String servletName) {
            this._servletName = servletName;
        }

        @Override
        public boolean isMatch(ServletMapping item) {
            return this._servletName.equals(item.getServletName());
        }
    }
}

